/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiAddBillApplyInfoByItemsService;
import com.tydic.pfscext.api.busi.BusiAddBillApplyInfoByTaxRateService;
import com.tydic.pfscext.api.busi.bo.BusiAddBillApplyInfoByItemsDetailReqBO;
import com.tydic.pfscext.api.busi.bo.BusiAddBillApplyInfoByItemsReqBO;
import com.tydic.pfscext.api.busi.bo.BusiAddBillApplyInfoByItemsRspBO;
import com.tydic.pfscext.api.busi.bo.BusiAddBillApplyInfoByTaxRateReqBO;
import com.tydic.pfscext.api.busi.bo.BusiAddBillApplyInfoByTaxRateRspBO;
import com.tydic.pfscext.api.busi.vo.InvoiceHeaderVO;
import com.tydic.pfscext.api.busi.vo.InvoiceMailAddrInfoVO;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@Service(version="1.0.0", group="FSC_GROUP_DEV", interfaceClass=BusiAddBillApplyInfoByTaxRateService.class)
public class BusiAddBillApplyInfoByTaxRateServiceImpl
implements BusiAddBillApplyInfoByTaxRateService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAddBillApplyInfoByTaxRateServiceImpl.class);
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private BusiAddBillApplyInfoByItemsService busiAddBillApplyInfoByItemsService;

    public BusiAddBillApplyInfoByTaxRateRspBO add(BusiAddBillApplyInfoByTaxRateReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5408\u5e76\u5f00\u7968\u65b0\u8d60\u5f00\u7968\u7533\u8bf7\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InvoiceHeaderVO invoiceInfo = reqBO.getInvoiceInfo();
        InvoiceMailAddrInfoVO mailAddrInfo = reqBO.getMailAddrInfo();
        List inspectionIds = reqBO.getInspectionIds();
        if (invoiceInfo == null) {
            throw new PfscExtBusinessException("18000", "\u53d1\u7968\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        if (!StringUtils.hasText((String)invoiceInfo.getInvoiceTitle())) {
            throw new PfscExtBusinessException("18000", "\u53d1\u7968\u4fe1\u606f\u4e2d\u7684\u53d1\u7968\u62ac\u5934\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (mailAddrInfo == null || !StringUtils.hasText((String)mailAddrInfo.getName())) {
            throw new PfscExtBusinessException("18000", "\u90ae\u5bc4\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        if (CollectionUtils.isEmpty((Collection)inspectionIds)) {
            throw new PfscExtBusinessException("18000", "\u8bf7\u9009\u62e9\u8ba2\u5355\u6570\u636e");
        }
        LinkedList<BusiAddBillApplyInfoByItemsDetailReqBO> detailInfoList = new LinkedList<BusiAddBillApplyInfoByItemsDetailReqBO>();
        SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
        saleItemInfoVO.setInspectionIdList(inspectionIds);
        saleItemInfoVO.setItemStatus(OrderStatus.NO_APPLY.getCode());
        List<SaleItemInfoVO> saleItemList = this.saleItemInfoMapper.querySaleJoinOrderItemList(saleItemInfoVO);
        if (CollectionUtils.isEmpty(saleItemList)) {
            throw new PfscExtBusinessException("18000", "\u4e0d\u5b58\u5728\u672a\u63d0\u4ea4\u7684\u5546\u54c1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        for (SaleItemInfoVO saleItemVO : saleItemList) {
            BigDecimal quantityRemain = saleItemVO.getQuantity().subtract(saleItemVO.getQuantityApplied());
            BigDecimal amountRemain = saleItemVO.getAmount().subtract(saleItemVO.getAmountApplied());
            if (quantityRemain.compareTo(BigDecimal.ZERO) <= 0 || amountRemain.compareTo(BigDecimal.ZERO) <= 0) continue;
            BusiAddBillApplyInfoByItemsDetailReqBO detailReqBO = new BusiAddBillApplyInfoByItemsDetailReqBO();
            detailReqBO.setSeq(saleItemVO.getSeq());
            detailReqBO.setQuantityApply(quantityRemain);
            detailInfoList.add(detailReqBO);
        }
        if (CollectionUtils.isEmpty(detailInfoList)) {
            throw new PfscExtBusinessException("18000", "\u4e0d\u5b58\u5728\u672a\u63d0\u4ea4\u7684\u5546\u54c1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        BusiAddBillApplyInfoByItemsReqBO busiAddBillApplyInfoByItemsReqBO = new BusiAddBillApplyInfoByItemsReqBO();
        busiAddBillApplyInfoByItemsReqBO.setInvoiceInfo(invoiceInfo);
        busiAddBillApplyInfoByItemsReqBO.setMailAddrInfo(mailAddrInfo);
        busiAddBillApplyInfoByItemsReqBO.setDetailInfoList(detailInfoList);
        busiAddBillApplyInfoByItemsReqBO.setUserId(reqBO.getUserId());
        try {
            BusiAddBillApplyInfoByItemsRspBO itemRspBO = this.busiAddBillApplyInfoByItemsService.add(busiAddBillApplyInfoByItemsReqBO);
            BusiAddBillApplyInfoByTaxRateRspBO rspBO = new BusiAddBillApplyInfoByTaxRateRspBO();
            rspBO.setMsg(itemRspBO.getMsg());
            return rspBO;
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("18000", "\u6dfb\u52a0\u5f02\u5e38");
        }
    }
}

