/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiAddPreRecAmtConfirmService;
import com.tydic.pfscext.api.busi.bo.BusiAddPreHeadRecAmtConfirmRspBO;
import com.tydic.pfscext.api.busi.bo.BusiAddPreRecAmtConfirmReqBO;
import com.tydic.pfscext.api.busi.bo.BusiAddPreRecAmtConfirmRspBO;
import com.tydic.pfscext.api.busi.bo.BusiAddPreRowRecAmtConfirmRspBO;
import com.tydic.pfscext.api.busi.bo.SubAcctInfoExt;
import com.tydic.pfscext.dao.AdvanceReceiveMapper;
import com.tydic.pfscext.dao.RecAmtConfirmMapper;
import com.tydic.pfscext.dao.po.AdvanceReceive;
import com.tydic.pfscext.dao.po.RecAmtConfirm;
import com.tydic.pfscext.dao.vo.AdvanceReceiveVO;
import com.tydic.pfscext.enums.AdvanceReceiveStatus;
import com.tydic.pfscext.enums.BaseEnums;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.ReceiveType;
import com.tydic.pfscext.enums.SubAccountServiceType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.service.atom.SubAccountService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="FSC_GROUP_DEV", interfaceClass=BusiAddPreRecAmtConfirmService.class)
public class BusiAddPreRecAmtConfirmServiceImpl
implements BusiAddPreRecAmtConfirmService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAddPreRecAmtConfirmServiceImpl.class);
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private SubAccountService subAccountService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private AdvanceReceiveMapper advanceReceiveMapper;
    @Autowired
    private RecAmtConfirmMapper recAmtConfirmMapper;

    public BusiAddPreRecAmtConfirmRspBO addPreRecAmtConfirm(BusiAddPreRecAmtConfirmReqBO reqBO) {
        List seqList;
        if (logger.isDebugEnabled()) {
            logger.debug("\u9884\u751f\u6210\u6536\u6b3e\u5355\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if ((seqList = reqBO.getSeqList()) == null || seqList.isEmpty()) {
            throw new PfscExtBusinessException("0001", "\u60a8\u6ca1\u6709\u52fe\u9009\u6536\u6b3e\u4fe1\u606f");
        }
        AdvanceReceiveVO adReVo = new AdvanceReceiveVO();
        adReVo.setSeqList(seqList);
        adReVo.setServiceTypeNotIn(Arrays.asList(SubAccountServiceType.DEFAULT.getCode()));
        int valCount = this.advanceReceiveMapper.selectCountBySeqList(adReVo);
        if (valCount > 0) {
            throw new PfscExtBusinessException("18000", "\u975e\u91c7\u8d2d\u5355\u4f4d\u5b50\u8d26\u6237\u7684\u5230\u8d26\u6d41\u6c34\u4e0d\u80fd\u529e\u7406\u6b64\u4e1a\u52a1");
        }
        BusiAddPreRecAmtConfirmRspBO rspBO = new BusiAddPreRecAmtConfirmRspBO();
        AdvanceReceiveVO vo = new AdvanceReceiveVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)vo);
        vo.setStatus(AdvanceReceiveStatus.NO_CONFIRM.getCode());
        RecAmtConfirm recAmtConfirm = this.recAmtConfirmMapper.sumUpDetails(vo);
        BusiAddPreHeadRecAmtConfirmRspBO head = new BusiAddPreHeadRecAmtConfirmRspBO();
        BeanUtils.copyProperties((Object)recAmtConfirm, (Object)head);
        AdvanceReceive advanceReceive = this.advanceReceiveMapper.selectByPrimaryKey((Long)seqList.get(0));
        String orgName = this.organizationInfoService.queryOrgName(advanceReceive.getRecOrgId());
        head.setOrgName(orgName);
        rspBO.setHead(head);
        List<AdvanceReceive> rows = this.advanceReceiveMapper.selectByCondition(vo);
        ArrayList<BusiAddPreRowRecAmtConfirmRspBO> detailRows = new ArrayList<BusiAddPreRowRecAmtConfirmRspBO>();
        for (AdvanceReceive row : rows) {
            BusiAddPreRowRecAmtConfirmRspBO detail = new BusiAddPreRowRecAmtConfirmRspBO();
            BeanUtils.copyProperties((Object)row, (Object)detail);
            orgName = this.organizationInfoService.obtainOrgNameByAdvanceReceive(row);
            detail.setPayOrgName(orgName);
            orgName = this.organizationInfoService.queryOrgName(row.getRecOrgId());
            detail.setRecOrgName(orgName);
            detail.setRecTypeDescr(this.enumsService.getDescr(ReceiveType.getInstance(row.getRecType())));
            SubAcctInfoExt subAcctInfoExt = this.subAccountService.getWithMainAccount(row.getRecSubAcct());
            if (subAcctInfoExt != null) {
                detail.setSourceName(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)subAcctInfoExt.getSource())));
            }
            detailRows.add(detail);
        }
        rspBO.setRows(detailRows);
        return rspBO;
    }
}

