/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.BusiAddRecAmtConfirmXbjService;
import com.tydic.pfscext.api.busi.bo.BusiAddRecAmtConfirmXbjReqBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.AdvanceReceiveExtMapper;
import com.tydic.pfscext.dao.AdvanceReceiveMapper;
import com.tydic.pfscext.dao.RecAmtConfirmMapper;
import com.tydic.pfscext.dao.RecvAmtDetailMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.bo.AdvanceReceiveExtBO;
import com.tydic.pfscext.dao.po.AdvanceReceive;
import com.tydic.pfscext.dao.po.AdvanceReceiveExtPO;
import com.tydic.pfscext.dao.po.RecAmtConfirm;
import com.tydic.pfscext.dao.po.RecvAmtDetail;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.AdvanceReceiveVO;
import com.tydic.pfscext.dao.vo.RecvAmtDetailVO;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.AdvanceReceiveStatus;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.RecAmtConfirmStatus;
import com.tydic.pfscext.enums.ReceiptStatus;
import com.tydic.pfscext.enums.WFBillType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.FscWfStartAtomService;
import com.tydic.pfscext.service.atom.SequenceNoService;
import com.tydic.pfscext.service.atom.bo.FscWfStartAtomReqBO;
import com.tydic.pfscext.service.atom.bo.FscWfStartAtomRspBO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiAddRecAmtConfirmXbjServiceImpl
implements BusiAddRecAmtConfirmXbjService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAddRecAmtConfirmXbjServiceImpl.class);
    @Resource
    private SequenceNoService recAmtConfirmSeqNoService;
    @Autowired
    private AdvanceReceiveMapper advanceReceiveMapper;
    @Autowired
    private RecAmtConfirmMapper recAmtConfirmMapper;
    @Autowired
    private FscWfStartAtomService fscWfStartAtomService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private RecvAmtDetailMapper recvAmtDetailMapper;
    @Autowired
    private AdvanceReceiveExtMapper advanceReceiveExtMapper;

    public PfscExtRspBaseBO add(BusiAddRecAmtConfirmXbjReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u8be2\u6bd4\u4ef7\u914d\u9001\u7c7b\u6536\u6b3e\u786e\u8ba4\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List seqList = reqBO.getSeqList();
        List inspectionIdList = reqBO.getInspectionIdList();
        if (seqList == null || seqList.isEmpty()) {
            throw new PfscExtBusinessException("0001", "\u8bf7\u52fe\u9009\u94f6\u884c\u6d41\u6c34");
        }
        if (inspectionIdList == null || inspectionIdList.isEmpty()) {
            throw new PfscExtBusinessException("0001", "\u8bf7\u52fe\u9009\u8ba2\u5355");
        }
        BigDecimal tranAmtSum = BigDecimal.ZERO;
        AdvanceReceiveVO vo = new AdvanceReceiveVO();
        vo.setSeqList(seqList);
        RecAmtConfirm recAmtConfirm = this.recAmtConfirmMapper.sumUpXbjDetails(vo);
        if (recAmtConfirm != null && recAmtConfirm.getSumAmt() != null) {
            tranAmtSum = recAmtConfirm.getSumAmt();
        }
        AdvanceReceiveExtBO extBO = new AdvanceReceiveExtBO();
        extBO.setSeqList(seqList);
        extBO.setStatus(AdvanceReceiveStatus.NO_CONFIRM.getCode());
        RecAmtConfirm recAmtConfirmExt = this.recAmtConfirmMapper.sumUpExtDetails(extBO);
        BigDecimal otherTranAmtSum = BigDecimal.ZERO;
        if (recAmtConfirmExt != null && recAmtConfirmExt.getSumAmt() != null) {
            otherTranAmtSum = recAmtConfirmExt.getSumAmt();
        }
        SaleOrderInfoVO infoVO = new SaleOrderInfoVO();
        infoVO.setInspectionIdList(inspectionIdList);
        infoVO.setSourceList(Arrays.asList(OrderSource.CONSULT_PRICE_FRAME.getCode(), OrderSource.CONSULT_PRICE.getCode()));
        Page page = new Page(0, 9999);
        List<SaleOrderInfo> saleOrderList = this.saleOrderInfoMapper.getListPageJoinRecvAmtDetail(infoVO, (Page<Map<String, Object>>)page);
        if (CollectionUtils.isEmpty(saleOrderList)) {
            throw new PfscExtBusinessException("0001", "\u672a\u627e\u5230\u5f85\u6838\u9500\u8ba2\u5355\u4fe1\u606f");
        }
        if (inspectionIdList.size() != saleOrderList.size()) {
            throw new PfscExtBusinessException("0001", "\u9009\u4e2d\u7684\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5df2\u5b58\u5728\u6838\u9500\u8bb0\u5f55\uff0c\u8bf7\u5237\u65b0\u9875\u9762");
        }
        BigDecimal sumOrderAmt = BigDecimal.ZERO;
        Long operUnitNo = saleOrderList.get(0).getOperUnitNo();
        Long purchaseProjectId = saleOrderList.get(0).getPurchaseProjectId();
        for (SaleOrderInfo saleInfo : saleOrderList) {
            sumOrderAmt = sumOrderAmt.add(saleInfo.getOrderAmt());
            if (purchaseProjectId.equals(saleInfo.getPurchaseProjectId())) continue;
            throw new PfscExtBusinessException("0001", "\u4e3a\u4e86\u4fdd\u8bc1\u51c6\u786e\uff0c\u4e00\u6b21\u53ea\u80fd\u5bf9\u4e00\u4e2a\u91c7\u8d2d\u5355\u4f4d\u7684\u8ba2\u5355\u505a\u6536\u6b3e\u786e\u8ba4");
        }
        if (sumOrderAmt.compareTo(BigDecimal.ZERO) <= 0 || tranAmtSum.add(otherTranAmtSum).compareTo(sumOrderAmt) < 0) {
            logger.error("\u8ba2\u5355\u91d1\u989d:" + sumOrderAmt + ", \u6253\u6b3e\u94f6\u884c\u6d41\u6c34\u91d1\u989d:" + tranAmtSum + ", \u4ed6\u884c\u94f6\u884c\u6d41\u6c34\u91d1\u989d:" + otherTranAmtSum + ", \u5f85\u6838\u9500\u8ba2\u5355\u5217\u8868:" + inspectionIdList + ", \u94f6\u884c\u6d41\u6c34\u5217\u8868:" + seqList);
            throw new PfscExtBusinessException("0001", "\u94f6\u884c\u6d41\u6c34\u7684\u672a\u786e\u8ba4\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u8ba2\u5355\u91d1\u989d");
        }
        HashSet<Long> recordAdvSeqSet = new HashSet<Long>();
        Long docNum = Long.valueOf(this.recAmtConfirmSeqNoService.generateSeqNoFormated(18, new SimpleDateFormat("yyyyMMdd").format(new Date())));
        BigDecimal amountAdvTotal = BigDecimal.ZERO;
        for (SaleOrderInfo order : saleOrderList) {
            Serializable record;
            BigDecimal writeoffAmt;
            BigDecimal writeoffAmtActual;
            BigDecimal orderAmt = order.getOrderAmt();
            if (orderAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
            if (tranAmtSum.compareTo(BigDecimal.ZERO) > 0) {
                AdvanceReceive advanceReceive;
                AdvanceReceiveVO advanQueryVO = new AdvanceReceiveVO();
                advanQueryVO.setSeqList(seqList);
                List<AdvanceReceive> advanceReceiveList = this.advanceReceiveMapper.selectUnwriteOffByXbjList(advanQueryVO);
                while (orderAmt.compareTo(BigDecimal.ZERO) > 0 && (advanceReceive = this.pickOne(advanceReceiveList, orderAmt)) != null) {
                    writeoffAmtActual = null;
                    writeoffAmt = advanceReceive.getUnWriteoffAmt();
                    if (writeoffAmt.compareTo(orderAmt) >= 0) {
                        writeoffAmtActual = orderAmt;
                        writeoffAmt = writeoffAmt.subtract(orderAmt);
                        orderAmt = BigDecimal.ZERO;
                    } else {
                        writeoffAmtActual = writeoffAmt;
                        orderAmt = orderAmt.subtract(writeoffAmt);
                        writeoffAmt = BigDecimal.ZERO;
                    }
                    record = new AdvanceReceive();
                    ((AdvanceReceive)record).setSeq(advanceReceive.getSeq());
                    ((AdvanceReceive)record).setOrderAmt(advanceReceive.getOrderAmt().add(writeoffAmtActual));
                    boolean flag = false;
                    RecvAmtDetailVO detailVO = new RecvAmtDetailVO();
                    detailVO.setAdvRecvSeq(advanceReceive.getSeq());
                    RecvAmtDetailVO sumRecvDetail = this.recvAmtDetailMapper.selectSum2(detailVO);
                    if (sumRecvDetail.getAmount().compareTo(BigDecimal.ZERO) == 0) {
                        flag = true;
                        ((AdvanceReceive)record).setWriteoffAmt(advanceReceive.getTranAmt());
                        ((AdvanceReceive)record).setStatus(AdvanceReceiveStatus.CONFIRM.getCode());
                        recordAdvSeqSet.add(advanceReceive.getSeq());
                        amountAdvTotal = amountAdvTotal.add(advanceReceive.getTranAmt());
                    }
                    this.advanceReceiveMapper.updateByPrimaryKeySelective((AdvanceReceive)record);
                    RecvAmtDetail recvAmtDetail = new RecvAmtDetail();
                    recvAmtDetail.setAdvRecvSeq(advanceReceive.getSeq());
                    recvAmtDetail.setAmount(flag ? advanceReceive.getTranAmt() : BigDecimal.ZERO);
                    recvAmtDetail.setOrderAmt(writeoffAmtActual);
                    recvAmtDetail.setRecAcctNo(advanceReceive.getRecSubAcct());
                    recvAmtDetail.setOperUnitNo(order.getOperUnitNo());
                    recvAmtDetail.setSupplierNo(order.getSupplierNo());
                    recvAmtDetail.setPurchaseNo(order.getPurchaseNo());
                    recvAmtDetail.setPurchaseProjectId(order.getPurchaseProjectId());
                    recvAmtDetail.setDocNum(docNum);
                    recvAmtDetail.setOrderId(order.getOrderId());
                    recvAmtDetail.setInspectionId(order.getInspectionId());
                    recvAmtDetail.setLoginId(reqBO.getUserId());
                    recvAmtDetail.setCreateDate(new Date());
                    this.recvAmtDetailMapper.insert(recvAmtDetail);
                }
            }
            if (otherTranAmtSum.compareTo(BigDecimal.ZERO) <= 0 || orderAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
            AdvanceReceiveExtBO queryExtBO = new AdvanceReceiveExtBO();
            queryExtBO.setSeqList(seqList);
            queryExtBO.setStatus(AdvanceReceiveStatus.NO_CONFIRM.getCode());
            List<AdvanceReceiveExtBO> advanceReceiveExtList = this.advanceReceiveExtMapper.selectUnwriteOffBySeqList(queryExtBO);
            while (orderAmt.compareTo(BigDecimal.ZERO) > 0) {
                AdvanceReceiveExtBO advanceReceiveExt = this.pickOneReceiveExt(advanceReceiveExtList, orderAmt);
                if (advanceReceiveExt == null) {
                    throw new PfscExtBusinessException("18000", "\u94f6\u884c\u6d41\u6c34\u53ef\u6838\u9500\u91d1\u989d\u4e0d\u8db3\uff0c\u6838\u9500\u5931\u8d25");
                }
                writeoffAmtActual = null;
                writeoffAmt = advanceReceiveExt.getUnWriteoffAmt();
                if (writeoffAmt.compareTo(orderAmt) >= 0) {
                    writeoffAmtActual = orderAmt;
                    writeoffAmt = writeoffAmt.subtract(orderAmt);
                    orderAmt = BigDecimal.ZERO;
                } else {
                    writeoffAmtActual = writeoffAmt;
                    orderAmt = orderAmt.subtract(writeoffAmt);
                    writeoffAmt = BigDecimal.ZERO;
                }
                record = new AdvanceReceiveExtPO();
                ((AdvanceReceiveExtPO)record).setSeq(advanceReceiveExt.getSeq());
                ((AdvanceReceiveExtPO)record).setWriteoffAmt(advanceReceiveExt.getWriteoffAmt().add(writeoffAmtActual));
                if (writeoffAmt.compareTo(BigDecimal.ZERO) == 0) {
                    ((AdvanceReceiveExtPO)record).setStatus(AdvanceReceiveStatus.CONFIRM.getCode());
                }
                recordAdvSeqSet.add(advanceReceiveExt.getSeq());
                amountAdvTotal = amountAdvTotal.add(writeoffAmtActual);
                this.advanceReceiveExtMapper.updateByPrimaryKeySelective((AdvanceReceiveExtPO)record);
                RecvAmtDetail recvAmtDetail = new RecvAmtDetail();
                recvAmtDetail.setAdvRecvSeq(advanceReceiveExt.getSeq());
                recvAmtDetail.setAmount(writeoffAmtActual);
                recvAmtDetail.setRecAcctNo(advanceReceiveExt.getRecAcct());
                recvAmtDetail.setOperUnitNo(order.getOperUnitNo());
                recvAmtDetail.setSupplierNo(order.getSupplierNo());
                recvAmtDetail.setPurchaseNo(order.getPurchaseNo());
                recvAmtDetail.setPurchaseProjectId(order.getPurchaseProjectId());
                recvAmtDetail.setDocNum(docNum);
                recvAmtDetail.setOrderId(order.getOrderId());
                recvAmtDetail.setInspectionId(order.getInspectionId());
                recvAmtDetail.setLoginId(reqBO.getUserId());
                recvAmtDetail.setCreateDate(new Date());
                this.recvAmtDetailMapper.insert(recvAmtDetail);
            }
        }
        RecAmtConfirm recAmtConfirmBO = new RecAmtConfirm();
        recAmtConfirmBO.setDocNum(docNum);
        recAmtConfirmBO.setSumCount(recordAdvSeqSet.size());
        recAmtConfirmBO.setSumAmt(amountAdvTotal);
        recAmtConfirmBO.setOrgId(operUnitNo);
        recAmtConfirmBO.setLoginId(reqBO.getUserId());
        recAmtConfirmBO.setRemark("\u8be2\u6bd4\u4ef7\u914d\u9001\u7c7b\u8ba2\u5355\u6536\u6b3e\u786e\u8ba4");
        recAmtConfirmBO.setCreateDate(new Date());
        recAmtConfirmBO.setSource(OrderSource.CONSULT_PRICE.getCode());
        recAmtConfirmBO.setStatus(RecAmtConfirmStatus.VALID.getCode());
        recAmtConfirmBO.setReceiptStatus(ReceiptStatus.NO_RECEIPT.getCode());
        this.recAmtConfirmMapper.insert(recAmtConfirmBO);
        FscWfStartAtomReqBO req = new FscWfStartAtomReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)req));
        req.setBillNo(String.valueOf(docNum));
        req.setBillType(WFBillType.DISTRIBUTE_COLLECTION_CONFIRMATION);
        req.setFinishEvtServiceId("recAmtConfirmWorkFlowFinshEventImpl");
        FscWfStartAtomRspBO atomRspBO = this.fscWfStartAtomService.dealStartApproval(req);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new PfscExtBusinessException("18000", "\u8be2\u6bd4\u4ef7\u914d\u9001\u7c7b\u6536\u6b3e\u786e\u8ba4\u670d\u52a1\u5931\u8d25,\u53d1\u8d77\u5ba1\u6279\u5931\u8d25");
        }
        return new PfscExtRspBaseBO();
    }

    private AdvanceReceive pickOne(List<AdvanceReceive> advanceReceiveList, BigDecimal toWriteoffAmt) {
        Iterator<AdvanceReceive> iterator = advanceReceiveList.iterator();
        while (iterator.hasNext()) {
            AdvanceReceive advanceReceive = iterator.next();
            if (advanceReceive.getUnWriteoffAmt().compareTo(toWriteoffAmt) >= 0) {
                iterator.remove();
                return advanceReceive;
            }
            if (iterator.hasNext()) continue;
            iterator.remove();
            return advanceReceive;
        }
        return null;
    }

    private AdvanceReceiveExtBO pickOneReceiveExt(List<AdvanceReceiveExtBO> advanceReceiveExtList, BigDecimal toWriteoffAmt) {
        Iterator<AdvanceReceiveExtBO> iterator = advanceReceiveExtList.iterator();
        while (iterator.hasNext()) {
            AdvanceReceiveExtBO advanceReceiveExtBO = iterator.next();
            if (advanceReceiveExtBO.getUnWriteoffAmt().compareTo(toWriteoffAmt) >= 0) {
                iterator.remove();
                return advanceReceiveExtBO;
            }
            if (iterator.hasNext()) continue;
            iterator.remove();
            return advanceReceiveExtBO;
        }
        return null;
    }
}

