/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiApplyMailImportInvoiceService;
import com.tydic.pfscext.api.busi.bo.BusiApplyMailImportInvoiceReqBO;
import com.tydic.pfscext.api.busi.bo.BusiApplyMailImportInvoiceRowReqBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.SaleInvoiceImportInfoMapper;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.SaleInvoiceImportInfo;
import com.tydic.pfscext.dao.po.SaleInvoiceInfo;
import com.tydic.pfscext.dao.vo.BillApplyInfoVO;
import com.tydic.pfscext.dao.vo.SaleInvoiceImportInfoVO;
import com.tydic.pfscext.dao.vo.SaleInvoiceInfoVO;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@org.apache.dubbo.config.annotation.Service(version="1.0.0", group="FSC_GROUP_DEV", interfaceClass=BusiApplyMailImportInvoiceService.class)
public class BusiApplyMailImportInvoiceServiceImpl
implements BusiApplyMailImportInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(BusiApplyMailImportInvoiceServiceImpl.class);
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private SaleInvoiceImportInfoMapper saleInvoiceImportInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;

    public PfscExtRspBaseBO process(BusiApplyMailImportInvoiceReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d1\u7968\u90ae\u5bc4-\u5bfc\u5165\u53d1\u7968\uff08\u4e0d\u5305\u62ec\u5e73\u53f0\u4f7f\u7528\u8d39\uff09\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        Long userId = reqBO.getUserId();
        List rows = reqBO.getRows();
        if (userId == null || userId == 0L) {
            throw new PfscExtBusinessException("0001", "\u6ca1\u6709\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
        }
        if (CollectionUtils.isEmpty((Collection)rows)) {
            throw new PfscExtBusinessException("0001", "\u65e0\u53d1\u7968\u6570\u636e");
        }
        ArrayList<String> invoiceNos = new ArrayList<String>();
        for (BusiApplyMailImportInvoiceRowReqBO row : rows) {
            if (invoiceNos.contains(row.getInvoiceNo())) continue;
            invoiceNos.add(row.getInvoiceNo());
        }
        if (invoiceNos.size() != rows.size()) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u7f16\u53f7\u91cd\u590d");
        }
        SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
        saleInvoiceInfoVO.setInvoiceNoList(invoiceNos);
        List<SaleInvoiceInfo> invoices = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
        StringBuilder respDesc = new StringBuilder();
        int i = 0;
        for (String invoiceNo : invoiceNos) {
            ++i;
            if (!StringUtils.hasText((String)invoiceNo)) {
                respDesc.append("\u7b2c").append(i).append("\u4e2a\u53d1\u7968\u7f16\u53f7\u4e3a\u7a7a\u3002");
            }
            boolean exist = false;
            for (SaleInvoiceInfo saleInvoiceInfo : invoices) {
                if (!saleInvoiceInfo.getInvoiceNo().equals(invoiceNo)) continue;
                exist = true;
                if (SaleInvoiceInfoInvoiceStatus.SEND_BILL.getCode().equals(saleInvoiceInfo.getInvoiceStatus())) break;
                respDesc.append(invoiceNo).append("\u4e0d\u662f\u6709\u6548\u53d1\u7968\u3002");
                break;
            }
            if (exist) continue;
            respDesc.append(invoiceNo).append("\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002");
        }
        if (respDesc.length() > 0) {
            throw new PfscExtBusinessException("0001", respDesc.toString());
        }
        BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setInvoiceNoList(invoiceNos);
        List<BillApplyInfo> applys = this.billApplyInfoMapper.getList(billApplyInfoVO);
        HashSet<Long> operUnitNos = new HashSet<Long>();
        ArrayList<String> invoiceNos2 = new ArrayList<String>();
        for (BillApplyInfo apply : applys) {
            operUnitNos.add(apply.getOperUnitNo());
            if (BillStatus.SEND_BILL.getCode().equals(apply.getBillStatus())) continue;
            for (SaleInvoiceInfo invoice : invoices) {
                if (!apply.getApplyNo().equals(invoice.getApplyNo())) continue;
                invoiceNos2.add(invoice.getInvoiceNo());
            }
        }
        if (operUnitNos.size() > 1) {
            respDesc.append("\u4e00\u6b21\u53ea\u80fd\u5bfc\u5165\u4e00\u4e2a\u516c\u53f8\u7684\u53d1\u7968\uff0c\u672c\u6b21\u5bfc\u5165\u7684\u516c\u53f8\u6709\uff1a");
            for (Long operUnitNo : operUnitNos) {
                String operUnitName = this.organizationInfoService.queryOrgName(operUnitNo);
                respDesc.append(operUnitName).append("\u3001");
            }
            respDesc.deleteCharAt(respDesc.length() - 1).append("\u3002");
        }
        if (!invoiceNos2.isEmpty()) {
            respDesc.append("\u5f00\u7968\u7533\u8bf7\u5355\u7684\u72b6\u6001\u5fc5\u987b\u662f\u5df2\u5f00\u7968\uff0c\u4e0d\u6ee1\u8db3\u8be5\u6761\u4ef6\u7684\u53d1\u7968\u7f16\u53f7\u6709\uff1a");
            for (String invoiceNo : invoiceNos2) {
                respDesc.append(invoiceNo).append("\u3001");
            }
            respDesc.deleteCharAt(respDesc.length() - 1).append("\u3002");
        }
        if (respDesc.length() > 0) {
            throw new PfscExtBusinessException("0001", respDesc.toString());
        }
        SaleInvoiceImportInfoVO saleInvoiceImportInfoVO = new SaleInvoiceImportInfoVO();
        saleInvoiceImportInfoVO.setCreateUser(userId);
        this.saleInvoiceImportInfoMapper.deleteByVO(saleInvoiceImportInfoVO);
        ArrayList<SaleInvoiceImportInfo> invoiceImports = new ArrayList<SaleInvoiceImportInfo>();
        for (String invoiceNo : invoiceNos) {
            SaleInvoiceImportInfo invoiceImport = new SaleInvoiceImportInfo();
            invoiceImport.setInvoiceNo(invoiceNo);
            invoiceImport.setCreateUser(userId);
            invoiceImports.add(invoiceImport);
        }
        this.saleInvoiceImportInfoMapper.insertBatch(invoiceImports);
        return new PfscExtRspBaseBO();
    }
}

