/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiCancelBillApplyInfoXbjService;
import com.tydic.pfscext.api.busi.bo.BusiCancelBillApplyInfoXbjReqBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.InquiryPayOrderMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.vo.BillApplyInfoVO;
import com.tydic.pfscext.dao.vo.PayInvoiceVO;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiCancelBillApplyInfoXbjServiceImpl
implements BusiCancelBillApplyInfoXbjService {
    private static final Logger logger = LoggerFactory.getLogger(BusiCancelBillApplyInfoXbjServiceImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;

    public PfscExtRspBaseBO update(BusiCancelBillApplyInfoXbjReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d6\u6d88\u5f00\u7968\u7533\u8bf7\u670d\u52a1(\u8be2\u6bd4\u4ef7)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List applyNoList = reqBO.getApplyNoList();
        if (applyNoList == null || applyNoList.isEmpty()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u3010applyNoList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setApplyNoList(applyNoList);
        ArrayList<String> billStatusNotIn = new ArrayList<String>();
        billStatusNotIn.add(BillStatus.NO_APPLY.getCode());
        billApplyInfoVO.setBillStatusNotIn(billStatusNotIn);
        int count = this.billApplyInfoMapper.selectCount(billApplyInfoVO);
        if (count > 0) {
            throw new PfscExtBusinessException("18000", "\u5f00\u7968\u7533\u8bf7\u5355\u7684\u5f00\u7968\u72b6\u6001\u5fc5\u987b\u662f\u5df2\u63d0\u4ea4");
        }
        billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setApplyNoList(applyNoList);
        billApplyInfoVO.setBillStatus(BillStatus.NO_APPLY.getCode());
        BillApplyInfo billApplyInfo = new BillApplyInfo();
        billApplyInfo.setBillStatus(BillStatus.CANCEL_APPLY.getCode());
        this.billApplyInfoMapper.updateByCondition(billApplyInfoVO, billApplyInfo);
        PayInvoiceVO payInvoiceVO = new PayInvoiceVO();
        payInvoiceVO.setApplyNoList(applyNoList);
        payInvoiceVO.setOrderStatus(OrderStatus.NO_APPLY.getCode());
        this.inquiryPayOrderMapper.updateForBill(payInvoiceVO);
        return new PfscExtRspBaseBO();
    }
}

