/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.jd.open.api.sdk.domain.etms.TraceQueryJsf.TraceDTO;
import com.tydic.pfscext.api.busi.BusiCancelExpressService;
import com.tydic.pfscext.api.busi.bo.BusiCancelExpressReqBO;
import com.tydic.pfscext.api.busi.bo.BusiCancelExpressRspBO;
import com.tydic.pfscext.api.busi.bo.QueryExpressTraceDetailRspBO;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.dao.SaleInvoiceMailInfoMapper;
import com.tydic.pfscext.dao.po.JdexpressToken;
import com.tydic.pfscext.dao.po.SaleInvoiceMailInfo;
import com.tydic.pfscext.dao.vo.SaleInvoiceInfoVO;
import com.tydic.pfscext.enums.InvoiceMailSentStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiJdExpressService;
import com.tydic.pfscext.external.api.bo.JdexpressTokenVO;
import com.tydic.pfscext.service.atom.JdExpressTokenService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="FSC_GROUP_DEV", interfaceClass=BusiCancelExpressService.class)
public class BusiCancelExpressServiceImpl
implements BusiCancelExpressService {
    private static final Logger logger = LoggerFactory.getLogger(BusiCancelExpressServiceImpl.class);
    @Autowired
    private SaleInvoiceMailInfoMapper saleInvoiceMailInfoMapper;
    @Autowired
    private BusiJdExpressService busiJdExpressService;
    @Autowired
    private JdExpressTokenService jdExpressTokenService;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;

    public BusiCancelExpressRspBO cancelExpress(BusiCancelExpressReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d6\u6d88\u90ae\u5bc4\u53d1\u7968\u670d\u52a1(\u4e13\u4e1a\u516c\u53f8) \u5165\u53c2\uff1a" + reqBO);
        }
        BusiCancelExpressRspBO rspBO = new BusiCancelExpressRspBO();
        if (reqBO.getCompanyId() == null) {
            throw new PfscExtBusinessException("0001", "\u4e13\u4e1a\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getExpressNo() == null) {
            throw new PfscExtBusinessException("0001", "\u5feb\u9012\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer deleteExpressInvoiceNum = 0;
        for (String eachExpressNo : reqBO.getExpressNo()) {
            List<SaleInvoiceMailInfo> expressInfos = this.saleInvoiceMailInfoMapper.selectByExpressNo(eachExpressNo);
            if (expressInfos.isEmpty()) {
                throw new PfscExtBusinessException("18001", "\u5feb\u9012\u5355\u53f7:" + eachExpressNo + "\u5f55\u5165\u4e0d\u6b63\u786e");
            }
            SaleInvoiceMailInfo firstExpressInfo = expressInfos.get(0);
            if (InvoiceMailSentStatus.PROCCESSING.getCode().equals(firstExpressInfo.getMailStatus())) {
                throw new PfscExtBusinessException("18000", "\u5feb\u9012\u5355\u53f7:" + eachExpressNo + "\u72b6\u6001\u4e3a\u5904\u7406\u4e2d\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88");
            }
            if (InvoiceMailSentStatus.SENT_FAIL.getCode().equals(firstExpressInfo.getMailStatus())) {
                Integer processTotal = this.processCancelExpress(eachExpressNo, expressInfos);
                deleteExpressInvoiceNum = deleteExpressInvoiceNum + processTotal;
                continue;
            }
            if (InvoiceMailSentStatus.SENT_SUCCESS.getCode().equals(firstExpressInfo.getMailStatus())) {
                List traceDTOList;
                JdexpressToken token = this.jdExpressTokenService.getToken(reqBO.getCompanyId());
                JdexpressTokenVO tokenVO = new JdexpressTokenVO();
                BeanUtils.copyProperties((Object)token, (Object)tokenVO);
                try {
                    traceDTOList = this.busiJdExpressService.receiveTrace(eachExpressNo, tokenVO);
                }
                catch (Exception e) {
                    throw new PfscExtBusinessException("18005", "\u8c03\u7528\u4eac\u4e1c\u63a5\u53e3-\u67e5\u8be2\u7269\u6d41\u4fe1\u606f\u51fa\u9519", e);
                }
                ArrayList<QueryExpressTraceDetailRspBO> rows = new ArrayList<QueryExpressTraceDetailRspBO>();
                if (traceDTOList != null && !traceDTOList.isEmpty()) {
                    for (TraceDTO traceDTO : traceDTOList) {
                        QueryExpressTraceDetailRspBO row = new QueryExpressTraceDetailRspBO();
                        BeanUtils.copyProperties((Object)traceDTO, (Object)row);
                        rows.add(row);
                    }
                    Collections.reverse(rows);
                    if ("\u7ec8\u6b62\u63fd\u6536".equals(((QueryExpressTraceDetailRspBO)rows.get(0)).getOpeTitle()) || "\u4e0b\u5355\u53d6\u6d88".equals(((QueryExpressTraceDetailRspBO)rows.get(0)).getOpeTitle())) {
                        Integer processTotal = this.processCancelExpress(eachExpressNo, expressInfos);
                        deleteExpressInvoiceNum = deleteExpressInvoiceNum + processTotal;
                        continue;
                    }
                    throw new PfscExtBusinessException("18000", "\u5feb\u9012\u5355\u53f7:" + eachExpressNo + "\u975e\u7ec8\u6b62\u63fd\u6536\u3001\u4e0b\u5355\u53d6\u6d88\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88");
                }
                throw new PfscExtBusinessException("18000", "\u5feb\u9012\u5355\u53f7:" + eachExpressNo + "\u975e\u7ec8\u6b62\u63fd\u6536\u3001\u4e0b\u5355\u53d6\u6d88\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88");
            }
            if (!InvoiceMailSentStatus.NOT_SENT.getCode().equals(firstExpressInfo.getMailStatus())) continue;
            throw new PfscExtBusinessException("18000", "\u5feb\u9012\u5355\u53f7:" + eachExpressNo + "\u90ae\u5bc4\u72b6\u6001\u6709\u8bef\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88");
        }
        rspBO.setEffectRecord(deleteExpressInvoiceNum);
        return rspBO;
    }

    private Integer processCancelExpress(String eachExpressNo, List<SaleInvoiceMailInfo> expressInfos) {
        logger.debug("\u53d6\u6d88\u90ae\u5bc4-\u5feb\u9012\u5355\u53f7:" + eachExpressNo + "\u6b63\u5728\u53d6\u6d88");
        try {
            this.saleInvoiceMailInfoMapper.deleteByExpressNo(eachExpressNo);
            SaleInvoiceInfoVO updateInvoiceVO = new SaleInvoiceInfoVO();
            updateInvoiceVO.setMailTicketNo(eachExpressNo);
            this.saleInvoiceInfoMapper.clearMailInfo(updateInvoiceVO);
            return expressInfos.size();
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("18000", "\u5feb\u9012\u5355\u53f7:" + eachExpressNo + ",\u53d6\u6d88\u5931\u8d25\uff0c\u64cd\u4f5c\u6570\u636e\u5e93\u9519\u8bef", e);
        }
    }
}

