/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiHangPayPurchaseOrderInfoService;
import com.tydic.pfscext.api.busi.bo.ProcessCancelHangReqBO;
import com.tydic.pfscext.api.busi.bo.ProcessHangReqBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="FSC_GROUP_DEV", interfaceClass=BusiHangPayPurchaseOrderInfoService.class)
public class BusiHangPayPurchaseOrderInfoServiceImpl
implements BusiHangPayPurchaseOrderInfoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusiHangPayPurchaseOrderInfoServiceImpl.class);
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;

    @Autowired
    public BusiHangPayPurchaseOrderInfoServiceImpl(PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper) {
        this.payPurchaseOrderInfoMapper = payPurchaseOrderInfoMapper;
    }

    public PfscExtRspBaseBO processHang(ProcessHangReqBO reqBO) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u6302\u8d77\u91c7\u8d2d\u8ba2\u5355\u670d\u52a1(\u7535\u5b50\u8d85\u5e02)\u5165\u53c2\uff1a" + reqBO);
        }
        Long inspectionId = reqBO.getInspectionId();
        String remark = reqBO.getRemark();
        if (null == inspectionId) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u9a8c\u6536\u5355\u53f7\u3010inspectionId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayPurchaseOrderInfo orderInfo = new PayPurchaseOrderInfo();
        orderInfo.setInspectionId(inspectionId);
        PayPurchaseOrderInfo purchaseOrderInfo = this.payPurchaseOrderInfoMapper.getModelBy(orderInfo);
        if (null == purchaseOrderInfo) {
            throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u672a\u627e\u5230");
        }
        if (!OrderStatus.NO_APPLY.getCode().equals(purchaseOrderInfo.getOrderStatus())) {
            throw new PfscExtBusinessException("18000", "\u672a\u63d0\u4ea4\u7684\u8ba2\u5355\u624d\u80fd\u6302\u8d77");
        }
        orderInfo = new PayPurchaseOrderInfo();
        orderInfo.setInspectionId(inspectionId);
        orderInfo.setOrderStatus(OrderStatus.HANGING.getCode());
        orderInfo.setRemark(remark);
        int count = this.payPurchaseOrderInfoMapper.updateBy(orderInfo);
        if (count > 0) {
            PfscExtRspBaseBO rspBo = new PfscExtRspBaseBO();
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6302\u8d77\u8ba2\u5355\u6210\u529f");
            return rspBo;
        }
        throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
    }

    public PfscExtRspBaseBO processCancelHang(ProcessCancelHangReqBO reqBO) {
        Long inspectionId;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u53d6\u6d88\u6302\u8d77\u91c7\u8d2d\u8ba2\u5355\u670d\u52a1(\u7535\u5b50\u8d85\u5e02)\u5165\u53c2\uff1a" + reqBO);
        }
        if (null == (inspectionId = reqBO.getInspectionId())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u9a8c\u6536\u5355\u53f7\u3010inspectionId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayPurchaseOrderInfo orderInfo = new PayPurchaseOrderInfo();
        orderInfo.setInspectionId(inspectionId);
        PayPurchaseOrderInfo purchaseOrderInfo = this.payPurchaseOrderInfoMapper.getModelBy(orderInfo);
        if (null == purchaseOrderInfo) {
            throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u672a\u627e\u5230");
        }
        if (!OrderStatus.HANGING.getCode().equals(purchaseOrderInfo.getOrderStatus())) {
            throw new PfscExtBusinessException("18000", "\u4e0d\u662f\u6302\u8d77\u72b6\u6001\uff0c\u4e0d\u80fd\u53d6\u6d88\u6302\u8d77");
        }
        orderInfo = new PayPurchaseOrderInfo();
        orderInfo.setInspectionId(inspectionId);
        orderInfo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
        orderInfo.setRemark("");
        int count = this.payPurchaseOrderInfoMapper.updateBy(orderInfo);
        if (count > 0) {
            PfscExtRspBaseBO rspBo = new PfscExtRspBaseBO();
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u53d6\u6d88\u6302\u8d77\u8ba2\u5355\u6210\u529f");
            return rspBo;
        }
        throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
    }
}

