/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.BusiQryNotificationListDlzqService;
import com.tydic.pfscext.api.busi.bo.BusiQryNotificationListReqBO;
import com.tydic.pfscext.api.busi.bo.PurchaseOrderDetailInfoRspBO;
import com.tydic.pfscext.api.busi.vo.BillNotificationInfoVO;
import com.tydic.pfscext.base.PfscExtReqPageBaseBO;
import com.tydic.pfscext.base.PfscExtRspPageBaseBO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayInvoiceInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.dao.vo.Statis;
import com.tydic.pfscext.enums.BaseEnums;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.service.atom.UserInfoService;
import com.tydic.pfscext.utils.BusinessUtils;
import com.tydic.pfscext.utils.FscStringUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="FSC_GROUP_DEV", interfaceClass=BusiQryNotificationListDlzqService.class)
public class BusiQryNotificationListDlzqServiceImpl
implements BusiQryNotificationListDlzqService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQryNotificationListDlzqServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;

    public PfscExtRspPageBaseBO<BillNotificationInfoVO> qryNotifyList(BusiQryNotificationListReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (null == reqBO.getCompanyId()) {
            throw new PfscExtBusinessException("0001", "\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5217\u8868\u4e1a\u52a1\u670d\u52a1-Session\u4e13\u4e1a\u516c\u53f8[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSource()) {
            throw new PfscExtBusinessException("0001", "\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long operUnitNo = BusinessUtils.judgeOperUnitNo(reqBO.getOperUnitNo(), reqBO.getCompanyId(), false);
        reqBO.setOperUnitNo(operUnitNo);
        String defaultOrderBy = " APPLY_DATE desc,NOTIFICATION_NO desc ";
        String tableName = "d_bill_notification_info";
        String orderBy = FscStringUtils.obtainOrderBy((PfscExtReqPageBaseBO)reqBO, tableName, defaultOrderBy);
        PfscExtRspPageBaseBO rspPageBO = new PfscExtRspPageBaseBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        LinkedList<BillNotificationInfoVO> result = new LinkedList<BillNotificationInfoVO>();
        List<BillNotificationInfo> resultPO = this.billNotificationInfoMapper.getListPage(reqBO, false, (Page<Map<String, Object>>)page, orderBy);
        for (BillNotificationInfo notifyInfo : resultPO) {
            BillNotificationInfoVO resultVO = new BillNotificationInfoVO();
            BeanUtils.copyProperties((Object)notifyInfo, (Object)resultVO);
            resultVO.setNotifInvoiceStatus(notifyInfo.getInvoiceStatus());
            NotificationInvoiceStatus notifInvoiceEnum = NotificationInvoiceStatus.getInstance(resultVO.getNotifInvoiceStatus());
            resultVO.setNotifInvoiceStatusStr(this.enumsService.getDescr(notifInvoiceEnum));
            String supplierStr = this.organizationInfoService.querySupplierName(resultVO.getSupplierNo());
            resultVO.setSupplierName(supplierStr);
            resultVO.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)resultVO.getSource())));
            resultVO.setVerifyPersonName(this.userInfoService.queryUserNameByUserId(notifyInfo.getVerifyPersonId()));
            resultVO.setProfessionalDepartDescr(this.organizationInfoService.queryOrgName(resultVO.getProfessionalDepartId()));
            resultVO.setServiceDepartDescr(this.organizationInfoService.queryServiceDepartName(resultVO.getServiceDepartId()));
            resultVO.setBranchCompanyName(this.organizationInfoService.queryOrgName(notifyInfo.getBranchCompany()));
            LinkedList<PurchaseOrderDetailInfoRspBO> purchaseOrderDetailList = new LinkedList<PurchaseOrderDetailInfoRspBO>();
            LinkedList<String> purchaseOrderNameList = new LinkedList<String>();
            PayPurchaseOrderInfoVO purchaseOrderInfoVO = new PayPurchaseOrderInfoVO();
            purchaseOrderInfoVO.setNotificationNo(notifyInfo.getNotificationNo());
            List<PayPurchaseOrderInfo> purchaseOrderInfos = this.payPurchaseOrderInfoMapper.getListByItemNotifNo(purchaseOrderInfoVO);
            for (PayPurchaseOrderInfo purchaseOrderInfo : purchaseOrderInfos) {
                PurchaseOrderDetailInfoRspBO detailRspBO = new PurchaseOrderDetailInfoRspBO();
                detailRspBO.setInspectionId(purchaseOrderInfo.getInspectionId());
                detailRspBO.setPurchaseOrderCode(purchaseOrderInfo.getPurchaseOrderCode());
                detailRspBO.setPurchaseOrderName(purchaseOrderInfo.getPurchaseOrderName());
                purchaseOrderDetailList.add(detailRspBO);
                purchaseOrderNameList.add(purchaseOrderInfo.getPurchaseOrderName());
            }
            resultVO.setPurchaseOrderCodeList(purchaseOrderDetailList);
            resultVO.setPurchaseOrderNameList(purchaseOrderNameList);
            resultVO.setAmtDifference(resultVO.getAmt());
            Statis ivStatis = this.payInvoiceInfoMapper.invoiceStatis(notifyInfo.getNotificationNo());
            if (null != ivStatis) {
                resultVO.setSumInvoiceAmt(ivStatis.getTotAmt());
                resultVO.setTotUntaxAmt(ivStatis.getTotUntaxAmt());
                resultVO.setTotTaxAmt(ivStatis.getTotTaxAmt());
                if (null != resultVO.getAmt() && null != resultVO.getSumInvoiceAmt()) {
                    resultVO.setAmtDifference(resultVO.getAmt().subtract(resultVO.getSumInvoiceAmt()));
                }
            }
            result.add(resultVO);
        }
        rspPageBO.setRows(result);
        rspPageBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspPageBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPageBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspPageBO;
    }
}

