/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiQryNtfOrderInfoDetailDlzqService;
import com.tydic.pfscext.api.busi.bo.BusiQryNtfOrderInfoDetailDlzqReqBO;
import com.tydic.pfscext.api.busi.bo.BusiQryNtfOrderInfoDetailDlzqRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQryNtfOrderInfoDetailInfoDlzqRspBO;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.utils.FscStringUtils;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiQryNtfOrderInfoDetailDlzqServiceImpl
implements BusiQryNtfOrderInfoDetailDlzqService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQryNtfOrderInfoDetailDlzqServiceImpl.class);
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;

    public BusiQryNtfOrderInfoDetailDlzqRspBO query(BusiQryNtfOrderInfoDetailDlzqReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.info("\u67e5\u8be2\u914d\u9001\u7c7b\u5f00\u7968\u901a\u77e5\u4e0b\u7684\u8ba2\u5355\u660e\u7ec6\u670d\u52a1reqBO:" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u4e0d\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getNotificationNo()) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String notificationNo = reqBO.getNotificationNo();
        PayPurchaseOrderInfoVO purchaseOrderInfoVO = new PayPurchaseOrderInfoVO();
        purchaseOrderInfoVO.setNotificationNo(notificationNo);
        List<PayPurchaseOrderInfo> purchaseOrderInfos = this.payPurchaseOrderInfoMapper.getListByItemNotifNo(purchaseOrderInfoVO);
        if (purchaseOrderInfos == null || purchaseOrderInfos.isEmpty()) {
            throw new PfscExtBusinessException("18001", "\u5f00\u7968\u901a\u77e5\u5355\u53f7\uff1a" + notificationNo + "\u6ca1\u6709\u8ba2\u5355\u8bb0\u5f55");
        }
        LinkedList<BusiQryNtfOrderInfoDetailInfoDlzqRspBO> itemInfoData = new LinkedList<BusiQryNtfOrderInfoDetailInfoDlzqRspBO>();
        for (PayPurchaseOrderInfo singleInfo : purchaseOrderInfos) {
            List<PayItemInfo> itemInfos = this.payItemInfoMapper.selectByNtfNoAndOrderIdAndInspId(notificationNo, singleInfo.getOrderId(), singleInfo.getInspectionId());
            if (itemInfos == null || itemInfos.isEmpty()) {
                throw new PfscExtBusinessException("18000", "\u901a\u77e5\u5355\u53f7\uff1a" + notificationNo + ",\u8ba2\u5355\u7f16\u53f7\uff1a" + singleInfo.getOrderId() + "\u65e0\u91c7\u8d2d\u5546\u54c1\u660e\u7ec6");
            }
            for (PayItemInfo itemInfo : itemInfos) {
                BusiQryNtfOrderInfoDetailInfoDlzqRspBO itemInfoRspBO = new BusiQryNtfOrderInfoDetailInfoDlzqRspBO();
                itemInfoRspBO.setPurchaseOrderCode(itemInfo.getPurchaseOrderCode());
                itemInfoRspBO.setItemNo(itemInfo.getItemNo());
                itemInfoRspBO.setItemName(itemInfo.getItemName());
                itemInfoRspBO.setSpecAndModel(FscStringUtils.valueOf(itemInfo.getSpec()) + FscStringUtils.valueOf(itemInfo.getModel()));
                itemInfoRspBO.setUnitName(itemInfo.getUnitName());
                itemInfoRspBO.setPriceIntax(itemInfo.getPurchaseUnitPrice());
                itemInfoRspBO.setQuantity(itemInfo.getQuantity());
                itemInfoRspBO.setAmount(itemInfo.getAmount());
                itemInfoRspBO.setUntaxAmt(itemInfo.getUntaxAmt());
                itemInfoRspBO.setTaxAmt(itemInfo.getTaxAmt());
                itemInfoData.add(itemInfoRspBO);
            }
        }
        BusiQryNtfOrderInfoDetailDlzqRspBO rspBO = new BusiQryNtfOrderInfoDetailDlzqRspBO();
        rspBO.setDataList(itemInfoData);
        return rspBO;
    }
}

