/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.DzcsInvoiceReturnInvalidInvoiceService;
import com.tydic.pfscext.api.busi.bo.DzcsInvoiceReturnInvalidInvoiceReqBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.InvoiceReturnDetailMapper;
import com.tydic.pfscext.dao.InvoiceReturnMapper;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.InvoiceReturn;
import com.tydic.pfscext.dao.po.InvoiceReturnDetail;
import com.tydic.pfscext.dao.po.SaleInvoiceInfo;
import com.tydic.pfscext.dao.vo.BillApplyInfoVO;
import com.tydic.pfscext.dao.vo.InvoiceReturnDetailVO;
import com.tydic.pfscext.dao.vo.InvoiceReturnVO;
import com.tydic.pfscext.dao.vo.SaleInvoiceInfoVO;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.InvoiceClasses;
import com.tydic.pfscext.enums.InvoiceReturnStatus;
import com.tydic.pfscext.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.InvoiceReturnDzcsAtomService;
import com.tydic.pfscext.service.atom.UserInfoService;
import com.tydic.pfscext.utils.FscStringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DzcsInvoiceReturnInvalidInvoiceServiceImpl
implements DzcsInvoiceReturnInvalidInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(DzcsInvoiceReturnInvalidInvoiceServiceImpl.class);
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private InvoiceReturnDzcsAtomService invoiceReturnDzcsAtomService;

    public PfscExtRspBaseBO process(DzcsInvoiceReturnInvalidInvoiceReqBO reqBO) {
        Collection<String> applyNo1s;
        List billNos;
        if (logger.isDebugEnabled()) {
            logger.debug("\u4f5c\u5e9f\u53d1\u7968\u670d\u52a1\uff08\u7535\u5b50\u8d85\u5e02\u9000\u7968\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        if (CollectionUtils.isEmpty((Collection)(billNos = reqBO.getBillNos()))) {
            throw new PfscExtBusinessException("0001", "\u8bf7\u52fe\u9009");
        }
        InvoiceReturnVO vo = new InvoiceReturnVO();
        vo.setBillNos(billNos);
        List<InvoiceReturn> invoiceReturns = this.invoiceReturnMapper.selectListBy(vo);
        for (InvoiceReturn invoiceReturn : invoiceReturns) {
            if (!InvoiceReturnStatus.TO_RETURN.getCode().equals(invoiceReturn.getStatus())) {
                throw new PfscExtBusinessException("0001", "\u9000\u7968\u7533\u8bf7\u5355\u7684\u72b6\u6001\u5fc5\u987b\u662f" + this.enumsService.getDescr(InvoiceReturnStatus.TO_RETURN));
            }
            String applyNo1 = invoiceReturn.getApplyNo1();
            applyNo1s = FscStringUtils.string2List(applyNo1, ",");
            BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
            billApplyInfoVO.setApplyNoList((List<String>)applyNo1s);
            List<BillApplyInfo> applys = this.billApplyInfoMapper.getList(billApplyInfoVO);
            for (BillApplyInfo apply : applys) {
                if (InvoiceClasses.PAPER_INVOICE.getCode().equals(apply.getInvoiceClasses())) continue;
                throw new PfscExtBusinessException("0001", "\u53ea\u80fd\u4f5c\u5e9f\u7eb8\u8d28\u53d1\u7968");
            }
        }
        InvoiceReturnDetailVO invoiceReturnDetailVO = new InvoiceReturnDetailVO();
        invoiceReturnDetailVO.setBillNos(billNos);
        List<InvoiceReturnDetail> invoiceReturnDetails = this.invoiceReturnDetailMapper.selectList(invoiceReturnDetailVO);
        ArrayList<String> invoiceNo1s = new ArrayList<String>();
        applyNo1s = new HashSet();
        for (InvoiceReturnDetail invoiceReturnDetail : invoiceReturnDetails) {
            invoiceNo1s.add(invoiceReturnDetail.getInvoiceNo1());
            applyNo1s.add(invoiceReturnDetail.getApplyNo1());
        }
        SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
        saleInvoiceInfoVO.setInvoiceNoList(invoiceNo1s);
        saleInvoiceInfoVO.setInvoiceStatus(SaleInvoiceInfoInvoiceStatus.CANCEL.getCode());
        this.saleInvoiceInfoMapper.updateBy(saleInvoiceInfoVO);
        for (String applyNo1 : applyNo1s) {
            saleInvoiceInfoVO = new SaleInvoiceInfoVO();
            saleInvoiceInfoVO.setApplyNo(applyNo1);
            List<SaleInvoiceInfo> invoice1s = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
            int count = 0;
            for (SaleInvoiceInfo invoice1 : invoice1s) {
                if (!SaleInvoiceInfoInvoiceStatus.CANCEL.getCode().equals(invoice1.getInvoiceStatus())) continue;
                ++count;
            }
            if (count <= 0) continue;
            String billStatus = count == invoice1s.size() ? BillStatus.INVOICE_RETURN.getCode() : BillStatus.INVOICE_RETURN_PART.getCode();
            BillApplyInfo apply1 = new BillApplyInfo();
            apply1.setApplyNo(applyNo1);
            apply1.setBillStatus(billStatus);
            this.billApplyInfoMapper.updateByPrimaryKeySelective(apply1);
        }
        for (String billNo : billNos) {
            vo = new InvoiceReturnVO();
            vo.setBillNo(billNo);
            vo.setStatus(InvoiceReturnStatus.RETURNED.getCode());
            vo.setInvoiceReturnChannel("1");
            vo.setProcessUser(this.userInfoService.queryUserNameByUserId(reqBO.getUserId()));
            this.invoiceReturnDzcsAtomService.updateStatus(vo);
        }
        return new PfscExtRspBaseBO();
    }
}

