/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.PayTradeServiceFeeRecordListService;
import com.tydic.pfscext.api.busi.bo.PayTradeServiceFeeRecordListReqBO;
import com.tydic.pfscext.api.busi.bo.PayTradeServiceFeeRecordListRspBO;
import com.tydic.pfscext.api.busi.bo.PayTradeServiceFeeRecordRspBO;
import com.tydic.pfscext.dao.InquiryPayOrderMapper;
import com.tydic.pfscext.dao.InquiryTranInfoMapper;
import com.tydic.pfscext.dao.po.InquiryPayOrder;
import com.tydic.pfscext.dao.po.InquiryPayOrderExt;
import com.tydic.pfscext.dao.po.InquiryTranInfoPO;
import com.tydic.pfscext.dao.vo.InquiryTranInfoVO;
import com.tydic.pfscext.enums.InquiryPayFeeType;
import com.tydic.pfscext.enums.InquiryPayPass;
import com.tydic.pfscext.enums.InquiryTradeState;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayTradeServiceFeeRecordListServiceImpl
implements PayTradeServiceFeeRecordListService {
    @Autowired
    private InquiryTranInfoMapper inquiryTranInfoMapper;
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;
    @Autowired
    private EnumsService enumsService;

    public PayTradeServiceFeeRecordListRspBO tradeServiceFeeRecordList(PayTradeServiceFeeRecordListReqBO reqBO) {
        if (null == reqBO.getSupId()) {
            throw new PfscExtBusinessException("0001", "\u4f9b\u5e94\u5546\u7f16\u53f7[supId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayTradeServiceFeeRecordListRspBO rspBO = new PayTradeServiceFeeRecordListRspBO();
        int idx = (reqBO.getPageNo() - 1) * reqBO.getPageSize();
        if (idx < 0) {
            idx = 0;
        }
        int total = 0;
        InquiryTranInfoPO inquiryTranInfoPO = new InquiryTranInfoPO();
        inquiryTranInfoPO.setInquiryNo(reqBO.getInquiryNo());
        inquiryTranInfoPO.setTradeState(reqBO.getTradeState());
        inquiryTranInfoPO.setSupplierId(reqBO.getSupId());
        ArrayList<String> payFeeTypeList = new ArrayList<String>();
        payFeeTypeList.add(InquiryPayFeeType.TRADE_SERVICE_FEE.getCode());
        payFeeTypeList.add(InquiryPayFeeType.PURCH_SERVICE_FEE.getCode());
        inquiryTranInfoPO.setPayFeeTypeList(payFeeTypeList);
        int recordsTotal = this.inquiryTranInfoMapper.queryCountByConditions(inquiryTranInfoPO);
        if (recordsTotal > 0) {
            total = recordsTotal / reqBO.getPageSize() + (recordsTotal % reqBO.getPageSize() > 0 ? 1 : 0);
        }
        ArrayList<PayTradeServiceFeeRecordRspBO> rows = new ArrayList<PayTradeServiceFeeRecordRspBO>();
        InquiryTranInfoVO inquiryTranInfoVO = new InquiryTranInfoVO();
        BeanUtils.copyProperties((Object)inquiryTranInfoPO, (Object)inquiryTranInfoVO);
        inquiryTranInfoVO.setRowIndex(idx);
        inquiryTranInfoVO.setPageSize(reqBO.getPageSize());
        inquiryTranInfoVO.setSortOrder("MER_DATE desc");
        List<InquiryTranInfoPO> tranList = this.inquiryTranInfoMapper.queryListByConditions(inquiryTranInfoVO);
        if (null != tranList && !tranList.isEmpty()) {
            for (InquiryTranInfoPO tranInfo : tranList) {
                PayTradeServiceFeeRecordRspBO pts = new PayTradeServiceFeeRecordRspBO();
                BeanUtils.copyProperties((Object)tranInfo, (Object)pts);
                InquiryPayOrderExt inquiryPayOrderExt = new InquiryPayOrderExt();
                inquiryPayOrderExt.setInquiryNo(pts.getInquiryNo());
                InquiryPayOrder inquiryPayOrder = this.inquiryPayOrderMapper.selectByPrimaryKey(inquiryPayOrderExt);
                if (inquiryPayOrder != null) {
                    pts.setPayOrderName(inquiryPayOrder.getPayOrderName());
                }
                pts.setTradeStateDesc(this.enumsService.getDescr(InquiryTradeState.getInstance(tranInfo.getTradeState())));
                pts.setPayPassDesc(this.enumsService.getDescr(InquiryPayPass.getInstance(tranInfo.getPayType())));
                pts.setPayOrderNo(tranInfo.getGoodsId());
                rows.add(pts);
            }
        }
        rspBO.setRecordsTotal(Integer.valueOf(recordsTotal));
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotal(Integer.valueOf(total));
        rspBO.setRows(rows);
        return rspBO;
    }
}

