/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.comb.impl;

import com.ohaotian.plugin.file.FileClient;
import com.tydic.pfscext.api.busi.QueryBillApplyForMailService;
import com.tydic.pfscext.api.busi.bo.QueryBillApplyForMailReqBO;
import com.tydic.pfscext.api.busi.bo.QueryBillApplyForMailRspBO;
import com.tydic.pfscext.api.busi.vo.InvoiceForMailVO;
import com.tydic.pfscext.api.busi.vo.PurchaseNoListVO;
import com.tydic.pfscext.api.comb.FscExportInvoiceSentCombService;
import com.tydic.pfscext.api.comb.bo.FscExportInvoiceSentCombReqBO;
import com.tydic.pfscext.api.comb.bo.FscExportReceiptInfoCombRspBO;
import com.tydic.pfscext.common.ExcelFile;
import com.tydic.pfscext.config.FscProperties;
import com.tydic.pfscext.utils.DateUtil;
import com.tydic.pfscext.utils.FileUploadUtil;
import com.tydic.pfscext.utils.FscCommonUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="FSC_GROUP_DEV", interfaceClass=FscExportInvoiceSentCombService.class)
public class FscExportInvoiceSentCombServiceImpl
implements FscExportInvoiceSentCombService {
    private static final Logger log = LoggerFactory.getLogger(FscExportInvoiceSentCombServiceImpl.class);
    public final int MAX_NUM = 10000;
    @Resource
    FileClient fileClient;
    @Autowired
    private FscProperties fscProperties;
    private static final String BASE_UPLOAD_PATH = "fsc";
    @Reference(interfaceClass=QueryBillApplyForMailService.class, version="1.0.0", group="FSC_GROUP_DEV")
    private QueryBillApplyForMailService queryBillApplyForMailService;

    public FscExportReceiptInfoCombRspBO exportData(FscExportInvoiceSentCombReqBO fscExportInvoiceSentCombReqBO) {
        FscExportReceiptInfoCombRspBO retBO = new FscExportReceiptInfoCombRspBO();
        QueryBillApplyForMailReqBO reqBO = new QueryBillApplyForMailReqBO();
        BeanUtils.copyProperties((Object)fscExportInvoiceSentCombReqBO, (Object)reqBO);
        reqBO.setPageNo(Integer.valueOf(reqBO.getPageNo() == 0 ? 1 : reqBO.getPageNo()));
        reqBO.setOrderBy("CREATE_DATE asc");
        QueryBillApplyForMailRspBO rspBO = null;
        try {
            rspBO = this.queryBillApplyForMailService.queryInvoiceSent(reqBO);
        }
        catch (Exception e) {
            retBO.setRespCode("18000");
            retBO.setRespDesc("\u67e5\u8be2\u6570\u636e\u5f02\u5e38");
            return retBO;
        }
        if (!"0000".equals(rspBO.getRespCode())) {
            retBO.setRespCode("18000");
            retBO.setRespDesc(rspBO.getRespDesc());
            return retBO;
        }
        if (rspBO.getRows() != null) {
            int detailNum = 0;
            for (PurchaseNoListVO mail : rspBO.getRows()) {
                if (mail.getInvoiceForMailList() == null) continue;
                detailNum += mail.getInvoiceForMailList().size();
            }
            if (detailNum > 10000) {
                retBO.setRespCode("18000");
                retBO.setRespDesc("\u6570\u636e\u91cf\u592a\u5927\uff0c\u53d1\u7968\u660e\u7ec6\u4e0d\u80fd\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5f55\u5165\u67e5\u8be2\u6761\u4ef6\u540e\u5bfc\u51fa");
                return retBO;
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ExcelFile excel = new ExcelFile();
        String[] sheetNames = new String[]{"\u5df2\u90ae\u5bc4"};
        int sheetIdx = 0;
        excel.createSheet(sheetNames[sheetIdx]);
        Object[] title1 = new String[]{"\u53d1\u7968\u5df2\u90ae\u5bc4\u4fe1\u606f\u5217\u8868"};
        Object[] title2 = new String[]{"\u90ae\u5bc4\u65e5\u671f", "\u5e8f\u53f7", "\u5feb\u9012\u5355\u53f7", "\u53d1\u7968\u62ac\u5934", "\u6536\u4ef6\u4eba", "\u8054\u7cfb\u7535\u8bdd", "\u6536\u4ef6\u5730\u5740", "\u5305\u542b\u53d1\u7968\u6570\u91cf", "\u5907\u6ce8", "\u5bc4\u65b9\u5730\u5740", "\u5bc4\u4ef6\u4eba", "\u5bc4\u4ef6\u4eba\u7535\u8bdd"};
        String[] title3 = new String[]{"", "", "", "\u53d1\u7968\u53f7\u7801", "\u53d1\u7968\u62ac\u5934", "\u53d1\u7968\u91d1\u989d", "\u5f00\u7968\u65e5\u671f", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7"};
        String[][] fields2 = new String[][]{{"createDateString", "A", "S"}, {"", "B", "S"}, {"mailTicketNo", "C", "S"}, {"invoceName", "D", "S"}, {"name", "E", "S"}, {"mobile", "F", "S"}, {"detailAddress", "G", "S"}, {"count", "H", "N"}, {"failReason", "I", "S"}, {"senderAddress", "J", "S"}, {"sender", "K", "S"}, {"senderTel", "L", "S"}};
        String[][] fields3 = new String[][]{{"", "A", "S"}, {"", "B", "S"}, {"", "C", "S"}, {"invoiceNo", "D", "S"}, {"invoceName", "E", "S"}, {"amt", "F", "N"}, {"invoiceDateString", "G", "S"}, {"applyNo", "H", "S"}};
        Object[] cellFormat = new String[title1.length];
        excel.setArrayValueByNames(cellFormat, ",C,,\u9ed1\u4f53:20", new String[0]);
        excel.setCellsFormat(sheetIdx, (String[])cellFormat);
        excel.setColumnsWidth(sheetIdx, new Integer[]{10, 4, 16, 40, 40, 14, 40, 22, 20, 40, 6, 14});
        excel.addRow(sheetIdx, title1, 22);
        excel.mergeCell(sheetIdx, 0, "A", 0, "L");
        cellFormat = new String[title2.length];
        excel.setArrayValueByNames(cellFormat, ",C,,\u9ed1\u4f53:12", new String[0]);
        excel.setCellsFormat(sheetIdx, (String[])cellFormat);
        excel.addRow(sheetIdx, title2, 14);
        cellFormat = new String[title2.length];
        excel.setArrayValueByNames(cellFormat, ",C,", new String[0]);
        excel.setCellsFormat(sheetIdx, (String[])cellFormat);
        for (int k = 0; k < rspBO.getRows().size(); ++k) {
            PurchaseNoListVO mail = (PurchaseNoListVO)rspBO.getRows().get(k);
            Object[] fieldsData = new String[title2.length];
            for (int i = 0; i < fields2.length; ++i) {
                String fieldName = fields2[i][0];
                String cellName = fields2[i][1];
                int idx = ExcelFile.cellNameToIndex((String)cellName);
                fieldsData[idx] = this.getProp(mail, fieldName);
            }
            fieldsData[1] = String.valueOf(k + 1);
            excel.addRow(sheetIdx, fieldsData, 14);
            List invoices = mail.getInvoiceForMailList();
            if (invoices == null) continue;
            for (int j = 0; j < invoices.size(); ++j) {
                if (j == 0) {
                    fieldsData = title3;
                    excel.addRow(sheetIdx, fieldsData, 14);
                }
                InvoiceForMailVO invoice = (InvoiceForMailVO)invoices.get(j);
                fieldsData = new String[title3.length];
                for (int i = 0; i < fields3.length; ++i) {
                    String fieldName = fields3[i][0];
                    String cellName = fields3[i][1];
                    int idx = ExcelFile.cellNameToIndex((String)cellName);
                    fieldsData[idx] = this.getProp(invoice, fieldName);
                }
                excel.addRow(sheetIdx, fieldsData, 14);
            }
        }
        try {
            excel.getWorkBook().write((OutputStream)out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        excel.close();
        String fileName = "Sent_" + DateUtil.dateToStr(new Date(), "yyyyMMddHHmmss") + (int)((Math.random() * 9.0 + 1.0) * 1000.0) + ".xls";
        InputStream inputStream = null;
        try {
            inputStream = FscCommonUtils.outputStreamToInputStream((OutputStream)out);
            if (null != inputStream) {
                String ossurl = FileUploadUtil.uploadFileToOss(inputStream, fileName);
                retBO.setUrl(ossurl);
                log.debug("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff0c\u4fdd\u5b58\u5230\u8def\u5f84(" + retBO.getUrl() + ")\u4e2d");
            }
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5230OSS\u5931\u8d25:" + e.getMessage());
            retBO.setRespCode("18000");
            retBO.setRespDesc("\u4e0a\u4f20\u6587\u4ef6\u5230OSS\u5931\u8d25:" + e.getMessage());
            return retBO;
        }
        retBO.setRespCode("0000");
        retBO.setRespDesc("\u4e0a\u4f20\u6210\u529f");
        return retBO;
    }

    private Object getProp(Object bean, String name) {
        String v = null;
        try {
            if (name != null && !"".equals(name)) {
                v = org.apache.commons.beanutils.BeanUtils.getProperty((Object)bean, (String)name);
                return v;
            }
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6Bean\u5c5e\u6027\u5230Excel\u6570\u636e\u5217\u5931\u8d25,name=" + name, (Throwable)e);
        }
        return null;
    }
}

