/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.comb.impl;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.pfscext.api.busi.BusiExportOutstockDetailInfoService;
import com.tydic.pfscext.api.busi.BusiGetYuanGuangAttachmentNameService;
import com.tydic.pfscext.api.busi.bo.BusiExportListOutstockInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiExportOutstockDetailInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BusiExportRowOutstockDetailInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetYuanGuangAttachmentNameReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetYuanGuangAttachmentNameRspBO;
import com.tydic.pfscext.api.busi.vo.SaleInvoiceVO;
import com.tydic.pfscext.api.comb.FscExportOutStockDetailInfoCombService;
import com.tydic.pfscext.api.comb.bo.FscExportOutStockInfoCombReqBo;
import com.tydic.pfscext.api.comb.bo.FscExportOutStockInfoCombRspBo;
import com.tydic.pfscext.config.FscProperties;
import com.tydic.pfscext.enums.YuanGuangBillType;
import com.tydic.pfscext.utils.FileUploadUtil;
import com.tydic.pfscext.utils.FscCommonUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@org.apache.dubbo.config.annotation.Service(version="1.0.0", group="FSC_GROUP_DEV", interfaceClass=FscExportOutStockDetailInfoCombService.class)
public class FscExportOutStockDetailInfoCombServiceImpl
implements FscExportOutStockDetailInfoCombService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String BASE_UPLOAD_PATH = "fsc";
    @Autowired
    private BusiExportOutstockDetailInfoService busiExportOutstockDetailInfoService;
    @Autowired
    private BusiGetYuanGuangAttachmentNameService busiGetYuanGuangAttachmentNameService;
    @Autowired
    private FscProperties fscProperties;
    @Resource
    FileClient fileClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FscExportOutStockInfoCombRspBo exportData(FscExportOutStockInfoCombReqBo reqBo) {
        PdfWriter writer;
        this.LOGGER.info("\u51fa\u5e93\u6c47\u603b\u5355\u8be6\u60c5\u9875\u5bfc\u51fa\u51fa\u5e93\u5355 comb\u670d\u52a1:" + reqBo);
        FscExportOutStockInfoCombRspBo retBo = new FscExportOutStockInfoCombRspBo();
        if (StringUtils.isEmpty((Object)reqBo.getTotalNo())) {
            this.LOGGER.error("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'totalNo'\u4e0d\u80fd\u4e3a\u7a7a");
            retBo.setRespCode("18000");
            retBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'totalNo'\u4e0d\u80fd\u4e3a\u7a7a");
            return retBo;
        }
        BusiExportListOutstockInfoReqBO busiExportListOutstockInfoReqBO = new BusiExportListOutstockInfoReqBO();
        BeanUtils.copyProperties((Object)reqBo, (Object)busiExportListOutstockInfoReqBO);
        BusiExportOutstockDetailInfoRspBO rspBO = this.busiExportOutstockDetailInfoService.exportOutstockDetailInfo(busiExportListOutstockInfoReqBO);
        if (rspBO == null || !"0000".equals(rspBO.getRespCode())) {
            this.LOGGER.error("\u67e5\u8be2\u6570\u636e\u5931\u8d25");
            retBo.setRespCode("18000");
            retBo.setRespDesc(rspBO == null ? "\u67e5\u8be2\u6570\u636e\u5931\u8d25" : rspBO.getRespDesc());
            return retBo;
        }
        List rows = rspBO.getRows();
        Document document = new Document(PageSize.A4.rotate(), -60.0f, -60.0f, 15.0f, 40.0f);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BaseFont baseFont = null;
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            this.LOGGER.error("\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519\uff1a" + e);
            retBo.setRespCode("18000");
            retBo.setRespDesc("\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519\uff1a" + e);
            return retBo;
        }
        Font titleFont = new Font(baseFont, 14.0f, 1);
        Font contentFont = new Font(baseFont, 8.0f, 0);
        Font footerFont = new Font(baseFont, 10.0f, 1);
        int COLUMNS = 6;
        try {
            writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
        }
        catch (Exception e) {
            this.LOGGER.error("\u628apdf\u5199\u5230\u8f93\u51fa\u6d41\u51fa\u9519 \uff1a" + e);
            retBo.setRespCode("18000");
            retBo.setRespDesc("\u628apdf\u5199\u5230\u8f93\u51fa\u6d41\u51fa\u9519 \uff1a" + e);
            return retBo;
        }
        FscCommonUtils.setFooter((PdfWriter)writer, (BaseFont)baseFont, (int)10, (Rectangle)PageSize.A4);
        document.open();
        PdfPTable titleTable1 = new PdfPTable(1);
        PdfPCell titleCell1 = new PdfPCell(new Phrase("\u7269\u8d44\u9500\u552e\u51fa\u5e93\u5355", titleFont));
        titleCell1.setColspan(1);
        titleCell1.setBorder(0);
        titleCell1.setFixedHeight(30.0f);
        titleCell1.setHorizontalAlignment(1);
        titleCell1.setVerticalAlignment(5);
        titleTable1.addCell(titleCell1);
        try {
            document.add((Element)titleTable1);
        }
        catch (DocumentException e) {
            this.LOGGER.error("pdf\u8ffd\u52a0table\u51fa\u9519:" + (Object)((Object)e));
            retBo.setRespCode("18000");
            retBo.setRespDesc("pdf\u8ffd\u52a0table\u51fa\u9519:" + (Object)((Object)e));
            return retBo;
        }
        PdfPTable table1 = new PdfPTable(7);
        PdfPCell cell1 = new PdfPCell();
        cell1.setColspan(0);
        cell1.setBorder(0);
        cell1.setHorizontalAlignment(1);
        cell1.setVerticalAlignment(5);
        table1.addCell(cell1);
        cell1.setPhrase(new Phrase(rspBO.getCreateDate(), contentFont));
        cell1.setColspan(3);
        cell1.setHorizontalAlignment(0);
        table1.addCell(cell1);
        cell1.setPhrase(new Phrase("\u51fa\u5e93\u6c47\u603b\u5355\u53f7\uff1a" + reqBo.getTotalNo(), contentFont));
        cell1.setColspan(2);
        cell1.setHorizontalAlignment(0);
        table1.addCell(cell1);
        cell1.setPhrase(new Phrase("\u91d1\u989d\u5355\u4f4d\uff1a\u5143", contentFont));
        cell1.setColspan(2);
        cell1.setHorizontalAlignment(1);
        table1.addCell(cell1);
        try {
            document.add((Element)table1);
        }
        catch (DocumentException e) {
            this.LOGGER.error("pdf\u8ffd\u52a0table\u51fa\u9519:" + (Object)((Object)e));
            retBo.setRespCode("18000");
            retBo.setRespDesc("pdf\u8ffd\u52a0table\u51fa\u9519:" + (Object)((Object)e));
            return retBo;
        }
        PdfPTable headTable = new PdfPTable(6);
        PdfPCell headCell = new PdfPCell(new Phrase("\u5e8f\u53f7", contentFont));
        headCell.setHorizontalAlignment(1);
        headCell.setVerticalAlignment(5);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u51fa\u5e93\u5355\u5355\u53f7", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u6210\u672c ", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u53d1\u7968", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u8d27\u6b3e", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u7a0e\u91d1", contentFont));
        headTable.addCell(headCell);
        try {
            document.add((Element)headTable);
        }
        catch (DocumentException e) {
            this.LOGGER.error("pdf\u8ffd\u52a0table\u51fa\u9519:" + (Object)((Object)e));
            retBo.setRespCode("18000");
            retBo.setRespDesc("pdf\u8ffd\u52a0table\u51fa\u9519:" + (Object)((Object)e));
            return retBo;
        }
        int count = 1;
        for (BusiExportRowOutstockDetailInfoRspBO row : rows) {
            List saleInvoiceList = row.getSaleInvoiceList();
            for (SaleInvoiceVO saleInvoiceVO : saleInvoiceList) {
                PdfPTable detailTable = new PdfPTable(6);
                PdfPCell detailCell = new PdfPCell(new Phrase("" + count++, contentFont));
                detailCell.setHorizontalAlignment(1);
                detailCell.setVerticalAlignment(5);
                detailTable.addCell(detailCell);
                detailCell.setPhrase(new Phrase(row.getOutstockNo(), contentFont));
                detailTable.addCell(detailCell);
                detailCell.setPhrase(new Phrase(row.getAmt(), contentFont));
                detailTable.addCell(detailCell);
                detailCell.setPhrase(new Phrase(saleInvoiceVO.getInvoiceNo(), contentFont));
                detailTable.addCell(detailCell);
                detailCell.setPhrase(new Phrase(saleInvoiceVO.getUntaxAmt(), contentFont));
                detailTable.addCell(detailCell);
                detailCell.setPhrase(new Phrase(saleInvoiceVO.getTaxAmt(), contentFont));
                detailTable.addCell(detailCell);
                try {
                    document.add((Element)detailTable);
                }
                catch (DocumentException e) {
                    this.LOGGER.error("pdf\u8ffd\u52a0table\u51fa\u9519:" + (Object)((Object)e));
                    retBo.setRespCode("18000");
                    retBo.setRespDesc("pdf\u8ffd\u52a0table\u51fa\u9519:" + (Object)((Object)e));
                    return retBo;
                }
            }
        }
        PdfPTable table2 = new PdfPTable(6);
        PdfPCell cell2 = new PdfPCell(new Phrase("\u6210\u672c\u5408\u8ba1", contentFont));
        cell2.setColspan(2);
        cell2.setHorizontalAlignment(1);
        cell2.setVerticalAlignment(5);
        table2.addCell(cell2);
        cell2.setPhrase(new Phrase(rspBO.getSum(), contentFont));
        cell2.setHorizontalAlignment(1);
        cell2.setColspan(1);
        table2.addCell(cell2);
        cell2.setPhrase(new Phrase("\u53d1\u7968\u5408\u8ba1", contentFont));
        cell2.setHorizontalAlignment(1);
        cell2.setColspan(1);
        table2.addCell(cell2);
        cell2.setPhrase(new Phrase(rspBO.getSumAmt(), contentFont));
        cell2.setColspan(2);
        cell2.setHorizontalAlignment(1);
        table2.addCell(cell2);
        try {
            document.add((Element)table2);
        }
        catch (DocumentException e) {
            this.LOGGER.error("pdf\u8ffd\u52a0table\u51fa\u9519:" + (Object)((Object)e));
            retBo.setRespCode("18000");
            retBo.setRespDesc("pdf\u8ffd\u52a0table\u51fa\u9519:" + (Object)((Object)e));
            return retBo;
        }
        document.close();
        InputStream inputStream = null;
        try {
            inputStream = FscCommonUtils.outputStreamToInputStream((OutputStream)baos);
            if (null != inputStream) {
                BusiGetYuanGuangAttachmentNameReqBO nameReqBO = new BusiGetYuanGuangAttachmentNameReqBO();
                nameReqBO.setBillTypeCode(YuanGuangBillType.OUTSTOCK_TOTAL_OUTBOUND.getCode());
                nameReqBO.setBillNo(reqBo.getTotalNo());
                nameReqBO.setCompanyId(rspBO.getOrgId());
                nameReqBO.setSuffixName(".pdf");
                BusiGetYuanGuangAttachmentNameRspBO nameRspBO = this.busiGetYuanGuangAttachmentNameService.query(nameReqBO);
                String ossurl = FileUploadUtil.uploadFileToOss(inputStream, nameRspBO.getAttachmentName());
                retBo.setUrl(ossurl);
                this.LOGGER.debug("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff0c\u4fdd\u5b58\u5230\u8def\u5f84(" + retBo.getUrl() + ")\u4e2d");
                retBo.setRespCode("0000");
                retBo.setRespDesc("\u4e0a\u4f20\u6210\u529f");
            }
        }
        catch (Exception e) {
            this.LOGGER.error("\u4e0a\u4f20\u6587\u4ef6\u5230OSS\u5931\u8d25:" + e.getMessage());
            retBo.setRespCode("18000");
            retBo.setRespDesc("\u4e0a\u4f20\u6587\u4ef6\u5230OSS\u5931\u8d25:" + e.getMessage());
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.LOGGER.error("\u5173\u95ed\u8f93\u5165\u6d41\u51fa\u9519:" + e.getMessage());
                    retBo.setRespCode("18000");
                    retBo.setRespDesc("\u4e0a\u4f20\u6587\u4ef6\u5230OSS\u5931\u8d25:" + e.getMessage());
                }
            }
        }
        return retBo;
    }
}

