/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.comb.impl;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.pfscext.api.busi.BusiExportReceiptDetailInfoService;
import com.tydic.pfscext.api.busi.BusiGetYuanGuangAttachmentNameService;
import com.tydic.pfscext.api.busi.bo.BusiExportListReceiptInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiExportReceiptDetailInfoRsqBO;
import com.tydic.pfscext.api.busi.bo.BusiExportRowReceiptDetailInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetYuanGuangAttachmentNameReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetYuanGuangAttachmentNameRspBO;
import com.tydic.pfscext.api.busi.vo.PayInvoiceInfoRowVO;
import com.tydic.pfscext.api.comb.FscExportReceiptDetailInfoCombService;
import com.tydic.pfscext.api.comb.bo.FscExportReceiptInfoCombReqBO;
import com.tydic.pfscext.api.comb.bo.FscExportReceiptInfoCombRspBO;
import com.tydic.pfscext.config.FscProperties;
import com.tydic.pfscext.enums.YuanGuangBillType;
import com.tydic.pfscext.utils.FileUploadUtil;
import com.tydic.pfscext.utils.FscCommonUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="FSC_GROUP_DEV", interfaceClass=FscExportReceiptDetailInfoCombService.class)
public class FscExportReceiptDetailInfoCombServiceImpl
implements FscExportReceiptDetailInfoCombService {
    private static final Logger log = LoggerFactory.getLogger(FscExportReceiptDetailInfoCombServiceImpl.class);
    @Autowired
    private BusiExportReceiptDetailInfoService busiExportReceiptDetailInfoService;
    @Autowired
    private BusiGetYuanGuangAttachmentNameService busiGetYuanGuangAttachmentNameService;
    @Resource
    FileClient fileClient;
    @Autowired
    private FscProperties fscProperties;
    private static final String BASE_UPLOAD_PATH = "fsc";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FscExportReceiptInfoCombRspBO exportData(FscExportReceiptInfoCombReqBO reqBO) {
        PdfWriter writer;
        if (log.isDebugEnabled()) {
            log.debug("reqBO=" + reqBO);
        }
        FscExportReceiptInfoCombRspBO retBo = new FscExportReceiptInfoCombRspBO();
        if (reqBO.getApplyNo() == null) {
            retBo.setRespCode("18000");
            retBo.setRespDesc("\u6c47\u603b\u5355\u53f7[applyNo]\u4e0d\u80fd\u4e3a\u7a7a");
            return retBo;
        }
        Document document = new Document(PageSize.A4.rotate(), -75.0f, -75.0f, 15.0f, 40.0f);
        BaseFont baseFont = null;
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            log.error("\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519\u3002reqBO=" + reqBO, (Throwable)e);
            retBo.setRespCode("18000");
            retBo.setRespDesc("\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519");
            return retBo;
        }
        Font titleFont = new Font(baseFont, 14.0f, 1);
        Font contentFont = new Font(baseFont, 8.0f, 0);
        Font footerFont = new Font(baseFont, 10.0f, 1);
        int COLUMNS = 5;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
        }
        catch (Exception e) {
            log.error("\u628apdf\u5199\u5230\u8f93\u51fa\u6d41\u51fa\u9519\u3002reqBO=" + reqBO, (Throwable)e);
            retBo.setRespCode("18000");
            retBo.setRespDesc("\u628apdf\u5199\u5230\u8f93\u51fa\u6d41\u51fa\u9519");
            return retBo;
        }
        FscCommonUtils.setFooter((PdfWriter)writer, (BaseFont)baseFont, (int)10, (Rectangle)PageSize.A4);
        document.open();
        BusiExportReceiptDetailInfoRsqBO rspBO = null;
        try {
            BusiExportListReceiptInfoReqBO reqBo = new BusiExportListReceiptInfoReqBO();
            reqBo.setApplyNo(reqBO.getApplyNo());
            rspBO = this.busiExportReceiptDetailInfoService.exportReceiptDetailInfo(reqBo);
            if (rspBO == null || !"0000".equals(rspBO.getRespCode())) {
                retBo.setRespCode("18000");
                retBo.setRespDesc("\u67e5\u8be2\u6570\u636e\u5e93\u5931\u8d25");
                return retBo;
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u65e0\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002reqBO=" + reqBO, (Throwable)e);
            retBo.setRespCode("18000");
            retBo.setRespDesc("\u67e5\u8be2\u65e0\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002");
            return retBo;
        }
        List rows = rspBO.getRows();
        PdfPTable titleTable1 = new PdfPTable(1);
        PdfPCell titleCell1 = new PdfPCell(new Phrase("\u7269\u8d44\u9500\u552e\u5165\u5e93\u5355", titleFont));
        titleCell1.setColspan(1);
        titleCell1.setBorder(0);
        titleCell1.setFixedHeight(30.0f);
        titleCell1.setHorizontalAlignment(1);
        titleCell1.setVerticalAlignment(5);
        titleTable1.addCell(titleCell1);
        try {
            document.add((Element)titleTable1);
        }
        catch (DocumentException e) {
            retBo.setRespCode("18000");
            retBo.setRespDesc("pdf\u8ffd\u52a0table\u51fa\u9519");
            return retBo;
        }
        PdfPTable table1 = new PdfPTable(7);
        PdfPCell cell1 = new PdfPCell();
        cell1.setColspan(0);
        cell1.setBorder(0);
        cell1.setHorizontalAlignment(1);
        cell1.setVerticalAlignment(5);
        table1.addCell(cell1);
        cell1.setPhrase(new Phrase("\u5165\u5e93\u6c47\u603b\u5355\uff1a" + reqBO.getApplyNo(), contentFont));
        cell1.setColspan(2);
        cell1.setHorizontalAlignment(0);
        table1.addCell(cell1);
        cell1.setPhrase(new Phrase(rspBO.getDocumentationDate(), contentFont));
        cell1.setColspan(3);
        cell1.setHorizontalAlignment(0);
        table1.addCell(cell1);
        cell1.setPhrase(new Phrase("\u91d1\u989d\u5355\u4f4d\uff1a\u5143", contentFont));
        cell1.setColspan(2);
        cell1.setHorizontalAlignment(1);
        table1.addCell(cell1);
        try {
            document.add((Element)table1);
        }
        catch (DocumentException e) {
            log.error("pdf\u8ffd\u52a0table\u51fa\u9519\u3002reqBO=" + reqBO, (Throwable)e);
            retBo.setRespCode("18000");
            retBo.setRespDesc("pdf\u8ffd\u52a0table\u51fa\u9519");
            return retBo;
        }
        PdfPTable headTable = new PdfPTable(5);
        PdfPCell headCell = new PdfPCell(new Phrase("\u5e8f\u53f7", contentFont));
        headCell.setHorizontalAlignment(1);
        headCell.setVerticalAlignment(5);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u5165\u5e93\u5355\u5355\u53f7", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u53d1\u7968", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u8d27\u6b3e", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u7a0e\u91d1", contentFont));
        headTable.addCell(headCell);
        try {
            document.add((Element)headTable);
        }
        catch (DocumentException e) {
            retBo.setRespCode("18000");
            retBo.setRespDesc("pdf\u8ffd\u52a0table\u51fa\u9519");
            return retBo;
        }
        int count = 1;
        for (BusiExportRowReceiptDetailInfoRspBO row : rows) {
            List invoiceInfoList = row.getInvoiceInfoList();
            for (PayInvoiceInfoRowVO payInvoiceInfo : invoiceInfoList) {
                PdfPTable detailTable = new PdfPTable(5);
                PdfPCell detailCell = new PdfPCell(new Phrase("" + count++, contentFont));
                detailCell.setHorizontalAlignment(1);
                detailCell.setVerticalAlignment(5);
                detailTable.addCell(detailCell);
                detailCell.setPhrase(new Phrase(row.getEntryNo(), contentFont));
                detailTable.addCell(detailCell);
                detailCell.setPhrase(new Phrase(payInvoiceInfo.getInvoiceNo(), contentFont));
                detailTable.addCell(detailCell);
                detailCell.setPhrase(new Phrase(payInvoiceInfo.getNotTaxAmt(), contentFont));
                detailTable.addCell(detailCell);
                detailCell.setPhrase(new Phrase(payInvoiceInfo.getTaxAmt(), contentFont));
                detailTable.addCell(detailCell);
                try {
                    document.add((Element)detailTable);
                }
                catch (DocumentException e) {
                    log.error("pdf\u8ffd\u52a0table\u51fa\u9519\u3002reqBO=" + reqBO, (Throwable)e);
                    retBo.setRespCode("18000");
                    retBo.setRespDesc("pdf\u8ffd\u52a0table\u51fa\u9519");
                    return retBo;
                }
            }
        }
        PdfPTable table2 = new PdfPTable(5);
        PdfPCell cell2 = new PdfPCell(new Phrase("\u5408\u8ba1\uff1a", contentFont));
        cell2.setHorizontalAlignment(2);
        cell2.setVerticalAlignment(5);
        cell2.setColspan(3);
        table2.addCell(cell2);
        cell2.setPhrase(new Phrase(rspBO.getNotTaxAmtSum(), contentFont));
        cell2.setHorizontalAlignment(1);
        cell2.setColspan(1);
        table2.addCell(cell2);
        cell2.setPhrase(new Phrase(rspBO.getTaxAmtSum(), contentFont));
        cell2.setHorizontalAlignment(1);
        cell2.setColspan(1);
        table2.addCell(cell2);
        try {
            document.add((Element)table2);
        }
        catch (DocumentException e) {
            log.error("pdf\u8ffd\u52a0table\u51fa\u9519\u3002reqBO=" + reqBO, (Throwable)e);
            retBo.setRespCode("18000");
            retBo.setRespDesc("pdf\u8ffd\u52a0table\u51fa\u9519");
            return retBo;
        }
        document.close();
        InputStream inputStream = null;
        try {
            inputStream = FscCommonUtils.outputStreamToInputStream((OutputStream)baos);
            if (null != inputStream) {
                BusiGetYuanGuangAttachmentNameReqBO nameReqBO = new BusiGetYuanGuangAttachmentNameReqBO();
                nameReqBO.setBillTypeCode(YuanGuangBillType.ENTRY_MATERIAL_PURCHASE_ENTRY.getCode());
                nameReqBO.setBillNo(reqBO.getApplyNo());
                nameReqBO.setCompanyId(rspBO.getCompanyId());
                nameReqBO.setSuffixName(".pdf");
                BusiGetYuanGuangAttachmentNameRspBO nameRspBO = this.busiGetYuanGuangAttachmentNameService.query(nameReqBO);
                String ossurl = FileUploadUtil.uploadFileToOss(inputStream, nameRspBO.getAttachmentName());
                retBo.setUrl(ossurl);
                log.debug("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff0c\u4fdd\u5b58\u5230\u8def\u5f84(" + retBo.getUrl() + ")\u4e2d");
                retBo.setRespCode("0000");
                retBo.setRespDesc("\u4e0a\u4f20\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5230OSS\u5931\u8d25:" + e.getMessage());
            retBo.setRespCode("18000");
            retBo.setRespDesc("\u4e0a\u4f20\u6587\u4ef6\u5230OSS\u5931\u8d25:" + e.getMessage());
            FscExportReceiptInfoCombRspBO fscExportReceiptInfoCombRspBO = retBo;
            return fscExportReceiptInfoCombRspBO;
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u8f93\u5165\u6d41\u51fa\u9519:" + e.getMessage());
                }
            }
        }
        return retBo;
    }
}

