/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.atom.impl;

import com.tydic.pfscext.api.busi.bo.SubAcctInfoExt;
import com.tydic.pfscext.dao.PurchaseUnitInfoMapper;
import com.tydic.pfscext.dao.SubAcctInfoMapper;
import com.tydic.pfscext.dao.po.AdvanceReceive;
import com.tydic.pfscext.dao.po.PurchaseUnitInfo;
import com.tydic.pfscext.enums.BaseEnums;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.SubAccountServiceType;
import com.tydic.pfscext.external.api.FscOrganizationInfoFromUmcService;
import com.tydic.pfscext.external.api.bo.ProjectInfoBO;
import com.tydic.pfscext.external.api.bo.TsupplierInfoRspBO;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="organizationInfoService")
public class OrganizationInfoServiceImpl
implements OrganizationInfoService {
    private static final Logger logger = LoggerFactory.getLogger(OrganizationInfoServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private SubAcctInfoMapper subAcctInfoMapper;
    @Autowired
    private PurchaseUnitInfoMapper purchaseUnitInfoMapper;
    @Autowired
    private FscOrganizationInfoFromUmcService fscOrganizationInfoFromUmcService;

    @Override
    public String queryOrgName(Long orgId) {
        return this.fscOrganizationInfoFromUmcService.queryOrgName(orgId);
    }

    @Override
    public List<String> queryOrgNames(List<Long> orgIds) {
        return this.fscOrganizationInfoFromUmcService.queryOrgNames(orgIds);
    }

    @Override
    public String[] queryOrgNames(Long[] orgIds) {
        return this.fscOrganizationInfoFromUmcService.queryOrgNames(orgIds);
    }

    @Override
    public List<Long> getChildrenOrgIds(Long parentOrgId) {
        return this.fscOrganizationInfoFromUmcService.getChildrenOrgIds(parentOrgId);
    }

    @Override
    public ProjectInfoBO queryProjectName(Long projectId) {
        return this.fscOrganizationInfoFromUmcService.queryProjectInfo(projectId);
    }

    @Override
    public PurchaseUnitInfo queryParentAccount(Long accountId) {
        if (accountId == null) {
            return null;
        }
        Long parentAccountId = this.queryParentAccountId(accountId);
        PurchaseUnitInfo purchaseUnitInfo = this.purchaseUnitInfoMapper.selectByPrimaryKey(parentAccountId);
        if (purchaseUnitInfo == null) {
            purchaseUnitInfo = new PurchaseUnitInfo();
            purchaseUnitInfo.setPurchaseProjectId(parentAccountId);
            purchaseUnitInfo.setPurchaseProjectName(this.queryProjectName(parentAccountId).getAccountName());
            purchaseUnitInfo.setSaleContactNo(null);
        }
        return purchaseUnitInfo;
    }

    @Override
    public Long queryParentAccountId(Long accountId) {
        Long parentAccountId = this.fscOrganizationInfoFromUmcService.queryParentAccountId(accountId);
        return null == parentAccountId ? accountId : parentAccountId;
    }

    @Override
    public String querySupplierName(Long supId) {
        return this.fscOrganizationInfoFromUmcService.querySupplierName(supId);
    }

    @Override
    public String[] querySuppliesName(Long[] supIds) {
        return this.fscOrganizationInfoFromUmcService.querySuppliesName(supIds);
    }

    @Override
    public List<String> querySuppliesName(List<Long> supIds) {
        return this.fscOrganizationInfoFromUmcService.querySuppliesName(supIds);
    }

    @Override
    public Map<Long, TsupplierInfoRspBO> querySupplies(List<Long> supIds) {
        return this.fscOrganizationInfoFromUmcService.querySupplies(supIds);
    }

    @Override
    public String obtainOrgNameBySubAcct(SubAcctInfoExt subAcctInfoExt) {
        String orgName = "";
        if (subAcctInfoExt == null) {
            return orgName;
        }
        String sourceDescr = this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)subAcctInfoExt.getSource()));
        orgName = subAcctInfoExt.getSubAcctName().replaceFirst(sourceDescr, "").replace("(\u8d26\u5957)", "");
        return orgName;
    }

    @Override
    public String obtainOrgNameByAdvanceReceive(AdvanceReceive advanceReceive) {
        String orgName = "";
        if (advanceReceive == null) {
            return orgName;
        }
        SubAcctInfoExt subAcctInfoExt = new SubAcctInfoExt();
        subAcctInfoExt.setSubAcctNo(advanceReceive.getRecSubAcct());
        List<SubAcctInfoExt> subAcctInfoExtList = this.subAcctInfoMapper.selectWihtMainAcct(subAcctInfoExt);
        if (subAcctInfoExtList.isEmpty()) {
            logger.debug("\u901a\u8fc7\u94f6\u884c\u6d41\u6c34\u83b7\u53d6\u4ed8\u6b3e\u5355\u4f4d\u540d\u79f0\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u627e\u5230\u5b50\u8d26\u6237\u3002\u5b50\u8d26\u53f7=" + advanceReceive.getRecSubAcct());
            return orgName;
        }
        subAcctInfoExt = subAcctInfoExtList.get(0);
        orgName = SubAccountServiceType.DEFAULT.getCode().equals(subAcctInfoExt.getServiceType()) ? this.obtainOrgNameBySubAcct(subAcctInfoExt) : advanceReceive.getTransferAcctName();
        return orgName;
    }

    @Override
    public String queryServiceDepartName(Long serviceDepartId) {
        return this.fscOrganizationInfoFromUmcService.queryServiceDepartName(serviceDepartId);
    }

    @Override
    public Map<Long, String> queryServiceDepartNameByAccountIds(List<Long> accountIds) {
        return this.fscOrganizationInfoFromUmcService.queryServiceDepartNameByAccountIds(accountIds);
    }

    @Override
    public Long queryBranchCompanyByAccountId(Long accountId) {
        return this.fscOrganizationInfoFromUmcService.queryBranchCompanyByAccountId(accountId);
    }

    @Override
    public List<ProjectInfoBO> queryProjectInfoByServDepartId(List<Long> serviceDepartIdList) {
        return this.fscOrganizationInfoFromUmcService.queryProjectInfoByServDepartId(serviceDepartIdList);
    }
}

