/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.BusiAdvanceRecBankPushService;
import com.tydic.pfscext.api.busi.bo.BusiAdvanceRecBankPushBodyReqBO;
import com.tydic.pfscext.api.busi.bo.BusiAdvanceRecBankPushReqBO;
import com.tydic.pfscext.api.busi.bo.BusiAdvanceRecBankPushRspBO;
import com.tydic.pfscext.api.busi.bo.SubAcctInfoExt;
import com.tydic.pfscext.dao.AdvanceReceiveMapper;
import com.tydic.pfscext.dao.NormalTransactionMapper;
import com.tydic.pfscext.dao.po.AdvanceReceive;
import com.tydic.pfscext.dao.po.NormalTransaction;
import com.tydic.pfscext.enums.AdvanceReceiveStatus;
import com.tydic.pfscext.enums.AdvanceReceiveTransactionType;
import com.tydic.pfscext.enums.BusinessType;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.ReceiveType;
import com.tydic.pfscext.enums.SubAccountServiceType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.AccountantEngineService;
import com.tydic.pfscext.service.atom.SequenceNoService;
import com.tydic.pfscext.service.atom.SubAccountService;
import com.tydic.pfscext.service.atom.TransactionService;
import com.tydic.pfscext.service.atom.bo.AccountantEngineReqBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiAdvanceRecBankPushService.class)
public class BusiAdvanceRecBankPushServiceImpl
implements BusiAdvanceRecBankPushService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAdvanceRecBankPushServiceImpl.class);
    private static final String SUCCESS = "S";
    private static final String FAIL = "F";
    @Resource
    private SequenceNoService advanceReceiveSeqNoService;
    @Autowired
    private SubAccountService subAccountService;
    @Autowired
    private AccountantEngineService accountantEngineService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AdvanceReceiveMapper advanceReceiveMapper;
    @Autowired
    private NormalTransactionMapper normalTransactionMapper;

    public BusiAdvanceRecBankPushRspBO addAdvanceRecBankPush(BusiAdvanceRecBankPushReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u94f6\u884c\u63a8\u9001\u4ea4\u6613\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        BusiAdvanceRecBankPushRspBO rspBO = new BusiAdvanceRecBankPushRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.getSys_head().setService_code("bms_zizhmxts");
        rspBO.getSys_head().setService_scene("00");
        rspBO.getSys_head().setRet_status(SUCCESS);
        rspBO.getSys_head().getRet().getStruct().setRet_msg("\u4ea4\u6613\u6210\u529f");
        rspBO.getSys_head().getRet().getStruct().setRet_code("0000");
        rspBO.getSys_head().setTran_code("bms_zizhmxts00");
        rspBO.getSys_head().setTran_timestamp(new SimpleDateFormat("HHmmss").format(new Date()));
        rspBO.getSys_head().setVersion("2.0");
        final Long id = this.advanceReceiveSeqNoService.generateSeqNo();
        rspBO.getSys_head().setConsumer_seq_no(String.format("%022d", id));
        rspBO.getApp_head().setBranch_id("9998");
        rspBO.getApp_head().setUser_id("EB001");
        rspBO.setLocal_head("\n");
        rspBO.setBody("\n");
        if (reqBO == null || reqBO.getBody() == null) {
            logger.error("\u4ea4\u6613\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f\uff1a\u94f6\u884c\u63a8\u9001\u7684\u62a5\u6587\u4e3a\u7a7a\u6216\u8005\u683c\u5f0f\u4e0d\u6b63\u786e\u3002reqBO=" + reqBO);
            rspBO.getSys_head().setRet_status(FAIL);
            rspBO.getSys_head().getRet().getStruct().setRet_msg("\u4ea4\u6613\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f\uff1a\u94f6\u884c\u63a8\u9001\u7684\u62a5\u6587\u4e3a\u7a7a\u6216\u8005\u683c\u5f0f\u4e0d\u6b63\u786e\u3002");
            rspBO.getSys_head().getRet().getStruct().setRet_code("0001");
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u4ea4\u6613\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f\uff1a\u94f6\u884c\u63a8\u9001\u7684\u62a5\u6587\u4e3a\u7a7a\u6216\u8005\u683c\u5f0f\u4e0d\u6b63\u786e\u3002");
            return rspBO;
        }
        BusiAdvanceRecBankPushBodyReqBO body = reqBO.getBody();
        SubAcctInfoExt recSubAcct = this.subAccountService.getWithMainAccount(body.getZhuanrzizh());
        if (recSubAcct == null) {
            logger.error("\u4ea4\u6613\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f\uff1a\u6536\u6b3e\u5b50\u8d26\u53f7\u4e0d\u5b58\u5728\u6216\u8005\u4fe1\u606f\u6709\u8bef\u3002reqBO=" + reqBO);
            rspBO.getSys_head().setRet_status(FAIL);
            rspBO.getSys_head().getRet().getStruct().setRet_msg("\u4ea4\u6613\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f\uff1a\u6536\u6b3e\u5b50\u8d26\u53f7\u4e0d\u5b58\u5728\u6216\u8005\u4fe1\u606f\u6709\u8bef\u3002");
            rspBO.getSys_head().getRet().getStruct().setRet_code("0003");
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u4ea4\u6613\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f\uff1a\u6536\u6b3e\u5b50\u8d26\u53f7\u4e0d\u5b58\u5728\u6216\u8005\u4fe1\u606f\u6709\u8bef\u3002");
            return rspBO;
        }
        SubAcctInfoExt paySubAcct = this.subAccountService.getWithMainAccount(body.getZhuanczh());
        if (paySubAcct != null && paySubAcct.getMainAcctNo().equals(recSubAcct.getMainAcctNo())) {
            NormalTransaction normalTransaction = new NormalTransaction();
            try {
                normalTransaction.setSeq(id);
                normalTransaction.setJiaoylsh(body.getJiaoylsh());
                normalTransaction.setHexlsh(body.getHexlsh());
                normalTransaction.setTransferBankCode(body.getZhuanchh());
                normalTransaction.setTransferBankName(body.getZhuanchm());
                normalTransaction.setTransferAcct(body.getZhuanczh());
                normalTransaction.setTransferAcctName(body.getZhuanczhmc());
                normalTransaction.setRecBankCode(body.getZhuanrhh());
                normalTransaction.setRecBankName(body.getZhuanrhm());
                normalTransaction.setRecAcct(body.getZhuanrzhzh());
                normalTransaction.setRecAcctName(body.getZhuanrzhzhmc());
                normalTransaction.setRecSubAcct(body.getZhuanrzizh());
                normalTransaction.setRecSubAcctName(body.getZhuanrzizhmc());
                normalTransaction.setTranAmt(new BigDecimal(body.getJiaoyije()));
                normalTransaction.setSubAcctBal(new BigDecimal(body.getZizhye()));
                normalTransaction.setCreateDate(new Date());
                normalTransaction.setTranDate(new SimpleDateFormat("yyyyMMddHHmmss").parse(body.getJiaoyirq() + body.getJiaoyisj()));
                normalTransaction.setBusiType(body.getYewulx());
                normalTransaction.setRemark(body.getYinhbz());
                normalTransaction.setTransferRemark(body.getFuyan());
                normalTransaction.setTranRemark(body.getZhaiyao());
                normalTransaction.setDebitCreditFlag(body.getJiedaibz());
                normalTransaction.setPayOrgId(paySubAcct.getOrgId());
                normalTransaction.setRecOrgId(recSubAcct.getOrgId());
            }
            catch (Exception e) {
                logger.error("\u4ea4\u6613\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f\uff1a\u94f6\u884c\u63a8\u9001\u7684\u62a5\u6587\u6709\u8bef\u3002reqBO=" + reqBO, (Throwable)e);
                rspBO.getSys_head().setRet_status(FAIL);
                rspBO.getSys_head().getRet().getStruct().setRet_msg("\u4ea4\u6613\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f\uff1a\u94f6\u884c\u63a8\u9001\u7684\u62a5\u6587\u6709\u8bef\u3002" + e.getMessage());
                rspBO.getSys_head().getRet().getStruct().setRet_code("0011");
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u4ea4\u6613\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f\uff1a\u94f6\u884c\u63a8\u9001\u7684\u62a5\u6587\u6709\u8bef\u3002");
                return rspBO;
            }
            if (normalTransaction.getTranAmt() == null || normalTransaction.getTranAmt().compareTo(BigDecimal.ZERO) <= 0) {
                logger.error("\u4ea4\u6613\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f\uff1a\u4ea4\u6613\u91d1\u989d\u6709\u8bef\uff0c\u4ea4\u6613\u91d1\u989d\u5e94\u5927\u4e8e0\u3002reqBO=" + reqBO);
                rspBO.getSys_head().setRet_status(FAIL);
                rspBO.getSys_head().getRet().getStruct().setRet_msg("\u4ea4\u6613\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f\uff1a\u4ea4\u6613\u91d1\u989d\u6709\u8bef\uff0c\u4ea4\u6613\u91d1\u989d\u5e94\u5927\u4e8e0\u3002");
                rspBO.getSys_head().getRet().getStruct().setRet_code("0012");
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u4ea4\u6613\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f\uff1a\u4ea4\u6613\u91d1\u989d\u6709\u8bef\uff0c\u4ea4\u6613\u91d1\u989d\u5e94\u5927\u4e8e0\u3002");
                return rspBO;
            }
            this.normalTransactionMapper.insert(normalTransaction);
            final String coreSsn = normalTransaction.getHexlsh();
            final String busiSsn = normalTransaction.getJiaoylsh();
            if (StringUtils.hasText((String)coreSsn) && StringUtils.hasText((String)busiSsn)) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(4000L);
                        }
                        catch (InterruptedException e) {
                            logger.error("\u56de\u5199\u6d41\u6c34\u53f7\u65f6\uff0c\u7ebf\u7a0b\u7761\u7720\u5f02\u5e38\u3002\u6838\u5fc3\u6d41\u6c34\u53f7=" + coreSsn + "\uff0c\u4ea4\u6613\u6d41\u6c34\u53f7=" + busiSsn, (Throwable)e);
                            Thread.currentThread().interrupt();
                        }
                        int count = BusiAdvanceRecBankPushServiceImpl.this.transactionService.linkBusiAndCoreSsn(coreSsn, busiSsn);
                        if (count == 0) {
                            NormalTransaction record = new NormalTransaction();
                            record.setSeq(id);
                            record.setErrorRemark("\u5546\u57ce\u65e0\u4ea4\u6613\u6d41\u6c34\uff0c\u53ef\u80fd\u662f\u94f6\u884c\u591a\u505a\u4ea4\u6613");
                            BusiAdvanceRecBankPushServiceImpl.this.normalTransactionMapper.updateByPrimaryKeySelective(record);
                        }
                    }
                }).start();
            }
        } else {
            AdvanceReceive advanceReceive = new AdvanceReceive();
            try {
                advanceReceive.setSeq(id);
                advanceReceive.setJiaoylsh(body.getJiaoylsh());
                advanceReceive.setHexlsh(body.getHexlsh());
                advanceReceive.setTransferBankCode(body.getZhuanchh());
                advanceReceive.setTransferBankName(body.getZhuanchm());
                advanceReceive.setTransferAcct(body.getZhuanczh());
                advanceReceive.setTransferAcctName(body.getZhuanczhmc());
                advanceReceive.setRecBankCode(body.getZhuanrhh());
                advanceReceive.setRecBankName(body.getZhuanrhm());
                advanceReceive.setRecAcct(body.getZhuanrzhzh());
                advanceReceive.setRecAcctName(body.getZhuanrzhzhmc());
                advanceReceive.setRecSubAcct(body.getZhuanrzizh());
                advanceReceive.setRecSubAcctName(body.getZhuanrzizhmc());
                advanceReceive.setTranAmt(new BigDecimal(body.getJiaoyije()));
                advanceReceive.setWriteoffAmt(BigDecimal.ZERO);
                advanceReceive.setSubAcctBal(new BigDecimal(body.getZizhye()));
                advanceReceive.setPostDate(new SimpleDateFormat("yyyyMMddHHmmss").parse(body.getJiaoyirq() + body.getJiaoyisj()));
                advanceReceive.setCreateDate(new Date());
                advanceReceive.setBusiType(body.getYewulx());
                advanceReceive.setRemark(body.getYinhbz());
                advanceReceive.setTransferRemark(body.getFuyan());
                advanceReceive.setTranRemark(body.getZhaiyao());
                advanceReceive.setDebitCreditFlag(body.getJiedaibz());
            }
            catch (Exception e) {
                logger.error("\u4ea4\u6613\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f\uff1a\u94f6\u884c\u63a8\u9001\u7684\u62a5\u6587\u6709\u8bef\u3002reqBO=" + reqBO, (Throwable)e);
                rspBO.getSys_head().setRet_status(FAIL);
                rspBO.getSys_head().getRet().getStruct().setRet_msg("\u4ea4\u6613\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f\uff1a\u94f6\u884c\u63a8\u9001\u7684\u62a5\u6587\u6709\u8bef\u3002" + e.getMessage());
                rspBO.getSys_head().getRet().getStruct().setRet_code("0002");
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u4ea4\u6613\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f\uff1a\u94f6\u884c\u63a8\u9001\u7684\u62a5\u6587\u6709\u8bef\u3002");
                return rspBO;
            }
            if (advanceReceive.getTranAmt() == null || advanceReceive.getTranAmt().compareTo(BigDecimal.ZERO) <= 0) {
                logger.error("\u4ea4\u6613\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f\uff1a\u4ea4\u6613\u91d1\u989d\u6709\u8bef\uff0c\u4ea4\u6613\u91d1\u989d\u5e94\u5927\u4e8e0\u3002reqBO=" + reqBO);
                rspBO.getSys_head().setRet_status(FAIL);
                rspBO.getSys_head().getRet().getStruct().setRet_msg("\u4ea4\u6613\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f\uff1a\u4ea4\u6613\u91d1\u989d\u6709\u8bef\uff0c\u4ea4\u6613\u91d1\u989d\u5e94\u5927\u4e8e0\u3002");
                rspBO.getSys_head().getRet().getStruct().setRet_code("0004");
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u4ea4\u6613\u5931\u8d25\u3002\u4ea4\u6613\u91d1\u989d\u6709\u8bef\uff0c\u4ea4\u6613\u91d1\u989d\u5e94\u5927\u4e8e0\u3002");
                return rspBO;
            }
            try {
                advanceReceive.setRecOrgId(recSubAcct.getSuperiorOrgId());
                advanceReceive.setSource(recSubAcct.getSource());
                advanceReceive.setRecType(ReceiveType.BANK_RECEIVE.getCode());
                advanceReceive.setTranType(AdvanceReceiveTransactionType.BANK_PUSH_RECEIVE.getCode());
                advanceReceive.setStatus(AdvanceReceiveStatus.NO_CONFIRM.getCode());
                AccountantEngineReqBO accountantEngineReqBO = new AccountantEngineReqBO();
                if (SubAccountServiceType.PLATFORM_FEE.getCode().equals(recSubAcct.getServiceType())) {
                    accountantEngineReqBO.setBusinessType(BusinessType.PLAT_FEE_RECEIVE.getCode());
                    advanceReceive.setPayOrgId(null);
                } else if (SubAccountServiceType.SERVICE_FEE.getCode().equals(recSubAcct.getServiceType())) {
                    accountantEngineReqBO.setBusinessType(BusinessType.SERVICE_FEE_RECEIVE.getCode());
                    advanceReceive.setPayOrgId(null);
                } else if (SubAccountServiceType.DISTRIBUTE_BUSINESS.getCode().equals(recSubAcct.getServiceType())) {
                    accountantEngineReqBO.setBusinessType(BusinessType.XBJ_DISTRIBUTE_FEE_RECEIVE.getCode());
                    advanceReceive.setPayOrgId(null);
                } else {
                    accountantEngineReqBO.setBusinessType(BusinessType.BANK_PUSH_RECEIVE.getCode());
                    advanceReceive.setPayOrgId(recSubAcct.getOrgId());
                }
                this.advanceReceiveMapper.insert(advanceReceive);
                Long txnNo = null;
                if (!OrderSource.ELECTRIC_AREA.getCode().equals(recSubAcct.getSource())) {
                    accountantEngineReqBO.setClientAcctNo(advanceReceive.getRecSubAcct());
                    accountantEngineReqBO.setSource(recSubAcct.getSource());
                    accountantEngineReqBO.setOperUnit(recSubAcct.getSuperiorOrgId());
                    ArrayList<BigDecimal> amounts = new ArrayList<BigDecimal>();
                    amounts.add(advanceReceive.getTranAmt());
                    accountantEngineReqBO.setAmounts(amounts);
                    accountantEngineReqBO.setSsn(advanceReceive.getHexlsh());
                    accountantEngineReqBO.setBusiSsn(advanceReceive.getJiaoylsh());
                    accountantEngineReqBO.setRemark(advanceReceive.getTranRemark());
                    List<Long> txnnoList = this.accountantEngineService.executeAccountantEngine(accountantEngineReqBO);
                    txnNo = txnnoList.get(0);
                }
                if (txnNo != null) {
                    AdvanceReceive record = new AdvanceReceive();
                    record.setSeq(advanceReceive.getSeq());
                    record.setTxnNo(txnNo.toString());
                    this.advanceReceiveMapper.updateByPrimaryKeySelective(record);
                }
            }
            catch (Exception e) {
                logger.error("\u4ea4\u6613\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f\uff1a\u8d26\u52a1\u5904\u7406\u5f02\u5e38\u3002reqBO=" + reqBO, (Throwable)e);
                throw new PfscExtBusinessException("18000", "\u4ea4\u6613\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f\uff1a\u8d26\u52a1\u5904\u7406\u5f02\u5e38\u3002" + e.getMessage());
            }
        }
        return rspBO;
    }
}

