/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.JsonUtils;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.pfscext.api.busi.BusiGetInvoiceService;
import com.tydic.pfscext.api.busi.BusiUpdateNotificationExcepService;
import com.tydic.pfscext.api.busi.bo.BusiGetInvoiceServiceReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetInvoiceServiceRspBO;
import com.tydic.pfscext.api.busi.vo.BusiGetInvoiceResultVO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.PayInvoiceInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.enums.InvoiceMailStatus;
import com.tydic.pfscext.enums.InvoiceStatus;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.external.api.BusiGetInvoiceDataService;
import com.tydic.pfscext.external.api.bo.BusiGetInvoiceDataRspVO;
import com.tydic.pfscext.external.api.bo.BusiGetInvoiceDataServiceReqBO;
import com.tydic.pfscext.external.api.bo.PayInvoiceDetailVO;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import com.tydic.pfscext.service.atom.PayInvoiceService;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiGetInvoiceService.class)
public class BusiGetInvoiceServiceImpl
implements BusiGetInvoiceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusiGetInvoiceServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper notificationInfomapper;
    @Autowired
    private BusiGetInvoiceDataService apiGetInvoiceDataService;
    @Autowired
    private PayInvoiceService payInvoiceService;
    @Autowired
    private Environment prop;
    @Autowired
    private BusiUpdateNotificationExcepService busiUpdateNotificationExcepService;
    private boolean isBusy = false;

    public boolean isBusy() {
        return this.isBusy;
    }

    public BusiGetInvoiceServiceRspBO dealInvoice(BusiGetInvoiceServiceReqBO busiGetInvoiceServiceReqBO) {
        this.isBusy = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u83b7\u53d6\u53d1\u7968\u6570\u636e\u4e1a\u52a1\u670d\u52a1\u7684\u5b9e\u73b0\u5165\u53c2\uff1a" + busiGetInvoiceServiceReqBO.toString());
        }
        try {
            BusiGetInvoiceServiceRspBO busiGetInvoiceServiceRspBO = this.process();
            return busiGetInvoiceServiceRspBO;
        }
        finally {
            this.isBusy = false;
        }
    }

    private BusiGetInvoiceServiceRspBO process() {
        BusiGetInvoiceServiceRspBO rspBO = new BusiGetInvoiceServiceRspBO();
        BillNotificationInfo billNotificationInfo = new BillNotificationInfo();
        billNotificationInfo.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
        billNotificationInfo.setSource(OrderSource.ELECTRIC_MARKET.getCode());
        List<BillNotificationInfo> invoiceList = this.notificationInfomapper.selectList(billNotificationInfo);
        if (invoiceList.isEmpty()) {
            LOGGER.debug("\u65e0\u5f00\u7968\u72b6\u6001\u4e3a01(\u5df2\u63d0\u4ea4)\u7684\u8bb0\u5f55,\u7a0b\u5e8f\u9000\u51fa");
            return rspBO;
        }
        HashMap<String, String> dataMap = new HashMap<String, String>(16);
        for (BillNotificationInfo info : invoiceList) {
            String markId = info.getNotificationNo();
            String id = String.valueOf(info.getSupplierNo());
            dataMap.put(markId, id);
        }
        LOGGER.debug("\u9700\u8981\u8f6e\u8be2\u53d1\u7968\u8d44\u6599\u7684\u901a\u77e5\u5355,count=" + invoiceList.size() + ",dataMap=" + dataMap);
        BusiGetInvoiceDataServiceReqBO getInvoiceDataReqBO = new BusiGetInvoiceDataServiceReqBO();
        getInvoiceDataReqBO.setIdMap(dataMap);
        List invoiceDataList = this.apiGetInvoiceDataService.getInvoiceData(getInvoiceDataReqBO).getDataList();
        if (CollectionUtils.isEmpty((Collection)invoiceDataList)) {
            LOGGER.debug("\u6ca1\u6709\u67e5\u8be2\u5230\u5f00\u7968\u6570\u636e\uff0c\u7a0b\u5e8f\u9000\u51fa");
            return rspBO;
        }
        ArrayList list = new ArrayList();
        rspBO.setResultList(list);
        return this.dealData(invoiceDataList, rspBO);
    }

    private BusiGetInvoiceServiceRspBO dealData(List<BusiGetInvoiceDataRspVO> invoiceDataList, BusiGetInvoiceServiceRspBO rspBO) {
        for (BusiGetInvoiceDataRspVO invoiceData : invoiceDataList) {
            BusiGetInvoiceResultVO resultVO = new BusiGetInvoiceResultVO();
            String supplierCode = invoiceData.getSupplierCode();
            LOGGER.debug("\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\u7ed3\u679c:" + invoiceData.getNotificationNo() + "," + invoiceData.getResultCode() + "," + invoiceData.getResultMsg() + ",sup=" + invoiceData.getSupplierNo() + "(" + invoiceData.getSupplierCode() + ")");
            BeanUtils.copyProperties((Object)invoiceData, (Object)resultVO);
            rspBO.getResultList().add(resultVO);
            PayInvoiceInfo invoiceInfo = new PayInvoiceInfo();
            BeanUtils.copyProperties((Object)invoiceData, (Object)invoiceInfo);
            ArrayList payPurchaseOrderInfoList = new ArrayList();
            PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
            if (invoiceData.getResultCode().equals("0004") || invoiceData.getResultCode().equals("0005")) {
                ArrayList newIvDetails = new ArrayList();
                BusiGetInvoiceServiceImpl instance = new BusiGetInvoiceServiceImpl();
                if ("jd".equals(supplierCode)) {
                    HashMap<String, String> idMap = new HashMap<String, String>();
                    idMap.put("invoiceId", invoiceData.getInvoiceNo());
                    idMap.put("invoiceCode", invoiceData.getInvoiceCode());
                    idMap.put("hsn", supplierCode);
                    BusiGetInvoiceDataRspVO invoiceItemData = this.getInvoiceItemData(idMap);
                    invoiceInfo.setName(invoiceItemData.getName());
                    invoiceInfo.setTaxNo(invoiceItemData.getTaxNo());
                    invoiceInfo.setAddress(invoiceItemData.getAddress());
                    invoiceInfo.setPhone(invoiceItemData.getPhone() != null ? invoiceItemData.getPhone().replace("-", "") : invoiceItemData.getPhone());
                    invoiceInfo.setBankAcNo(invoiceItemData.getBankAcNo());
                    invoiceInfo.setBankName(invoiceItemData.getBankName());
                }
            }
            if (StringUtils.hasText((String)invoiceData.getInvoiceNo())) {
                invoiceInfo.setInvoiceStatus(InvoiceStatus.HAS_MAKE.getCode());
                invoiceInfo.setMailStatus(InvoiceMailStatus.NOT_SENT.getCode());
                try {
                    this.payInvoiceService.createInvoice(invoiceInfo);
                }
                catch (Exception e) {
                    LOGGER.error("\u5904\u7406\u63a5\u53e3\u53d1\u7968\u4fe1\u606f\u5931\u8d25!" + invoiceInfo, (Throwable)e);
                }
                continue;
            }
            this.busiUpdateNotificationExcepService.updateNotificationException(invoiceData.getResultMsg(), invoiceData.getNotificationNo());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public BusiGetInvoiceDataRspVO getInvoiceItemData(Map<String, String> idMap) {
        JSONObject rspJsonObject;
        HttpRetBean httpRetBean;
        String reqStr = JsonUtils.objectBeanToJsonString(idMap);
        LOGGER.info(reqStr);
        try {
            httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.prop.getProperty("ESB_QUERY_INVOICE_ITEM_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.toString().getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
        }
        catch (Exception e) {
            throw new BusinessException("", "\u83b7\u53d6jd\u53d1\u7968\u660e\u7ec6\u62a5\u9519\uff1a" + e.getMessage());
        }
        if (httpRetBean.getStatus() != 200) {
            throw new RuntimeException("\u83b7\u53d6jd\u53d1\u7968\u660e\u7ec6\u5931\u8d25");
        }
        LOGGER.info("\u83b7\u53d6jd\u53d1\u7968\u660e\u7ec6\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
        String returnString = httpRetBean.getStr();
        if (StringUtils.isEmpty((Object)returnString)) {
            LOGGER.info("\u83b7\u53d6jd\u53d1\u7968\u660e\u7ec6\u62a5\u6587\u4e3a\u7a7a\uff01");
            throw new RuntimeException("\u83b7\u53d6jd\u53d1\u7968\u660e\u7ec6\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        LOGGER.info("--\u63a5\u53e3\u8fd4\u56de\u7684\u62a5\u6587:" + returnString);
        try {
            rspJsonObject = JSONObject.parseObject((String)returnString);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6jd\u53d1\u7968\u660e\u7ec6\u8fd4\u56de\u62a5\u6587\u89e3\u6790\u5f02\u5e38:" + returnString, (Throwable)e);
            throw new BusinessException("", "\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519");
        }
        return this.resolveRsp(rspJsonObject);
    }

    private BusiGetInvoiceDataRspVO resolveRsp(JSONObject rspJsonObject) {
        BusiGetInvoiceDataRspVO rsp = new BusiGetInvoiceDataRspVO();
        JSONObject jsonObject = rspJsonObject.getJSONObject("result");
        rsp.setName(jsonObject.getString("title"));
        rsp.setTaxNo(jsonObject.getString("taxpayer"));
        rsp.setAddress(jsonObject.getString("address"));
        rsp.setPhone(jsonObject.getString("tel"));
        rsp.setBankName(jsonObject.getString("bank"));
        rsp.setBankAcNo(jsonObject.getString("account"));
        JSONArray jsonArray = jsonObject.getJSONArray("skuDetails");
        ArrayList<PayInvoiceDetailVO> skuDetails = new ArrayList<PayInvoiceDetailVO>();
        if (null != jsonArray) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                PayInvoiceDetailVO payInvoiceDetailVO = new PayInvoiceDetailVO();
                Object json = jsonArray.get(i);
                JSONObject sku = JSONObject.parseObject((String)json.toString());
                payInvoiceDetailVO.setSkuId(Long.valueOf(Long.parseLong(sku.getString("skuId"))));
                payInvoiceDetailVO.setItemName(sku.getString("skuName"));
                payInvoiceDetailVO.setSpecOrModel(sku.getString("specification"));
                payInvoiceDetailVO.setItemUnit(sku.getString("settleUnit"));
                payInvoiceDetailVO.setQuantity(sku.getBigDecimal("num"));
                payInvoiceDetailVO.setUntaxAmt(sku.getBigDecimal("amountUnTax"));
                payInvoiceDetailVO.setTaxAmt(sku.getBigDecimal("taxAmount"));
                payInvoiceDetailVO.setTaxRate(sku.getBigDecimal("taxRate"));
                payInvoiceDetailVO.setPriceIntax(sku.getBigDecimal("amount").divide(sku.getBigDecimal("num"), 2, 2));
                payInvoiceDetailVO.setPriceUntax(sku.getBigDecimal("amountUnTax").divide(sku.getBigDecimal("num"), 2, 2));
                payInvoiceDetailVO.setAmount(sku.getBigDecimal("amount"));
                skuDetails.add(payInvoiceDetailVO);
            }
        }
        rsp.setSkuDetails(skuDetails);
        LOGGER.info("jsonArray:" + jsonArray.toJSONString());
        return rsp;
    }
}

