/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.BusiReconcilitionService;
import com.tydic.pfscext.api.busi.bo.BusiReconcilitionRepBO;
import com.tydic.pfscext.api.busi.bo.BusiReconcilitionRspBO;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.ReconcilitionHisMapper;
import com.tydic.pfscext.dao.ReconcilitionHisTempMapper;
import com.tydic.pfscext.dao.po.ReconcilitionHis;
import com.tydic.pfscext.dao.po.ReconcilitionHisTemp;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.ReconciliationStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.bo.FscUnacceptedOrderInfoBO;
import com.tydic.pfscext.service.atom.OrderService;
import com.tydic.pfscext.service.busi.impl.QueryEntryInfoServiceImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiReconcilitionService.class)
public class BusiReconcilitionServiceImpl
implements BusiReconcilitionService {
    private static final Logger logger = LoggerFactory.getLogger(QueryEntryInfoServiceImpl.class);
    @Autowired
    private ReconcilitionHisMapper reconcilitionHisMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private OrderService orderService;
    @Autowired
    private ReconcilitionHisTempMapper reconcilitionHisTempMapper;

    public BusiReconcilitionRspBO registerReconcilition(BusiReconcilitionRepBO reqBO) {
        List<String> orderId;
        List<ReconcilitionHis> reconcilitionHis;
        if (logger.isDebugEnabled()) {
            logger.debug("\u7ed3\u7b97\u5bf9\u8d26\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a" + reqBO.getVersionNo());
        }
        BusiReconcilitionRspBO rspBO = new BusiReconcilitionRspBO();
        if (!StringUtils.hasText((String)reqBO.getVersionNo())) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u65e0\u5bf9\u8d26\u6570\u636e\u4e0d\u80fd\u5bf9\u8d26\uff0c\u8bf7\u5bfc\u5165\u5bf9\u8d26\u6570\u636e");
            return rspBO;
        }
        try {
            reconcilitionHis = this.reconcilitionHisMapper.selectByVersionNo(Integer.valueOf(reqBO.getVersionNo()));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(reconcilitionHis)) {
            List<String> orderId2;
            try {
                this.reconcilitionHisMapper.insertAccountAgreement(Integer.valueOf(reqBO.getVersionNo()), OrderStatus.AFTER_SALE.getCode(), ReconciliationStatus.AGREEMENT.getCode());
            }
            catch (Exception e) {
                logger.error("\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
                throw new PfscExtBusinessException("18000", "\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
            }
            try {
                orderId2 = this.payPurchaseOrderInfoMapper.selectByrstatus(Integer.valueOf(reqBO.getVersionNo()), ReconciliationStatus.AGREEMENT.getCode());
                if (!CollectionUtils.isEmpty(orderId2)) {
                    this.payPurchaseOrderInfoMapper.updateReconciliation(orderId2, ReconciliationStatus.AGREEMENT.getCode());
                }
            }
            catch (Exception e) {
                logger.error("\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
                throw new PfscExtBusinessException("18000", "\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u66f4\u65b0\u72b6\u6001\u5931\u8d25");
            }
            try {
                this.reconcilitionHisMapper.insertAccountDisagreement(Integer.valueOf(reqBO.getVersionNo()), OrderStatus.AFTER_SALE.getCode(), ReconciliationStatus.DISAGREEMENT.getCode());
            }
            catch (Exception e) {
                logger.error("\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
                throw new PfscExtBusinessException("18000", "\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
            }
            try {
                orderId2 = this.payPurchaseOrderInfoMapper.selectByrstatus(Integer.valueOf(reqBO.getVersionNo()), ReconciliationStatus.DISAGREEMENT.getCode());
                if (!CollectionUtils.isEmpty(orderId2)) {
                    this.payPurchaseOrderInfoMapper.updateReconciliation(orderId2, ReconciliationStatus.DISAGREEMENT.getCode());
                }
            }
            catch (Exception e) {
                logger.error("\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
                throw new PfscExtBusinessException("18000", "\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u66f4\u65b0\u72b6\u6001\u5931\u8d25");
            }
            List<ReconcilitionHis> nonacceptanceList = this.reconcilitionHisMapper.selectNonacceptance(Integer.valueOf(reqBO.getVersionNo()), ReconciliationStatus.NON_ACCEPTANCE.getCode());
            if (null != nonacceptanceList && !nonacceptanceList.isEmpty()) {
                LinkedList<String> extOrderIdList = new LinkedList<String>();
                for (ReconcilitionHis rechis : nonacceptanceList) {
                    extOrderIdList.add(rechis.getExtOrderId());
                }
                LinkedHashSet middleLinkedHashSet = new LinkedHashSet(extOrderIdList);
                ArrayList<String> afterHashSetList = new ArrayList<String>(middleLinkedHashSet);
                FscUnacceptedOrderInfoBO unacceptedOrder = this.orderService.getUnacceptedOrder(afterHashSetList);
                if (null == unacceptedOrder) {
                    logger.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\uff0c\u6839\u636e\u5916\u90e8\u8ba2\u5355ID\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u670d\u52a1\u5931\u8d25\uff01");
                    throw new PfscExtBusinessException("18000", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\uff0c\u6839\u636e\u5916\u90e8\u8ba2\u5355ID\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u670d\u52a1\u5931\u8d25\uff01");
                }
                logger.debug("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\uff0c\u6839\u636e\u5916\u90e8\u8ba2\u5355ID\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u670d\u52a1\u6210\u529f\uff01");
                HashMap<String, String> supplierNameMap = new HashMap<String, String>();
                Map orderIdMap = unacceptedOrder.getOrderIdMap();
                Map createTimeMap = unacceptedOrder.getCreateTimeMap();
                Map supplierIdMap = unacceptedOrder.getSupplierIdMap();
                Map companyIdMap = unacceptedOrder.getCompanyIdMap();
                List<ReconcilitionHisTemp> list = this.reconcilitionHisTempMapper.selectByVersionNo(Integer.valueOf(reqBO.getVersionNo()));
                for (ReconcilitionHisTemp tpo : list) {
                    supplierNameMap.put(tpo.getExtOrderId(), tpo.getSupplierName());
                }
                Iterator<Object> iterator = nonacceptanceList.iterator();
                while (iterator.hasNext()) {
                    ReconcilitionHis reconhis;
                    reconhis.setOrderId(orderIdMap.get((reconhis = (ReconcilitionHis)iterator.next()).getExtOrderId()) != null ? String.valueOf(orderIdMap.get(reconhis.getExtOrderId())) : null);
                    reconhis.setOrderDate((Date)createTimeMap.get(reconhis.getExtOrderId()));
                    reconhis.setSupplierNo((Integer)supplierIdMap.get(reconhis.getExtOrderId()));
                    reconhis.setSupplierName((String)supplierNameMap.get(reconhis.getExtOrderId()));
                    reconhis.setOperUnitNo(reqBO.getCompanyId());
                }
                try {
                    this.reconcilitionHisMapper.insertReconcilitionHisList(nonacceptanceList);
                }
                catch (Exception e) {
                    logger.error("\u5546\u57ce\u672a\u9a8c\u6536\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
                    throw new PfscExtBusinessException("18000", "\u5546\u57ce\u672a\u9a8c\u6536\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
                }
            }
            try {
                this.reconcilitionHisMapper.insertAftersale(Integer.valueOf(reqBO.getVersionNo()), OrderStatus.AFTER_SALE.getCode(), ReconciliationStatus.AFTER_SALE.getCode());
            }
            catch (Exception e) {
                logger.error("\u5546\u57ce\u552e\u540e\u4e2d\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
                throw new PfscExtBusinessException("18000", "\u5546\u57ce\u552e\u540e\u4e2d\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
            }
        }
        try {
            this.reconcilitionHisMapper.updateAccountAgreement(Integer.valueOf(reqBO.getVersionNo()), OrderStatus.AFTER_SALE.getCode(), ReconciliationStatus.AGREEMENT.getCode());
        }
        catch (Exception e) {
            logger.error("\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u66f4\u65b0\u5931\u8d25");
        }
        try {
            orderId = this.payPurchaseOrderInfoMapper.selectByrstatus(Integer.valueOf(reqBO.getVersionNo()), ReconciliationStatus.AGREEMENT.getCode());
            if (!CollectionUtils.isEmpty(orderId)) {
                this.payPurchaseOrderInfoMapper.updateReconciliation(orderId, ReconciliationStatus.AGREEMENT.getCode());
            }
        }
        catch (Exception e) {
            logger.error("\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u66f4\u65b0\u72b6\u6001\u5931\u8d25");
        }
        try {
            this.reconcilitionHisMapper.updateAccountDisagreement(Integer.valueOf(reqBO.getVersionNo()), OrderStatus.AFTER_SALE.getCode(), ReconciliationStatus.DISAGREEMENT.getCode());
        }
        catch (Exception e) {
            logger.error("\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u66f4\u65b0\u5931\u8d25");
        }
        try {
            orderId = this.payPurchaseOrderInfoMapper.selectByrstatus(Integer.valueOf(reqBO.getVersionNo()), ReconciliationStatus.DISAGREEMENT.getCode());
            if (!CollectionUtils.isEmpty(orderId)) {
                this.payPurchaseOrderInfoMapper.updateReconciliation(orderId, ReconciliationStatus.DISAGREEMENT.getCode());
            }
        }
        catch (Exception e) {
            logger.error("\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u66f4\u65b0\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setBatchNo(Integer.valueOf(reqBO.getVersionNo()));
        return rspBO;
    }
}

