/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.atom;

import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.InvoiceReturnDetailMapper;
import com.tydic.pfscext.dao.InvoiceReturnMapper;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.InvoiceReturn;
import com.tydic.pfscext.dao.po.InvoiceReturnDetail;
import com.tydic.pfscext.dao.po.SaleInvoiceInfo;
import com.tydic.pfscext.dao.vo.BillApplyInfoVO;
import com.tydic.pfscext.dao.vo.InvoiceReturnDetailVO;
import com.tydic.pfscext.dao.vo.InvoiceReturnVO;
import com.tydic.pfscext.dao.vo.SaleInvoiceInfoVO;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.InvoiceClasses;
import com.tydic.pfscext.enums.InvoiceReturnStatus;
import com.tydic.pfscext.enums.SaleInvoiceInfoInvoiceStatus;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class InvoiceReturnAtomService {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceReturnAtomService.class);
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;

    public void updateStatus(InvoiceReturnVO vo) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u66f4\u65b0\u72b6\u6001\u5165\u53c2\uff1a" + vo);
        }
        String billNo = vo.getBillNo();
        String status = vo.getStatus();
        if (InvoiceReturnStatus.RETURNED.getCode().equals(status)) {
            boolean ok = true;
            InvoiceReturnDetailVO detailVO = new InvoiceReturnDetailVO();
            detailVO.setBillNo(billNo);
            List<InvoiceReturnDetail> details = this.invoiceReturnDetailMapper.selectList(detailVO);
            logger.debug("\u9000\u7968\u7533\u8bf7\u660e\u7ec6\u6570\u76ee\uff1a" + details.size());
            BillApplyInfo apply1 = this.billApplyInfoMapper.selectByPrimaryKey(details.get(0).getApplyNo1());
            if (InvoiceClasses.ELECTRONIC_INVOICE.getCode().equals(apply1.getInvoiceClasses())) {
                for (InvoiceReturnDetail detail : details) {
                    logger.debug("\u9000\u7968\u7533\u8bf7\u660e\u7ec6\uff1a" + detail);
                    if (StringUtils.hasText((String)detail.getInvoiceNo2())) continue;
                    ok = false;
                    break;
                }
            } else {
                ArrayList<String> invoiceNo1s = new ArrayList<String>();
                for (InvoiceReturnDetail detail : details) {
                    invoiceNo1s.add(detail.getInvoiceNo1());
                }
                SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
                saleInvoiceInfoVO.setInvoiceNoList(invoiceNo1s);
                List<SaleInvoiceInfo> invoice1s = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
                for (SaleInvoiceInfo invoice1 : invoice1s) {
                    if (SaleInvoiceInfoInvoiceStatus.CANCEL.getCode().equals(invoice1.getInvoiceStatus())) continue;
                    ok = false;
                    break;
                }
            }
            if (ok) {
                InvoiceReturn record = new InvoiceReturn();
                record.setBillNo(billNo);
                record.setStatus(status);
                record.setProcessUser(vo.getProcessUser());
                record.setProcessDate(new Date());
                this.invoiceReturnMapper.updateByPrimaryKeySelective(record);
            }
        } else if (InvoiceReturnStatus.BILLING.getCode().equals(status)) {
            InvoiceReturn record = new InvoiceReturn();
            record.setBillNo(billNo);
            record.setStatus(status);
            this.invoiceReturnMapper.updateByPrimaryKeySelective(record);
        } else if (InvoiceReturnStatus.BILLED.getCode().equals(status)) {
            InvoiceReturnDetailVO detailVO = new InvoiceReturnDetailVO();
            detailVO.setBillNo(billNo);
            List<InvoiceReturnDetail> details = this.invoiceReturnDetailMapper.selectList(detailVO);
            HashSet<String> applyNo3s = new HashSet<String>();
            for (InvoiceReturnDetail detail : details) {
                if (!StringUtils.hasText((String)detail.getApplyNo3())) continue;
                applyNo3s.add(detail.getApplyNo3());
            }
            if (!applyNo3s.isEmpty()) {
                BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
                billApplyInfoVO.setApplyNoList(new ArrayList<String>(applyNo3s));
                List<BillApplyInfo> apply3s = this.billApplyInfoMapper.getList(billApplyInfoVO);
                boolean ok = true;
                for (BillApplyInfo apply3 : apply3s) {
                    if (BillStatus.SEND_BILL.getCode().equals(apply3.getBillStatus())) continue;
                    ok = false;
                    break;
                }
                if (ok) {
                    InvoiceReturn record = new InvoiceReturn();
                    record.setBillNo(billNo);
                    record.setStatus(status);
                    this.invoiceReturnMapper.updateByPrimaryKeySelective(record);
                }
            }
        }
    }
}

