/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiAfterSaleCompleteService;
import com.tydic.pfscext.api.busi.bo.BusiAfterSaleCompleteReqBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.AfterSaleDetailMapper;
import com.tydic.pfscext.dao.AfterSaleMapper;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayInvoiceInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.AfterSale;
import com.tydic.pfscext.dao.po.AfterSaleDetail;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.AfterSaleDetailVO;
import com.tydic.pfscext.dao.vo.BillNotificationInfoVO;
import com.tydic.pfscext.dao.vo.PayItemInfoVO;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.enums.AfterSaleMessageType;
import com.tydic.pfscext.enums.AfterSaleProcessStatus;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiAfterSaleCompleteService"})
public class BusiAfterSaleCompleteServiceImpl
implements BusiAfterSaleCompleteService {
    private static final Logger log = LoggerFactory.getLogger(BusiAfterSaleCompleteServiceImpl.class);
    @Autowired
    private AfterSaleMapper afterSaleMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private AfterSaleDetailMapper afterSaleDetailMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;

    @PostMapping(value={"process"})
    public PfscExtRspBaseBO process(@RequestBody BusiAfterSaleCompleteReqBO reqBO) {
        this.validParam(reqBO);
        Long inspectionId = reqBO.getInspectionId();
        Long purchaseOrderId = reqBO.getPurchaseOrderId();
        Long saleOrderId = reqBO.getSaleOrderId();
        PayPurchaseOrderInfo purchaseOrder = this.payPurchaseOrderInfoMapper.getModelByPrimaryKey(purchaseOrderId, inspectionId);
        if (purchaseOrder == null) {
            log.error("\u901a\u8fc7\u9a8c\u6536\u5355\u53f7[" + inspectionId + "]\u548c\u91c7\u8d2d\u8ba2\u5355ID[" + purchaseOrderId + "]\u5728\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u627e\u4e0d\u5230\u91c7\u8d2d\u8ba2\u5355\u3002\u5165\u53c2=" + reqBO);
            throw new PfscExtBusinessException("0001", "\u901a\u8fc7\u9a8c\u6536\u5355\u53f7[" + inspectionId + "]\u548c\u91c7\u8d2d\u8ba2\u5355ID[" + purchaseOrderId + "]\u5728\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u627e\u4e0d\u5230\u91c7\u8d2d\u8ba2\u5355");
        }
        SaleOrderInfo saleOrder = this.saleOrderInfoMapper.getModelByPrimaryKey(saleOrderId, inspectionId);
        if (saleOrder == null) {
            log.error("\u901a\u8fc7\u9a8c\u6536\u5355\u53f7[" + inspectionId + "]\u548c\u9500\u552e\u8ba2\u5355ID[" + saleOrderId + "]\u5728\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u627e\u4e0d\u5230\u9500\u552e\u8ba2\u5355\u3002\u5165\u53c2=" + reqBO);
            throw new PfscExtBusinessException("0001", "\u901a\u8fc7\u9a8c\u6536\u5355\u53f7[" + inspectionId + "]\u548c\u9500\u552e\u8ba2\u5355ID[" + saleOrderId + "]\u5728\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u627e\u4e0d\u5230\u9500\u552e\u8ba2\u5355");
        }
        AfterSale afterSale = new AfterSale();
        afterSale.setOrderId(reqBO.getOrderId());
        afterSale.setSaleOrderId(reqBO.getSaleOrderId());
        afterSale.setInspectionId(reqBO.getInspectionId());
        afterSale.setPurchaseOrderId(reqBO.getPurchaseOrderId());
        afterSale = this.afterSaleMapper.select(afterSale);
        if (afterSale == null) {
            throw new PfscExtBusinessException("18001", "\u672a\u67e5\u8be2\u5230\u552e\u540e\u5355\u8bb0\u5f55");
        }
        AfterSaleDetailVO afterSaleDetailVO = new AfterSaleDetailVO();
        afterSaleDetailVO.setRefSeq(afterSale.getSeq());
        List<AfterSaleDetail> afterSaleDetails = this.afterSaleDetailMapper.selectList(afterSaleDetailVO);
        List<PayItemInfo> payItems = null;
        List<SaleItemInfo> saleItems = null;
        if (!afterSaleDetails.isEmpty()) {
            PayItemInfoVO payItemInfoVO = new PayItemInfoVO();
            payItemInfoVO.setInspectionId(inspectionId);
            payItems = this.payItemInfoMapper.selectBy(payItemInfoVO);
            SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
            saleItemInfoVO.setInspectionId(inspectionId);
            saleItems = this.saleItemInfoMapper.getList(saleItemInfoVO);
        }
        AfterSale updateParamBO = new AfterSale();
        updateParamBO.setMessageType(AfterSaleMessageType.FINISH.getCode());
        updateParamBO.setProcessStatus(AfterSaleProcessStatus.PROCESSED.getCode());
        updateParamBO.setSeq(afterSale.getSeq());
        this.afterSaleMapper.updateByPrimaryKeySelective(updateParamBO);
        for (AfterSaleDetail afterSaleDetail : afterSaleDetails) {
            BigDecimal newAmount;
            BigDecimal oldAmount;
            Long purchaseItemNo = afterSaleDetail.getPurchaseItemNo();
            BigDecimal purchaseQuantity = afterSaleDetail.getPurchaseQuantity();
            BigDecimal purchaseAmount = afterSaleDetail.getPurchaseAmount();
            Long saleItemNo = afterSaleDetail.getSaleItemNo();
            BigDecimal saleQuantity = afterSaleDetail.getSaleQuantity();
            BigDecimal saleAmount = afterSaleDetail.getSaleAmount();
            for (PayItemInfo payItem : payItems) {
                if (!purchaseItemNo.equals(payItem.getItemNo())) continue;
                oldAmount = payItem.getAmount();
                newAmount = oldAmount.add(purchaseAmount);
                if (newAmount.compareTo(BigDecimal.ZERO) == 0) {
                    this.payItemInfoMapper.deleteByPrimaryKey(payItem.getSeq());
                    continue;
                }
                BigDecimal newTaxAmt = payItem.getTaxAmt().multiply(newAmount).divide(oldAmount, 4);
                PayItemInfo record = new PayItemInfo();
                record.setSeq(payItem.getSeq());
                record.setQuantity(payItem.getQuantity().add(purchaseQuantity));
                record.setAmount(newAmount);
                record.setTaxAmt(newTaxAmt);
                record.setUntaxAmt(newAmount.subtract(newTaxAmt));
                this.payItemInfoMapper.updateByPrimaryKeySelective(record);
            }
            for (SaleItemInfo saleItem : saleItems) {
                if (!saleItemNo.equals(saleItem.getItemNo())) continue;
                oldAmount = saleItem.getAmount();
                newAmount = oldAmount.add(saleAmount);
                if (newAmount.compareTo(BigDecimal.ZERO) == 0) {
                    this.saleItemInfoMapper.deleteByPrimaryKey(saleItem.getSeq());
                    continue;
                }
                SaleItemInfo record = new SaleItemInfo();
                record.setSeq(saleItem.getSeq());
                record.setQuantity(saleItem.getQuantity().add(saleQuantity));
                record.setAmount(newAmount);
                this.saleItemInfoMapper.updateByPrimaryKeySelective(record);
            }
        }
        BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(purchaseOrder.getNotificationNo());
        String notificationInvoiceStatus = null;
        if (null != billNotificationInfo) {
            notificationInvoiceStatus = billNotificationInfo.getInvoiceStatus();
        }
        PayPurchaseOrderInfo updatePurchaseOrder = new PayPurchaseOrderInfo();
        updatePurchaseOrder.setInspectionId(reqBO.getInspectionId());
        if (NotificationInvoiceStatus.SUBMITED.getCode().equals(notificationInvoiceStatus) || NotificationInvoiceStatus.HAS_MAKE.getCode().equals(notificationInvoiceStatus) || NotificationInvoiceStatus.HANGING.getCode().equals(notificationInvoiceStatus)) {
            this.payInvoiceInfoMapper.deleteByNotificationNos(Arrays.asList(purchaseOrder.getNotificationNo()));
            BillNotificationInfoVO billNotificationInfoVO = new BillNotificationInfoVO();
            billNotificationInfoVO.setSumPayItemAmountFlag("1");
            billNotificationInfoVO.setNotificationNo(purchaseOrder.getNotificationNo());
            billNotificationInfoVO.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
            billNotificationInfoVO.setInvoiceResult("");
            this.billNotificationInfoMapper.update(billNotificationInfoVO);
        }
        if (null == billNotificationInfo) {
            updatePurchaseOrder.setOrderStatus(OrderStatus.NO_APPLY.getCode());
        }
        if (StringUtils.hasText((String)afterSale.getRemark())) {
            updatePurchaseOrder.setRemark(afterSale.getRemark().length() > 200 ? afterSale.getRemark().substring(0, 200) : afterSale.getRemark());
        }
        if (!afterSaleDetails.isEmpty()) {
            updatePurchaseOrder.setOrderAmt(afterSale.getPurchaseOrderAmt2());
        }
        if (StringUtils.hasText((String)updatePurchaseOrder.getOrderStatus()) || StringUtils.hasText((String)updatePurchaseOrder.getRemark()) || null != updatePurchaseOrder.getOrderAmt()) {
            this.payPurchaseOrderInfoMapper.updateByPrimaryKeySelective(updatePurchaseOrder);
        }
        saleOrder = new SaleOrderInfo();
        saleOrder.setInspectionId(inspectionId);
        saleOrder.setOrderStatus(OrderStatus.NO_APPLY.getCode());
        if (StringUtils.hasText((String)afterSale.getRemark())) {
            saleOrder.setRemark(afterSale.getRemark().length() > 200 ? afterSale.getRemark().substring(0, 200) : afterSale.getRemark());
        }
        if (!afterSaleDetails.isEmpty()) {
            saleOrder.setOrderAmt(afterSale.getSaleOrderAmt2());
        }
        this.saleOrderInfoMapper.updateByPrimaryKeySelective(saleOrder);
        return new PfscExtRspBaseBO();
    }

    private void validParam(BusiAfterSaleCompleteReqBO reqBO) {
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long inspectionId = reqBO.getInspectionId();
        Long purchaseOrderId = reqBO.getPurchaseOrderId();
        Long saleOrderId = reqBO.getSaleOrderId();
        if (inspectionId == null) {
            throw new PfscExtBusinessException("0001", "\u9a8c\u6536\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (purchaseOrderId == null) {
            throw new PfscExtBusinessException("0001", "\u91c7\u8d2d\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (saleOrderId == null) {
            throw new PfscExtBusinessException("0001", "\u9500\u552e\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

