/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiApplyPayService;
import com.tydic.pfscext.api.busi.bo.ApplyPayBO;
import com.tydic.pfscext.api.busi.bo.BusiApplyPayServiceReqBO;
import com.tydic.pfscext.api.busi.bo.BusiApplyPayServiceRspBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.vo.PayableDetailVO;
import com.tydic.pfscext.enums.BillType;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.PayResultStatus;
import com.tydic.pfscext.enums.PayablePayType;
import com.tydic.pfscext.enums.WFBillType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.BillSNService;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.FscWfStartAtomService;
import com.tydic.pfscext.service.atom.PayableService;
import com.tydic.pfscext.service.atom.bo.FscWfStartAtomReqBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiApplyPayService"})
public class BusiApplyPayServiceImpl
implements BusiApplyPayService {
    private static final Logger logger = LoggerFactory.getLogger(BusiApplyPayServiceImpl.class);
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private PayableService payableService;
    @Autowired
    private FscWfStartAtomService fscWfStartAtomService;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private EnumsService enumsService;

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"applyPay"})
    public BusiApplyPayServiceRspBO applyPay(@RequestBody BusiApplyPayServiceReqBO reqBO) {
        void var11_21;
        if (logger.isDebugEnabled()) {
            logger.debug("\u4ed8\u6b3e\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (!StringUtils.hasText((String)reqBO.getSupplierName())) {
            throw new PfscExtBusinessException("18000", "\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getReceiptAcctNo())) {
            throw new PfscExtBusinessException("18000", "\u6536\u6b3e\u65b9\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getRecAcctName())) {
            throw new PfscExtBusinessException("18000", "\u6536\u6b3e\u65b9\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getOpenBankName())) {
            throw new PfscExtBusinessException("18000", "\u5f00\u6237\u884c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getPayMathod())) {
            throw new PfscExtBusinessException("18000", "\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSupplierId() == null) {
            throw new PfscExtBusinessException("18000", "\u4f9b\u5e94\u5546Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getApplyPayBOList())) {
            throw new PfscExtBusinessException("18000", "\u6765\u6e90\u3001\u5f00\u7968\u7f16\u53f7\u3001\u4ed8\u6b3e\u91d1\u989d\u548c\u5f00\u7968\u901a\u77e5\u7f16\u53f7\u7ec4\u6210\u7684\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getContactNo())) {
            throw new PfscExtBusinessException("18000", "\u5408\u540c\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<String> payableNoList = new ArrayList<String>();
        ArrayList<String> sourceList = new ArrayList<String>();
        List applyPayBOList = reqBO.getApplyPayBOList();
        for (Object applyPayBO : applyPayBOList) {
            if (!StringUtils.hasText((String)applyPayBO.getPayableNo())) {
                throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (applyPayBO.getPayAmt() == null) {
                throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)applyPayBO.getSource())) {
                throw new PfscExtBusinessException("18000", "\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
            }
            payableNoList.add(applyPayBO.getPayableNo());
            sourceList.add(applyPayBO.getSource());
        }
        String firstSource = (String)sourceList.get(0);
        for (String source : sourceList) {
            if (firstSource.compareTo(source) == 0) continue;
            throw new PfscExtBusinessException("18000", "\u4e0d\u540c\u6765\u6e90\u4e0d\u80fd\u4e00\u8d77\u6c47\u603b");
        }
        PayableDetailVO payableDetailVO = new PayableDetailVO();
        payableDetailVO.setPayableNos(payableNoList);
        List<PayableDetailPO> payableDetailPOs = this.payableDetailMapper.selectList(payableDetailVO);
        Long branchCompany = null;
        Long supplierId = null;
        for (PayableDetailPO payableDetailPO : payableDetailPOs) {
            if (supplierId == null) {
                supplierId = payableDetailPO.getSupplierId();
            } else if (!supplierId.equals(payableDetailPO.getSupplierId())) {
                throw new PfscExtBusinessException("18000", "\u4e0d\u540c\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e00\u8d77\u4ed8\u6b3e");
            }
            if (!reqBO.getCompanyId().equals(payableDetailPO.getOperatorId())) {
                throw new PfscExtBusinessException("18000", "\u4e0d\u80fd\u529e\u7406\u5176\u4ed6\u516c\u53f8\u7684\u4e1a\u52a1");
            }
            if (branchCompany != null) continue;
            branchCompany = payableDetailPO.getBranchCompany();
        }
        if (OrderSource.ELECTRIC_AREA.getCode().equals(firstSource) || OrderSource.CONSULT_PRICE.getCode().equals(firstSource) || OrderSource.COAL_AREA.getCode().equals(firstSource)) {
            HashSet<Long> orders = new HashSet<Long>();
            for (PayableDetailPO payableDetailPO : payableDetailPOs) {
                orders.add(payableDetailPO.getOrderId());
            }
            if (orders.size() > 1) {
                if (OrderSource.ELECTRIC_AREA.getCode().equals(firstSource) || OrderSource.COAL_AREA.getCode().equals(firstSource)) {
                    Object var11_13 = null;
                    for (PayableDetailPO payableDetailPO : payableDetailPOs) {
                        void var11_14;
                        if (!StringUtils.hasText((String)payableDetailPO.getPlaAgreementCode())) {
                            throw new PfscExtBusinessException("18000", "\u8ba2\u5355\uff08\u91c7\u8d2d\u8ba2\u5355\u7f16\u53f7\uff1a" + payableDetailPO.getPurchaseOrderCode() + "\uff09\u7684\u5e94\u4ed8\u8bb0\u5f55\u4e0a\u6ca1\u6709\u8bb0\u5f55\u91c7\u8d2d\u5408\u540c\u7f16\u53f7\uff0c\u4e0d\u80fd\u4ed8\u6b3e");
                        }
                        if (var11_14 == null) {
                            String string = payableDetailPO.getPlaAgreementCode();
                            continue;
                        }
                        if (var11_14.equals(payableDetailPO.getPlaAgreementCode())) continue;
                        throw new PfscExtBusinessException("18000", "\u91c7\u8d2d\u5408\u540c\u7f16\u53f7\u4e0d\u540c\u7684\u8ba2\u5355\u4e0d\u80fd\u5408\u5e76\u4ed8\u6b3e");
                    }
                } else {
                    BigDecimal bigDecimal = this.enumsService.queryUnionPayAmountLimit();
                }
                ArrayList<Long> arrayList = new ArrayList<Long>(orders);
                payableDetailVO = new PayableDetailVO();
                payableDetailVO.setOrderIdList(arrayList);
                payableDetailPOs = this.payableDetailMapper.selectList(payableDetailVO);
                for (PayableDetailPO payableDetailPO : payableDetailPOs) {
                    String payType = payableDetailPO.getPayType();
                    if (!PayablePayType.PREPAY.getCode().equals(payType) && !PayablePayType.WARRANTY.getCode().equals(payType)) continue;
                    throw new PfscExtBusinessException("18000", "\u8ba2\u5355\uff08\u91c7\u8d2d\u8ba2\u5355\u7f16\u53f7\uff1a" + payableDetailPO.getPurchaseOrderCode() + "\uff09\u6709" + PayablePayType.getInstance(payType).getDescr() + "\uff0c\u4e0d\u80fd\u548c\u5176\u4ed6\u8ba2\u5355\u5408\u5e76\u4ed8\u6b3e");
                }
            }
        }
        Long payno = this.billSNService.getSn(BillType.PAY_APPLICATION);
        logger.info("\u6d41\u6c34\u53f7\uff1a" + payno);
        BigDecimal bigDecimal = new BigDecimal(0);
        for (ApplyPayBO applyPayBO : applyPayBOList) {
            BigDecimal bigDecimal2 = applyPayBO.getPayAmt().add((BigDecimal)var11_21);
            ApplyDetail applyDetail = new ApplyDetail();
            applyDetail.setApplyNo(payno);
            applyDetail.setPayableNo(applyPayBO.getPayableNo());
            applyDetail.setOperatorId(reqBO.getUserId());
            applyDetail.setSource(applyPayBO.getSource());
            applyDetail.setSupplierId(reqBO.getSupplierId());
            applyDetail.setStatus(PayResultStatus.APPLYING.getCode());
            applyDetail.setAmt(applyPayBO.getPayAmt());
            applyDetail.setCompanyId(reqBO.getCompanyId());
            this.applyDetailMapper.insert(applyDetail);
            this.payableService.applyForNew(applyPayBO.getPayableNo(), applyPayBO.getPayAmt());
        }
        Date date = new Date();
        ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)applyPayInfoPO);
        applyPayInfoPO.setPayAmt((BigDecimal)var11_21);
        applyPayInfoPO.setPayno(payno);
        applyPayInfoPO.setSource(firstSource);
        applyPayInfoPO.setApplyDate(date);
        applyPayInfoPO.setOperatorId(reqBO.getUserId());
        applyPayInfoPO.setPayStatus(PayResultStatus.APPLYING.getCode());
        applyPayInfoPO.setBranchCompany(branchCompany);
        this.applyPayInfoMapper.insert(applyPayInfoPO);
        FscWfStartAtomReqBO fscWfStartAtomReqBO = new FscWfStartAtomReqBO();
        fscWfStartAtomReqBO.setUserId(reqBO.getUserId());
        fscWfStartAtomReqBO.setBillNo(String.valueOf(payno));
        fscWfStartAtomReqBO.setBillType(WFBillType.PAY_APPLICATION);
        fscWfStartAtomReqBO.setFinishEvtServiceId("applyPayWorkFlowFinshEventImpl");
        this.fscWfStartAtomService.dealStartApproval(fscWfStartAtomReqBO);
        BusiApplyPayServiceRspBO rspBO = new BusiApplyPayServiceRspBO();
        return rspBO;
    }
}

