/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.ReconcilitionHisItemService;
import com.tydic.pfscext.api.busi.bo.ReconcilitionHisListRepBO;
import com.tydic.pfscext.api.busi.bo.ReconcilitionHisListRspBO;
import com.tydic.pfscext.api.busi.vo.ReconcilitionHisListVO;
import com.tydic.pfscext.dao.ReconcilitionHisMapper;
import com.tydic.pfscext.dao.ReconcilitionHisTempMapper;
import com.tydic.pfscext.dao.po.ReconcilitionHis;
import com.tydic.pfscext.dao.po.ReconcilitionHisTemp;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.DictionaryAtomService;
import com.tydic.pfscext.service.atom.bo.DictionaryAtomReqBo;
import com.tydic.pfscext.service.atom.bo.DictionaryAtomRspBo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.ReconcilitionHisItemService"})
public class ReconcilitionHisItemServiceImpl
implements ReconcilitionHisItemService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReconcilitionHisItemServiceImpl.class);
    private static final String IS_TEMP_YES = "1";
    private static final String IS_TEMP_NO = "0";
    private DictionaryAtomService dicDictionaryService;
    private ReconcilitionHisTempMapper reconcilitionHisTempMapper;
    private ReconcilitionHisMapper reconcilitionHisMapper;

    @Autowired
    public ReconcilitionHisItemServiceImpl(DictionaryAtomService dicDictionaryService, ReconcilitionHisTempMapper reconcilitionHisTempMapper, ReconcilitionHisMapper reconcilitionHisMapper) {
        this.dicDictionaryService = dicDictionaryService;
        this.reconcilitionHisTempMapper = reconcilitionHisTempMapper;
        this.reconcilitionHisMapper = reconcilitionHisMapper;
    }

    @PostMapping(value={"queryReconcilitionHisList"})
    public ReconcilitionHisListRspBO queryReconcilitionHisList(@RequestBody ReconcilitionHisListRepBO reqBo) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a\u7248\u672c\u53f7\uff1a" + reqBo.getVersionNo() + "\u662f\u5426\u4e34\u65f6\u8868\uff1a" + reqBo.getIsTempTable());
        }
        ReconcilitionHisListRspBO rspBo = new ReconcilitionHisListRspBO();
        if (!StringUtils.hasText((String)reqBo.getVersionNo())) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        if (!StringUtils.hasText((String)reqBo.getIsTempTable())) {
            throw new PfscExtBusinessException("18000", "\u662f\u5426\u4e34\u65f6\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (IS_TEMP_YES.equals(reqBo.getIsTempTable())) {
            List<ReconcilitionHisTemp> reconcilitionHisTemp;
            try {
                reconcilitionHisTemp = this.reconcilitionHisTempMapper.selectByVersionNo(Integer.valueOf(reqBo.getVersionNo()));
            }
            catch (Exception e) {
                LOGGER.error("\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBo.getVersionNo(), (Throwable)e);
                throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
            }
            if (CollectionUtils.isEmpty(reconcilitionHisTemp)) {
                LOGGER.error("\u627e\u4e0d\u5230\u7248\u672c\u53f7\u5bf9\u5e94\u7684\u7ed3\u7b97\u5bf9\u8d26\u8bb0\u5f55\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBo.getVersionNo());
                rspBo.setRespCode("18000");
                rspBo.setRespDesc("\u627e\u4e0d\u5230\u7248\u672c\u53f7\u5bf9\u5e94\u7684\u7ed3\u7b97\u5bf9\u8d26\u8bb0\u5f55");
                return rspBo;
            }
            ArrayList<ReconcilitionHisListVO> reconcilitionHisListVoList = new ArrayList<ReconcilitionHisListVO>();
            for (ReconcilitionHisTemp reconcilitionHisTemps : reconcilitionHisTemp) {
                ReconcilitionHisListVO reconcilitionHisListVO = new ReconcilitionHisListVO();
                BeanUtils.copyProperties((Object)reconcilitionHisTemps, (Object)reconcilitionHisListVO);
                reconcilitionHisListVoList.add(reconcilitionHisListVO);
            }
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            rspBo.setRows(reconcilitionHisListVoList);
            return rspBo;
        }
        if (IS_TEMP_NO.equals(reqBo.getIsTempTable())) {
            List<ReconcilitionHis> reconcilitionHis;
            try {
                reconcilitionHis = this.reconcilitionHisMapper.selectByVersionNo(Integer.valueOf(reqBo.getVersionNo()));
            }
            catch (Exception e) {
                LOGGER.error("\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBo.getVersionNo(), (Throwable)e);
                throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
            }
            if (CollectionUtils.isEmpty(reconcilitionHis)) {
                LOGGER.error("\u627e\u4e0d\u5230\u7248\u672c\u53f7\u5bf9\u5e94\u7684\u7ed3\u7b97\u5bf9\u8d26\u8bb0\u5f55\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBo.getVersionNo());
                rspBo.setRespCode("18000");
                rspBo.setRespDesc("\u627e\u4e0d\u5230\u7248\u672c\u53f7\u5bf9\u5e94\u7684\u7ed3\u7b97\u5bf9\u8d26\u8bb0\u5f55");
                return rspBo;
            }
            ArrayList<ReconcilitionHisListVO> reconcilitionHisListVoList = new ArrayList<ReconcilitionHisListVO>();
            SimpleDateFormat dtf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (ReconcilitionHis reconcilitionHiss : reconcilitionHis) {
                ReconcilitionHisListVO reconcilitionHisListVO = new ReconcilitionHisListVO();
                BeanUtils.copyProperties((Object)reconcilitionHiss, (Object)reconcilitionHisListVO);
                reconcilitionHisListVO.setReconciliationStatusName(this.getReconcilStatusMap().get(reconcilitionHiss.getReconciliationStatus() + ""));
                if (null != reconcilitionHiss.getOrderId()) {
                    reconcilitionHisListVO.setOrderId(reconcilitionHiss.getOrderId().toString());
                } else {
                    reconcilitionHisListVO.setOrderId("");
                }
                if (null != reconcilitionHiss.getOrderDate()) {
                    reconcilitionHisListVO.setOrderDate(dtf.format(reconcilitionHiss.getOrderDate()));
                }
                if (null != reconcilitionHiss.getReconciliationDate()) {
                    reconcilitionHisListVO.setReconciliationDate(dtf.format(reconcilitionHiss.getReconciliationDate()));
                }
                reconcilitionHisListVoList.add(reconcilitionHisListVO);
            }
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            rspBo.setRows(reconcilitionHisListVoList);
            return rspBo;
        }
        LOGGER.error("\u662f\u5426\u4e34\u65f6\u8868\u4e3a\u7a7a\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBo.getVersionNo());
        rspBo.setRespCode("18000");
        rspBo.setRespDesc("\u662f\u5426\u4e34\u65f6\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        rspBo.setRows(new ArrayList());
        return rspBo;
    }

    private Map<String, String> getReconcilStatusMap() {
        Map<String, String> map = new HashMap<String, String>(2);
        DictionaryAtomReqBo dictionaryAtomReqBo = new DictionaryAtomReqBo();
        dictionaryAtomReqBo.setpCode("RECONCIL_STATUS");
        DictionaryAtomRspBo dictionaryAtomRspBo = this.dicDictionaryService.qryDic(dictionaryAtomReqBo);
        if (null != dictionaryAtomRspBo) {
            map = dictionaryAtomRspBo.getData();
        }
        return map;
    }
}

