/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.zm.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.bo.BusiQueryBillApplyInfoDetailRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQueryBillApplyInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiQueryBillApplyInfoRspBO;
import com.tydic.pfscext.api.zm.QueryZmBillApplyInfoService;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.SaleInvoiceInfo;
import com.tydic.pfscext.dao.vo.BillApplyInfoVO;
import com.tydic.pfscext.dao.vo.SaleInvoiceInfoVO;
import com.tydic.pfscext.enums.BaseEnums;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.bo.ProjectInfoBO;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.service.atom.UserInfoService;
import com.tydic.umc.ability.UmcMemDetailQueryAbilityService;
import com.tydic.umc.ability.bo.UmcMemDetailInfoAbilityBO;
import com.tydic.umc.ability.bo.UmcMemDetailQueryAbilityReqBO;
import com.tydic.umc.ability.bo.UmcMemDetailQueryAbilityRspBO;
import com.tydic.umc.ability.bo.UmcQryMemByManagementAbilityReqBO;
import com.tydic.umc.ability.bo.UmcQryMemByManagementAbilityRspBO;
import com.tydic.umc.ability.user.UmcQryMemByManagementAbilityService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.zm.QueryZmBillApplyInfoService"})
public class QueryZmBillApplyInfoServiceImpl
implements QueryZmBillApplyInfoService {
    private static final Logger logger = LoggerFactory.getLogger(QueryZmBillApplyInfoServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private UserInfoService userInfoService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="service")
    private UmcMemDetailQueryAbilityService umcMemDetailQueryAbilityService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="service")
    private UmcQryMemByManagementAbilityService umcQryMemByManagementAbilityService;

    @PostMapping(value={"query"})
    public BusiQueryBillApplyInfoRspBO query(@RequestBody BusiQueryBillApplyInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u670d\u52a1(\u7535\u5b50\u8d85\u5e02)(\u4e13\u4e1a\u516c\u53f8\u548c\u91c7\u8d2d\u5355\u4f4d\u5171\u7528)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getIsOperUnit())) {
            throw new PfscExtBusinessException("18000", "\u662f\u5426\u4e13\u4e1a\u516c\u53f8\u7528\u6237\u3010isOperUnit\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("0".equals(reqBO.getIsOperUnit()) && reqBO.getPurchaseProjectId() == null) {
            throw new PfscExtBusinessException("18000", "\u91c7\u8d2d\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)billApplyInfoVO);
        billApplyInfoVO.setReturnBillNoIsNull("1");
        UmcMemDetailQueryAbilityReqBO umcMemDetailQueryAbilityReqBO = new UmcMemDetailQueryAbilityReqBO();
        umcMemDetailQueryAbilityReqBO.setUserIdWeb(reqBO.getUserId());
        UmcMemDetailQueryAbilityRspBO umcMemDetailQueryAbilityRspBO = this.umcMemDetailQueryAbilityService.memDetailQuery(umcMemDetailQueryAbilityReqBO);
        if (null != umcMemDetailQueryAbilityRspBO) {
            try {
                if (null != reqBO.getUserNameLike() && StringUtils.hasText((String)reqBO.getUserNameLike())) {
                    ArrayList<Long> userIdList = new ArrayList<Long>();
                    UmcQryMemByManagementAbilityReqBO umcQryMemByManagementAbilityReqBO = new UmcQryMemByManagementAbilityReqBO();
                    umcQryMemByManagementAbilityReqBO.setMemName2(reqBO.getUserNameLike());
                    umcQryMemByManagementAbilityReqBO.setOrgIdWeb(umcMemDetailQueryAbilityRspBO.getUmcMemDetailInfoAbilityRspBO().getRootOrgId());
                    umcQryMemByManagementAbilityReqBO.setQueryType("02");
                    logger.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u670d\u52a1\u67e5\u8be2\u7528\u6237ID\u5217\u8868\u5165\u53c2\uff1a" + JSON.toJSONString((Object)umcQryMemByManagementAbilityReqBO));
                    UmcQryMemByManagementAbilityRspBO umcQryMemByManagementAbilityRspBO = this.umcQryMemByManagementAbilityService.qryMem(umcQryMemByManagementAbilityReqBO);
                    logger.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u670d\u52a1\u67e5\u8be2\u7528\u6237ID\u5217\u8868\u8fd4\u56de\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)umcQryMemByManagementAbilityRspBO));
                    if (null != umcQryMemByManagementAbilityRspBO && null != umcQryMemByManagementAbilityRspBO && !CollectionUtils.isEmpty((Collection)umcQryMemByManagementAbilityRspBO.getRows())) {
                        for (UmcMemDetailInfoAbilityBO umcMemDetailInfoAbilityBO : umcQryMemByManagementAbilityRspBO.getRows()) {
                            userIdList.add(umcMemDetailInfoAbilityBO.getUserId());
                        }
                    }
                    if (userIdList.isEmpty()) {
                        userIdList.add(-1L);
                    }
                    billApplyInfoVO.setUserIdList(userIdList);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                throw new PfscExtBusinessException("18000", "\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u3010UmcQryMemByManagementAbilityService\u3011\u63a5\u53e3\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            }
        }
        if ("1".equals(reqBO.getIsOperUnit())) {
            billApplyInfoVO.setOperUnitNo(reqBO.getCompanyId());
        }
        if (billApplyInfoVO.getApplyDateEnd() != null) {
            try {
                String applyDateEndString = new SimpleDateFormat("yyyy-MM-dd").format(billApplyInfoVO.getApplyDateEnd()) + " 23:59:59";
                billApplyInfoVO.setApplyDateEnd(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(applyDateEndString));
            }
            catch (ParseException e) {
                throw new PfscExtBusinessException("18000", "\u683c\u5f0f\u5316\u65e5\u671f\u51fa\u9519");
            }
        }
        if (null != reqBO.getInvoiceType() && reqBO.getInvoiceType().equals("2")) {
            billApplyInfoVO.setInvoiceType("0");
            reqBO.setInvoiceType("0");
        }
        billApplyInfoVO.setOrderBy("t.APPLY_NO DESC");
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<BillApplyInfo> billApplyInfoList = null;
        billApplyInfoList = StringUtils.isEmpty((Object)reqBO.getInvoiceNoStart()) && StringUtils.isEmpty((Object)reqBO.getInvoiceNoEnd()) && reqBO.getInvoiceDateStart() == null && reqBO.getInvoiceDateEnd() == null ? this.billApplyInfoMapper.getListPage(billApplyInfoVO, (Page<Map<String, Object>>)page) : this.billApplyInfoMapper.getListPageForQryBillApply(billApplyInfoVO, (Page<Map<String, Object>>)page);
        ArrayList<BusiQueryBillApplyInfoDetailRspBO> rows = new ArrayList<BusiQueryBillApplyInfoDetailRspBO>();
        for (BillApplyInfo billApplyInfo : billApplyInfoList) {
            BusiQueryBillApplyInfoDetailRspBO row = new BusiQueryBillApplyInfoDetailRspBO();
            BeanUtils.copyProperties((Object)billApplyInfo, (Object)row);
            try {
                ProjectInfoBO projectInfoBO = this.organizationInfoService.queryProjectName(billApplyInfo.getPurchaseProjectId());
                if (projectInfoBO != null) {
                    row.setPurchaseProjectName(projectInfoBO.getAccountName());
                }
            }
            catch (Exception e) {
                throw new PfscExtBusinessException("18000", "\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38");
            }
            SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
            saleInvoiceInfoVO.setApplyNo(billApplyInfo.getApplyNo());
            List<SaleInvoiceInfo> saleInvoiceInfoList = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
            StringBuilder invoiceNos = new StringBuilder();
            StringBuilder invoiceDates = new StringBuilder();
            if (saleInvoiceInfoList != null && !saleInvoiceInfoList.isEmpty()) {
                for (SaleInvoiceInfo saleInvoiceInfo : saleInvoiceInfoList) {
                    if (SaleInvoiceInfoInvoiceStatus.CANCEL.getCode().equals(saleInvoiceInfo.getInvoiceStatus())) {
                        invoiceNos.append("(").append(saleInvoiceInfo.getInvoiceNo()).append("\u4f5c\u5e9f),");
                    } else {
                        invoiceNos.append(saleInvoiceInfo.getInvoiceNo()).append(",");
                    }
                    invoiceDates.append(new SimpleDateFormat("yyyy-MM-dd").format(saleInvoiceInfo.getInvoiceDate())).append(",");
                }
                invoiceNos = new StringBuilder(invoiceNos.substring(0, invoiceNos.length() - 1));
                invoiceDates = new StringBuilder(invoiceDates.substring(0, invoiceDates.length() - 1));
            }
            row.setInvoiceNos(invoiceNos.toString());
            row.setInvoiceDates(invoiceDates.toString());
            row.setBillStatusDescr(this.enumsService.getDescr(BillStatus.getInstance(billApplyInfo.getBillStatus())));
            row.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)billApplyInfo.getSource())));
            row.setSubUserName(this.userInfoService.queryUserNameByUserId(billApplyInfo.getUserId()));
            rows.add(row);
        }
        BusiQueryBillApplyInfoRspBO rspBO = new BusiQueryBillApplyInfoRspBO();
        rspBO.setRows(rows);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }
}

