/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.zm.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.tydic.pfscext.api.busi.bo.ReconcilitionHisListRepBO;
import com.tydic.pfscext.api.busi.bo.ReconcilitionHisListRspBO;
import com.tydic.pfscext.api.busi.vo.ReconcilitionHisListVO;
import com.tydic.pfscext.api.zm.ReconcilitionHisZmService;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.ReconcilitionHisMapper;
import com.tydic.pfscext.dao.ReconcilitionHisTempMapper;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfoZm;
import com.tydic.pfscext.dao.po.ReconcilitionHis;
import com.tydic.pfscext.dao.po.ReconcilitionHisTemp;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.DictionaryAtomService;
import com.tydic.pfscext.service.atom.bo.DictionaryAtomReqBo;
import com.tydic.pfscext.service.atom.bo.DictionaryAtomRspBo;
import com.tydic.umcext.ability.account.UmcQryEnterpriseAccountDetailAbilityService;
import com.tydic.umcext.ability.account.bo.UmcQryEnterpriseAccountDetailAbilityReqBO;
import com.tydic.umcext.ability.account.bo.UmcQryEnterpriseAccountDetailAbilityRspBO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.zm.ReconcilitionHisZmService"})
public class ReconcilitionHisZmServiceImpl
implements ReconcilitionHisZmService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReconcilitionHisZmServiceImpl.class);
    private static final String IS_TEMP_YES = "1";
    private static final String IS_TEMP_NO = "0";
    private DictionaryAtomService dicDictionaryService;
    private ReconcilitionHisTempMapper reconcilitionHisTempMapper;
    private ReconcilitionHisMapper reconcilitionHisMapper;
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="service")
    private UmcQryEnterpriseAccountDetailAbilityService umcQryEnterpriseAccountDetailAbilityService;

    @Autowired
    public ReconcilitionHisZmServiceImpl(DictionaryAtomService dicDictionaryService, ReconcilitionHisTempMapper reconcilitionHisTempMapper, ReconcilitionHisMapper reconcilitionHisMapper, PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper) {
        this.dicDictionaryService = dicDictionaryService;
        this.reconcilitionHisTempMapper = reconcilitionHisTempMapper;
        this.reconcilitionHisMapper = reconcilitionHisMapper;
        this.payPurchaseOrderInfoMapper = payPurchaseOrderInfoMapper;
    }

    @PostMapping(value={"queryReconcilitionHisList"})
    public ReconcilitionHisListRspBO queryReconcilitionHisList(@RequestBody ReconcilitionHisListRepBO reqBo) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a\u7248\u672c\u53f7\uff1a" + reqBo.getVersionNo() + "\u662f\u5426\u4e34\u65f6\u8868\uff1a" + reqBo.getIsTempTable());
        }
        ReconcilitionHisListRspBO rspBo = new ReconcilitionHisListRspBO();
        UmcQryEnterpriseAccountDetailAbilityReqBO umcReqBO = new UmcQryEnterpriseAccountDetailAbilityReqBO();
        UmcQryEnterpriseAccountDetailAbilityRspBO umcRspBO = new UmcQryEnterpriseAccountDetailAbilityRspBO();
        if (!StringUtils.hasText((String)reqBo.getVersionNo())) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        if (!StringUtils.hasText((String)reqBo.getIsTempTable())) {
            throw new PfscExtBusinessException("18000", "\u662f\u5426\u4e34\u65f6\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (IS_TEMP_YES.equals(reqBo.getIsTempTable())) {
            List<ReconcilitionHisTemp> reconcilitionHisTemp;
            try {
                reconcilitionHisTemp = this.reconcilitionHisTempMapper.selectByVersionNo(Integer.valueOf(reqBo.getVersionNo()));
            }
            catch (Exception e) {
                LOGGER.error("\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBo.getVersionNo(), (Throwable)e);
                throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
            }
            ArrayList<ReconcilitionHisListVO> reconcilitionHisListVoList = new ArrayList<ReconcilitionHisListVO>();
            for (ReconcilitionHisTemp reconcilitionHisTemps : reconcilitionHisTemp) {
                ReconcilitionHisListVO reconcilitionHisListVO = new ReconcilitionHisListVO();
                BeanUtils.copyProperties((Object)reconcilitionHisTemps, (Object)reconcilitionHisListVO);
                reconcilitionHisListVoList.add(reconcilitionHisListVO);
            }
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            rspBo.setRows(reconcilitionHisListVoList);
            return rspBo;
        }
        if (IS_TEMP_NO.equals(reqBo.getIsTempTable())) {
            List<ReconcilitionHis> reconcilitionHis;
            try {
                reconcilitionHis = this.reconcilitionHisMapper.selectByVersionNo(Integer.valueOf(reqBo.getVersionNo()));
            }
            catch (Exception e) {
                LOGGER.error("\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBo.getVersionNo(), (Throwable)e);
                throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
            }
            ArrayList<ReconcilitionHisListVO> reconcilitionHisListVoList = new ArrayList<ReconcilitionHisListVO>();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            for (ReconcilitionHis reconcilitionHiss : reconcilitionHis) {
                String dd;
                SimpleDateFormat format;
                PayPurchaseOrderInfoZm PayPurchaseOrderInfoZm2 = this.payPurchaseOrderInfoMapper.getReconciliationZmByOrderId(reconcilitionHiss.getOrderId());
                ReconcilitionHisListVO reconcilitionHisListVO = new ReconcilitionHisListVO();
                BeanUtils.copyProperties((Object)reconcilitionHiss, (Object)reconcilitionHisListVO);
                if (PayPurchaseOrderInfoZm2 != null) {
                    reconcilitionHisListVO.setErpOrder(this.isErpMap().get(PayPurchaseOrderInfoZm2.getErpOrder()));
                    if (PayPurchaseOrderInfoZm2.getErpOrderNo() != null) {
                        reconcilitionHisListVO.setErpOrderNo(PayPurchaseOrderInfoZm2.getErpOrderNo());
                    }
                    if (PayPurchaseOrderInfoZm2.getStockOrgName() != null) {
                        reconcilitionHisListVO.setStockOrgName(PayPurchaseOrderInfoZm2.getStockOrgName());
                    }
                    if (PayPurchaseOrderInfoZm2.getUseDepartmentName() != null) {
                        reconcilitionHisListVO.setUseDepartmentName(PayPurchaseOrderInfoZm2.getUseDepartmentName());
                    }
                    if (IS_TEMP_YES.equals(PayPurchaseOrderInfoZm2.getBillConfirm()) || "01".equals(PayPurchaseOrderInfoZm2.getBillConfirm())) {
                        reconcilitionHisListVO.setBillConfirmStr("\u672a\u786e\u8ba4");
                    }
                    if ("2".equals(PayPurchaseOrderInfoZm2.getBillConfirm()) || "02".equals(PayPurchaseOrderInfoZm2.getBillConfirm())) {
                        reconcilitionHisListVO.setBillConfirmStr("\u5df2\u786e\u8ba4");
                    }
                    reconcilitionHisListVO.setDownOrderStatusStr(this.getSaleOrderStatusMap().get(PayPurchaseOrderInfoZm2.getDownOrderStatus()));
                    reconcilitionHisListVO.setOrderId(PayPurchaseOrderInfoZm2.getOrderId());
                    if (PayPurchaseOrderInfoZm2.getPurchaseOrderCode() != null) {
                        reconcilitionHisListVO.setPurchaseOrderCode(PayPurchaseOrderInfoZm2.getPurchaseOrderCode());
                    }
                    umcReqBO.setAccountId(PayPurchaseOrderInfoZm2.getPurchaseProjectId());
                    umcRspBO = this.umcQryEnterpriseAccountDetailAbilityService.qryEnterpriseAccountDetail(umcReqBO);
                    reconcilitionHisListVO.setPurchaseProjectName(umcRspBO.getUmcEnterpriseAccountBO().getAccountName());
                }
                if (reconcilitionHiss.getOrderDate() != null) {
                    try {
                        format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        dd = format.format(new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US).parse(reconcilitionHiss.getOrderDate().toString()));
                        LOGGER.error("\u65f6\u95f4\u683c\u5f0f\uff1a" + dd);
                        System.out.println("\u65f6\u95f4\u683c\u5f0f\uff1a" + dd);
                        reconcilitionHisListVO.setOrderDate(dd);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    dd = format.format(new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US).parse(reconcilitionHiss.getReconciliationDate().toString()));
                    LOGGER.error("\u65f6\u95f4\u683c\u5f0f\uff1a" + dd);
                    System.out.println("\u65f6\u95f4\u683c\u5f0f\uff1a" + dd);
                    reconcilitionHisListVO.setReconciliationDate(dd);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                reconcilitionHisListVO.setReconciliationStatusName(this.getReconcilStatusMap().get(reconcilitionHiss.getReconciliationStatus() + ""));
                if (null != reconcilitionHiss.getOrderId()) {
                    reconcilitionHisListVO.setOrderId(reconcilitionHiss.getOrderId().toString());
                } else {
                    reconcilitionHisListVO.setOrderId("");
                }
                reconcilitionHisListVoList.add(reconcilitionHisListVO);
            }
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            rspBo.setRows(reconcilitionHisListVoList);
            return rspBo;
        }
        LOGGER.error("\u662f\u5426\u4e34\u65f6\u8868\u4e3a\u7a7a\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBo.getVersionNo());
        rspBo.setRespCode("18000");
        rspBo.setRespDesc("\u662f\u5426\u4e34\u65f6\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        rspBo.setRows(new ArrayList());
        return rspBo;
    }

    private Map<String, String> getReconcilStatusMap() {
        Map<String, String> map = new HashMap<String, String>(2);
        DictionaryAtomReqBo dictionaryAtomReqBo = new DictionaryAtomReqBo();
        dictionaryAtomReqBo.setpCode("RECONCIL_STATUS");
        DictionaryAtomRspBo dictionaryAtomRspBo = this.dicDictionaryService.qryDic(dictionaryAtomReqBo);
        if (null != dictionaryAtomRspBo) {
            map = dictionaryAtomRspBo.getData();
        }
        return map;
    }

    private Map<String, String> isErpMap() {
        Map<String, String> map = new HashMap<String, String>(2);
        DictionaryAtomReqBo dictionaryAtomReqBo = new DictionaryAtomReqBo();
        dictionaryAtomReqBo.setpCode("IS_ERP");
        DictionaryAtomRspBo dictionaryAtomRspBo = this.dicDictionaryService.qryDic(dictionaryAtomReqBo);
        if (null != dictionaryAtomRspBo) {
            map = dictionaryAtomRspBo.getData();
        }
        return map;
    }

    private Map<String, String> getSaleOrderStatusMap() {
        Map<String, String> map = new HashMap<String, String>(2);
        DictionaryAtomReqBo dictionaryAtomReqBo = new DictionaryAtomReqBo();
        dictionaryAtomReqBo.setpCode("D_SALE_ORDER_INFO_ORDER_STATUS");
        DictionaryAtomRspBo dictionaryAtomRspBo = this.dicDictionaryService.qryDic(dictionaryAtomReqBo);
        if (null != dictionaryAtomRspBo) {
            map = dictionaryAtomRspBo.getData();
        }
        return map;
    }
}

