/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.zm.impl;

import com.tydic.pfscext.api.busi.bo.ReconcilitionHisListRepBO;
import com.tydic.pfscext.api.busi.bo.ReconcilitionHisListRspBO;
import com.tydic.pfscext.api.busi.bo.ReconcilitionSubmitInvoiceReqBO;
import com.tydic.pfscext.api.busi.bo.ReconcilitionSubmitInvoiceRspBO;
import com.tydic.pfscext.api.busi.vo.ReconcilitionHisListVO;
import com.tydic.pfscext.api.zm.ReconcilitionHisZmService;
import com.tydic.pfscext.api.zm.ReconcilitionSubmitZmService;
import com.tydic.pfscext.dao.CheckBillInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.ReconcilitionHisMapper;
import com.tydic.pfscext.dao.po.ReconcilitionSubmitInvoicePO;
import com.tydic.pfscext.dao.po.ReconcilitionZmPO;
import com.tydic.pfscext.enums.ReconciliationStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Transactional
@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.zm.ReconcilitionSubmitZmService"})
public class ReconcilitionSubmitZmServiceImpl
implements ReconcilitionSubmitZmService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReconcilitionSubmitZmServiceImpl.class);
    private ReconcilitionHisMapper reconcilitionHisMapper;
    private CheckBillInfoMapper checkBillInfoMapper;
    private ReconcilitionHisZmService reconcilitionHisZmService;
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;

    @Autowired
    public ReconcilitionSubmitZmServiceImpl(ReconcilitionHisMapper reconcilitionHisMapper, CheckBillInfoMapper checkBillInfoMapper, ReconcilitionHisZmService reconcilitionHisZmService, PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper) {
        this.reconcilitionHisMapper = reconcilitionHisMapper;
        this.checkBillInfoMapper = checkBillInfoMapper;
        this.reconcilitionHisZmService = reconcilitionHisZmService;
        this.payPurchaseOrderInfoMapper = payPurchaseOrderInfoMapper;
    }

    @PostMapping(value={"submitInvoice"})
    public ReconcilitionSubmitInvoiceRspBO submitInvoice(@RequestBody ReconcilitionSubmitInvoiceReqBO reqBO) {
        int dateCounnt;
        ReconcilitionZmPO recordZmPO = new ReconcilitionZmPO();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u7ed3\u7b97\u5bf9\u8d26\u63d0\u4ea4\u5f00\u7968\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a\u7248\u672c\u53f7\uff1a" + reqBO.getBatchNo());
        }
        ReconcilitionSubmitInvoiceRspBO rspBO = new ReconcilitionSubmitInvoiceRspBO();
        if (!StringUtils.hasText((String)reqBO.getBatchNo())) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u672a\u8fdb\u884c\u5bf9\u8d26\uff0c\u4e0d\u80fd\u63d0\u4ea4\uff01");
            return rspBO;
        }
        List<Integer> supplierNo = this.reconcilitionHisMapper.selectSupplierNo(Integer.valueOf(reqBO.getBatchNo()));
        if (supplierNo == null || supplierNo.size() == 0) {
            throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u672a\u5bf9\u8d26");
        }
        if (supplierNo.size() > 1) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u4e0d\u662f\u540c\u4e00\u4f9b\u5e94\u5546\uff0c\u4e0d\u80fd\u63d0\u4ea4\uff01");
            return rspBO;
        }
        List<String> supplierName = this.reconcilitionHisMapper.selectSupplierName(Integer.valueOf(reqBO.getBatchNo()));
        recordZmPO.setNotificationState("03");
        Calendar now = Calendar.getInstance();
        String sup = null;
        switch (supplierName.get(0)) {
            case "\u4eac\u4e1c": {
                sup = "JD";
                break;
            }
            case "\u897f\u57df": {
                sup = "XY";
                break;
            }
            case "\u56fa\u5b89\u6377": {
                sup = "GA";
                break;
            }
            case "\u5f97\u529b": {
                sup = "DL";
                break;
            }
            case "\u82cf\u5b81": {
                sup = "SN";
                break;
            }
            case "\u9707\u5764\u884c": {
                sup = "ZK";
                break;
            }
            case "\u5de5\u54c1\u6c47": {
                sup = "GP";
            }
        }
        Calendar cal = Calendar.getInstance();
        cal.set(now.get(1), now.get(2), now.get(5), 0, 0, 0);
        Date startDate = cal.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date1 = formatter.format(startDate);
        System.out.println("\u4eca\u5929\u65f6\u95f4" + date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.set(now.get(1), now.get(2), now.get(5) + 1, 0, 0, 0);
        Date EndDate = cal2.getTime();
        String date2 = formatter.format(EndDate);
        System.out.println("\u7b2c\u4e8c\u5929\u65f6\u95f4" + date2);
        int count = this.checkBillInfoMapper.selectCount(supplierName.get(0), date1, date2);
        String dateCounntStr = null;
        if (count < 9) {
            dateCounnt = count + 1;
            dateCounntStr = "0" + dateCounnt;
        } else {
            dateCounnt = count + 1;
            dateCounntStr = dateCounnt + "";
        }
        String moth = null;
        if (now.get(2) + 1 < 10) {
            int m = now.get(2) + 1;
            moth = "0" + m;
        }
        String reconcilitionCode = "YGDZ-" + sup + "-" + now.get(1) + moth + now.get(5) + "-" + dateCounntStr;
        System.out.println("\u5bf9\u8d26\u5355\u7f16\u53f7" + reconcilitionCode);
        recordZmPO.setReconcilitionCode(reconcilitionCode);
        Date date = new Date();
        recordZmPO.setReconcilitionDate(date);
        recordZmPO.setSupId(supplierNo.get(0).longValue());
        recordZmPO.setSupName(supplierName.get(0).toString());
        if (reqBO.getUserId() != null) {
            recordZmPO.setUserId(reqBO.getUserId().toString());
        }
        recordZmPO.setUserName(reqBO.getUsername());
        this.checkBillInfoMapper.insert(recordZmPO);
        ReconcilitionHisListRepBO reconcilitionHisListRepBO = new ReconcilitionHisListRepBO();
        reconcilitionHisListRepBO.setIsTempTable("0");
        reconcilitionHisListRepBO.setVersionNo(reqBO.getBatchNo());
        ReconcilitionHisListRspBO reconcilitionHisListRspBO = this.reconcilitionHisZmService.queryReconcilitionHisList(reconcilitionHisListRepBO);
        if (reconcilitionHisListRspBO.getRows() != null && reconcilitionHisListRspBO.getRows().size() > 0) {
            for (ReconcilitionHisListVO row : reconcilitionHisListRspBO.getRows()) {
                System.out.println("code:" + row.getOrderId());
                System.out.println("ReconcilitionCode:" + recordZmPO.getReconcilitionCode());
                this.payPurchaseOrderInfoMapper.updateReconciliationCodeByOrderCode(Long.valueOf(row.getOrderId()), recordZmPO.getReconcilitionCode());
                this.reconcilitionHisMapper.updateReconciliationCodeByOrderId(row.getOrderId(), Integer.valueOf(reqBO.getBatchNo()), recordZmPO.getReconcilitionCode());
            }
        }
        ReconcilitionSubmitInvoicePO reconcilitionSubmitInvoicePO = this.reconcilitionHisMapper.selectAccount(Integer.valueOf(reqBO.getBatchNo()), ReconciliationStatus.AGREEMENT.getCode());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setAmountCount(reconcilitionSubmitInvoicePO.getOrderNum());
        rspBO.setAmountPrice(reconcilitionSubmitInvoicePO.getOrderAmt());
        rspBO.setSupplierNo(supplierNo.get(0).toString());
        return rspBO;
    }
}

