/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.controller.mock;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.pfscext.api.busi.BusiInvoiceWayBillService;
import com.tydic.pfscext.api.busi.bo.BusiBackInvoiceDetailReqBO;
import com.tydic.pfscext.api.busi.bo.BusiBackInvoiceReqBO;
import com.tydic.pfscext.api.busi.bo.BusiInvoiceWayBillReqBO;
import com.tydic.pfscext.controller.mock.FscMockUtils;
import com.tydic.pfscext.controller.rest.FscBillApplyController;
import com.tydic.pfscext.mock.FscMockBackInvoiceService;
import com.tydic.pfscext.mock.FscMockGetInvoiceService;
import com.tydic.pfscext.mock.bo.FscMockBackInvoiceBO;
import com.tydic.pfscext.mock.bo.FscMockBackInvoiceDetailBO;
import com.tydic.pfscext.mock.bo.FscMockGetInvoiceBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/fsc/mock/invoice"})
public class FscInvoiceMockController {
    @Autowired
    private FscBillApplyController fscBillApplyController;
    @Reference(interfaceClass=FscMockBackInvoiceService.class, version="1.0.0", group="FSC_GROUP_DEV")
    private FscMockBackInvoiceService fscMockBackInvoiceService;
    @Reference(interfaceClass=FscMockGetInvoiceService.class, version="1.0.0", group="FSC_GROUP_DEV")
    private FscMockGetInvoiceService fscMockGetInvoiceService;
    @Reference(interfaceClass=BusiInvoiceWayBillService.class, version="1.0.0", group="FSC_GROUP_DEV")
    private BusiInvoiceWayBillService busiInvoiceWayBillService;

    @PostMapping(value={"/backInvoice"})
    public Object backInvoice(HttpServletRequest request) {
        String reqStr = FscMockUtils.getRequestParamsStr(request);
        String billNo = StringUtils.hasText((String)reqStr) ? JSONObject.parseObject((String)reqStr).getString("billNo") : request.getParameter("billNo");
        try {
            FscMockBackInvoiceBO mockBackInvoiceBo = this.fscMockBackInvoiceService.mockBackData(billNo);
            BusiBackInvoiceReqBO reqBo = new BusiBackInvoiceReqBO();
            BeanUtils.copyProperties((Object)mockBackInvoiceBo, (Object)reqBo);
            ArrayList<BusiBackInvoiceDetailReqBO> detailReqBoList = new ArrayList<BusiBackInvoiceDetailReqBO>();
            for (FscMockBackInvoiceDetailBO mockBackInvoiceDetailBo : mockBackInvoiceBo.getDetail()) {
                BusiBackInvoiceDetailReqBO detailReqBo = new BusiBackInvoiceDetailReqBO();
                BeanUtils.copyProperties((Object)mockBackInvoiceDetailBo, (Object)detailReqBo);
                detailReqBoList.add(detailReqBo);
            }
            reqBo.setDetail(detailReqBoList);
            return this.fscBillApplyController.backInvoice(reqBo);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    @PostMapping(value={"/applyInvoice"})
    public String applyInvoice() {
        return "{\"resultCode\": \"3301\",\"resultMessage\": \"\u6210\u529f\",\"success\":true}";
    }

    @PostMapping(value={"/invoiceSendStatus"})
    public String invoiceSendStatus() {
        String dateToStr = DateUtils.dateToStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        String rand = String.valueOf(new Random().nextFloat()).substring(2, 9);
        return "{\"resultCode\": \"3301\",\"resultMessage\": \"\u6210\u529f\",\"result\": [{\"postId\": \"" + rand + "\",\"deliveryId\": \"" + rand + "\",\"postCompany\": \"mock\u914d\u9001\u516c\u53f8\",\"postTime\": \"" + dateToStr + "\",\"state\": \"mock\u914d\u9001\u72b6\u6001\",\"resultMessage\": \"\"}]}";
    }

    @PostMapping(value={"/getInvoice"})
    public String getInvoice(HttpServletRequest request) {
        String reqStr = FscMockUtils.getRequestParamsStr(request);
        String markId = JSONObject.parseObject((String)reqStr).getString("markId");
        try {
            FscMockGetInvoiceBO invoiceData = this.fscMockGetInvoiceService.getInvoiceData(markId);
            return "{\"resultCode\": \"0004\",\"resultMessage\": \"\u6210\u529f\",\"result\": [{\"invoiceNo\": \"" + invoiceData.getInvoiceNo() + "\",\"invoiceId\": \"" + invoiceData.getInvoiceId() + "\",\"invoiceCode\": \"" + invoiceData.getInvoiceCode() + "\",\"invoiceDate\": \"" + invoiceData.getInvoiceDate() + "\",\"invoiceAmount\": \"" + invoiceData.getInvoiceAmount() + "\",\"invoiceNakedAmount\": \"" + invoiceData.getInvoiceNakedAmount() + "\",\"invoiceTaxAmount\": \"" + invoiceData.getInvoiceTaxAmount() + "\",\"title\": \"" + invoiceData.getTitle() + "\",\"enterpriseTaxpayer\": \"" + invoiceData.getEnterpriseTaxpayer() + "\",\"address\": \"" + invoiceData.getAddress() + "\",\"tel\": \"" + invoiceData.getTel() + "\",\"bank\": \"" + invoiceData.getBank() + "\",\"account\": \"" + invoiceData.getAccount() + "\",\"invoiceType\": \"" + invoiceData.getInvoiceType() + "\"}]}";
        }
        catch (Exception e) {
            return "{\"resultCode\": \"0001\",\"resultMessage\": \"" + e.getMessage() + "\"}";
        }
    }

    @PostMapping(value={"/getInvoiceMailInfo"})
    public Object getInvoiceMailInfo() {
        return this.busiInvoiceWayBillService.getInvoiceWayBill(new BusiInvoiceWayBillReqBO());
    }
}

