/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.controller.rest;

import com.tydic.pfscext.api.busi.BusiAccountCheckingService;
import com.tydic.pfscext.api.busi.BusiAcctCheckingListService;
import com.tydic.pfscext.api.busi.BusiSubAccountAdjustService;
import com.tydic.pfscext.api.busi.bo.BusiAccountCheckingReqBO;
import com.tydic.pfscext.api.busi.bo.BusiSubAccountAdjustReqBO;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/fsc/pingan"})
public class FscPianAnRestController {
    private static final Logger logger = LoggerFactory.getLogger(FscPianAnRestController.class);
    @Reference(interfaceClass=BusiAcctCheckingListService.class, version="1.0.0", group="FSC_GROUP_DEV")
    private BusiAcctCheckingListService busiAcctCheckingListService;
    @Reference(interfaceClass=BusiSubAccountAdjustService.class, version="1.0.0", group="FSC_GROUP_DEV")
    private BusiSubAccountAdjustService busiSubAccountAdjustService;
    @Reference(interfaceClass=BusiAccountCheckingService.class, version="1.0.0", group="FSC_GROUP_DEV")
    private BusiAccountCheckingService busiAccountCheckingService;

    @PostMapping(value={"/queryBillResultList"})
    public Object queryBillResultList(@RequestBody BusiAccountCheckingReqBO reqBo) {
        return this.busiAcctCheckingListService.listResult(reqBo);
    }

    @PostMapping(value={"/triggerBill"})
    public Object triggerBill(BusiAccountCheckingReqBO reqBo) {
        return this.busiAccountCheckingService.execAcChecking(reqBo);
    }

    @PostMapping(value={"/subAccountTransform"})
    public Object dealAdjustApply(@RequestBody BusiSubAccountAdjustReqBO bo) {
        logger.debug("\u8c03\u8d26\u5165\u53c2\u53c2\u6570\uff1a{}", (Object)bo.toString());
        return this.busiSubAccountAdjustService.adjustSubAccount(bo);
    }
}

