/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.controller.rest.dataimport;

import com.tydic.pfscext.api.busi.BusiAddBillNotificationImportInfoService;
import com.tydic.pfscext.api.busi.bo.BillNotificationImportInfoBO;
import com.tydic.pfscext.api.busi.bo.BusiAddBillNotificationImportInfoReqBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.controller.utils.FscExcelUtils;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Component
public class FscImportCheckSignService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscImportCheckSignService.class);
    private String[] sheetNames = new String[]{"\u5f00\u7968\u901a\u77e5\u5355\u6279\u91cf\u6838\u5bf9\u7b7e\u6536\u5bfc\u5165\u6a21\u677f"};
    @Reference(interfaceClass=BusiAddBillNotificationImportInfoService.class, version="1.0.0", group="FSC_GROUP_DEV")
    private BusiAddBillNotificationImportInfoService busiAddBillNotificationImportInfoService;

    public PfscExtRspBaseBO importData(@RequestParam(value="file") MultipartFile file) {
        PfscExtRspBaseBO rspInfo = new PfscExtRspBaseBO();
        if (null == file) {
            rspInfo.setRespCode("18000");
            rspInfo.setRespDesc("\u65e0\u6cd5\u5f97\u5230\u6587\u4ef6\u6570\u636e");
            return rspInfo;
        }
        return this.uploadExcel(file);
    }

    private PfscExtRspBaseBO uploadExcel(MultipartFile file) {
        PfscExtRspBaseBO rspInfo = new PfscExtRspBaseBO();
        rspInfo.setRespCode("0000");
        rspInfo.setRespDesc("\u5bfc\u5165\u6210\u529f");
        int sheetIndex = 0;
        try {
            Workbook wb = FscExcelUtils.createWorkbook(file);
            if (wb.getNumberOfSheets() != 1) {
                rspInfo.setRespCode("18000");
                rspInfo.setRespDesc("\u6587\u4ef6\u672a\u5305\u542b\u9884\u671f\u76841\u4e2asheet\u9875");
                return rspInfo;
            }
            Sheet sheet = wb.getSheetAt(0);
            if (!this.sheetNames[sheetIndex].equals(sheet.getSheetName())) {
                rspInfo.setRespCode("18000");
                rspInfo.setRespDesc("\u9875\u540d\u79f0[" + sheet.getSheetName() + "]\u4e0e\u9884\u671f\u4e0d\u7b26\u5408,\u8bf7\u4e0d\u8981\u4fee\u6539\u6a21\u677f\u6587\u4ef6\u7684\u9875\u540d\u79f0");
                return rspInfo;
            }
            ArrayList<BillNotificationImportInfoBO> importInfoList = new ArrayList<BillNotificationImportInfoBO>();
            HashMap<String, String> notificationNoMap = new HashMap<String, String>(16);
            for (int rowNum = 3; rowNum <= sheet.getLastRowNum(); ++rowNum) {
                Row row = sheet.getRow(rowNum);
                if (null == row) continue;
                String notificationNo = FscExcelUtils.getValue(row.getCell(1));
                if (notificationNoMap.containsKey(notificationNo)) {
                    rspInfo.setRespCode("18000");
                    rspInfo.setRespDesc("\u7b2c" + (rowNum + 1) + "\u884c\u5f00\u7968\u901a\u77e5\u5355\u53f7\u7801\u91cd\u590d!");
                    return rspInfo;
                }
                notificationNoMap.put(notificationNo, "val");
                BillNotificationImportInfoBO importInfoBO = new BillNotificationImportInfoBO();
                importInfoBO.setNotificationNo(notificationNo);
                importInfoList.add(importInfoBO);
            }
            BusiAddBillNotificationImportInfoReqBO importInfoReqBO = new BusiAddBillNotificationImportInfoReqBO();
            importInfoReqBO.setNotificationImportInfoList(importInfoList);
            PfscExtRspBaseBO insert = this.busiAddBillNotificationImportInfoService.insert(importInfoReqBO);
            if (null != insert && !"0000".equals(insert.getRespCode())) {
                rspInfo.setRespCode("18000");
                rspInfo.setRespDesc(StringUtils.hasText((String)insert.getRespDesc()) ? insert.getRespDesc() : "\u5931\u8d25");
            }
            return rspInfo;
        }
        catch (Exception e) {
            LOGGER.error("\u65e0\u6cd5\u89e3\u6790Excel\u6587\u4ef6:" + e.getMessage());
            rspInfo.setRespCode("18000");
            rspInfo.setRespDesc("\u65e0\u6cd5\u89e3\u6790Excel\u6587\u4ef6[" + file.getOriginalFilename() + "]");
            return rspInfo;
        }
    }
}

