/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.controller.rest.dataimport;

import com.ohaotian.plugin.file.FileClient;
import com.tydic.pfscext.api.busi.ReconcilitionDetailImportRedisAddBusiService;
import com.tydic.pfscext.api.busi.bo.ReconcilitionDetailImportAddReqBO;
import com.tydic.pfscext.api.busi.bo.ReconcilitionDetailImportAddRspBO;
import com.tydic.pfscext.api.busi.bo.ReconcilitionDetailImportRedisAddItemReqBO;
import com.tydic.pfscext.controller.utils.FscExcelUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Component
public class FscImportReconcilitionInfoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscImportReconcilitionInfoService.class);
    private static final String EXPORT_ERROR_EXCEL_TITLE = "\u9519\u8bef\u4fe1\u606f";
    private static final String NUMFORMAT_SEPARATOR = ",";
    @Reference(interfaceClass=ReconcilitionDetailImportRedisAddBusiService.class, version="1.0.0", group="FSC_GROUP_DEV")
    private ReconcilitionDetailImportRedisAddBusiService reconcilitionDetailImportBusiService;
    @Autowired
    private FileClient fileClient;

    public ReconcilitionDetailImportAddRspBO reconcilitionDetailImportAdd(HttpServletResponse response, @RequestParam(value="file") MultipartFile file) {
        ReconcilitionDetailImportAddRspBO rspBO = new ReconcilitionDetailImportAddRspBO();
        String excelFileName = file.getOriginalFilename();
        try {
            Workbook wb = FscExcelUtils.createWorkbook(file);
            ReconcilitionDetailImportAddReqBO reqBO = new ReconcilitionDetailImportAddReqBO();
            reqBO.setReconcilitionDetailImportRedisAddReqBOList(this.excelToReqBOList(wb));
            rspBO = this.reconcilitionDetailImportBusiService.addReconcilitionDetailImportRedis(reqBO);
            if ("18059".equals(rspBO.getRespCode())) {
                response.setContentType("application/binary;charset=UTF-8");
                String fileName = new String(excelFileName.getBytes(), StandardCharsets.UTF_8);
                response.setHeader("Content-disposition", "attachment; filename=\"" + fileName + ".xls\";target=_blank");
                this.exportExcel(wb, rspBO.getValidateMessages());
                String fileUrl = this.getErrorFileName(wb, fileName);
                rspBO.setErrorFilePath(fileUrl);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5bf9\u8d26\u4fe1\u606f\u5bfc\u5165\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u5bf9\u8d26\u4fe1\u606f\u5bfc\u5165\u670d\u52a1\u5f02\u5e38");
        }
        return rspBO;
    }

    private List<ReconcilitionDetailImportRedisAddItemReqBO> excelToReqBOList(Workbook wb) {
        ArrayList<ReconcilitionDetailImportRedisAddItemReqBO> reqBOList = new ArrayList<ReconcilitionDetailImportRedisAddItemReqBO>();
        try {
            Sheet sheet = wb.getSheetAt(0);
            Iterator rows = sheet.rowIterator();
            int count = 0;
            while (rows.hasNext()) {
                Row row = (Row)rows.next();
                if (count < 1) {
                    ++count;
                    continue;
                }
                ReconcilitionDetailImportRedisAddItemReqBO itemReqBO = new ReconcilitionDetailImportRedisAddItemReqBO();
                if (null == row) continue;
                itemReqBO.setSupplierName(this.getCellValue(row.getCell(0)));
                itemReqBO.setExtOrderId(this.getCellValue(row.getCell(1)).replace(".0", ""));
                if (StringUtils.isNotBlank((CharSequence)this.getCellValue(row.getCell(2)))) {
                    if (this.isDecimalNumber(this.getCellValue(row.getCell(2)))) {
                        itemReqBO.setOutAmt(new BigDecimal(this.getCellValue(row.getCell(2))));
                    } else {
                        itemReqBO.setOutAmt(null);
                    }
                }
                reqBOList.add(itemReqBO);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u7ed3\u7b97\u5bf9\u8d26\u5bfc\u5165\u670d\u52a1-\u65b0\u589e\u5f02\u5e38", (Throwable)e);
        }
        return reqBOList;
    }

    private String getCellValue(Cell cell) {
        Object result = "";
        if (cell != null) {
            switch (cell.getCellType()) {
                case STRING: {
                    result = cell.getStringCellValue();
                    break;
                }
                case NUMERIC: {
                    NumberFormat nf = NumberFormat.getInstance();
                    String s = nf.format(cell.getNumericCellValue());
                    if (s.contains(NUMFORMAT_SEPARATOR)) {
                        s = s.replace(NUMFORMAT_SEPARATOR, "");
                    }
                    result = s;
                    break;
                }
                case BOOLEAN: {
                    result = cell.getBooleanCellValue();
                    break;
                }
                case FORMULA: {
                    try {
                        result = cell.getStringCellValue();
                    }
                    catch (IllegalStateException e) {
                        result = String.valueOf(cell.getNumericCellValue());
                    }
                    break;
                }
                case ERROR: {
                    result = cell.getErrorCellValue();
                    break;
                }
            }
        }
        return result.toString();
    }

    private boolean isDecimalNumber(String number) {
        boolean isInt = Pattern.compile("^-?[1-9]\\d*$").matcher(number).find();
        boolean isDouble = Pattern.compile("^-?([1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|0)$").matcher(number).find();
        return isInt || isDouble;
    }

    private void exportExcel(Workbook wb, List<String> errMsgList) {
        if (errMsgList != null && !errMsgList.isEmpty()) {
            Sheet sheet = wb.getSheetAt(0);
            Row titleRow = sheet.getRow(0);
            titleRow.createCell(6).setCellValue(EXPORT_ERROR_EXCEL_TITLE);
            for (int i = 0; i < errMsgList.size(); ++i) {
                Row row = sheet.getRow(i + 1);
                if (null == errMsgList.get(i)) continue;
                row.createCell(6).setCellValue(errMsgList.get(i));
            }
        }
    }

    private String getErrorFileName(Workbook wb, String fileName) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            wb.write((OutputStream)os);
        }
        catch (IOException e) {
            LOGGER.error("IOException", (Throwable)e);
        }
        byte[] content = os.toByteArray();
        ByteArrayInputStream is = new ByteArrayInputStream(content);
        return this.fileClient.uploadFileByInputStream("fsc", fileName, (InputStream)is);
    }
}

