/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.controller.rest.zm;

import com.tydic.pfscext.api.zm.BillConfirmedService;
import com.tydic.pfscext.api.zm.QueryBillDetailService;
import com.tydic.pfscext.api.zm.QueryExcelZmBillInfoService;
import com.tydic.pfscext.api.zm.QueryZmBillInfoService;
import com.tydic.pfscext.api.zm.SelectPurcharIdByBillDayService;
import com.tydic.pfscext.api.zm.bo.BillInfoAndOrderInfoReqBO;
import com.tydic.pfscext.api.zm.bo.QueryBillDetailReqBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/fsc/bill"})
public class FscDownStreamBillController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscDownStreamBillController.class);
    @Reference(interfaceClass=QueryBillDetailService.class, version="1.0.0", group="FSC_GROUP_DEV")
    private QueryBillDetailService queryBillDetailService;
    @Reference(interfaceClass=QueryZmBillInfoService.class, version="1.0.0", group="FSC_GROUP_DEV")
    private QueryZmBillInfoService queryZmBillInfoService;
    @Reference(interfaceClass=BillConfirmedService.class, version="1.0.0", group="FSC_GROUP_DEV")
    private BillConfirmedService billConfirmedService;
    @Reference(interfaceClass=SelectPurcharIdByBillDayService.class, version="1.0.0", group="FSC_GROUP_DEV")
    private SelectPurcharIdByBillDayService selectPurcharIdByBillDayService;
    @Reference(interfaceClass=QueryExcelZmBillInfoService.class, version="1.0.0", group="FSC_GROUP_DEV")
    private QueryExcelZmBillInfoService queryExcelZmBillInfoService;

    @PostMapping(value={"/queryZmBillInfo"})
    public Object queryZmBillInfo(@RequestBody BillInfoAndOrderInfoReqBO reqBO) {
        LOGGER.debug("\u8d26\u5355\u5217\u8868\u67e5\u8be2\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)reqBO.toString());
        return this.queryZmBillInfoService.queryZmBillInfo(reqBO);
    }

    @PostMapping(value={"/noauth/queryZmBillInfo"})
    public Object query(@RequestBody BillInfoAndOrderInfoReqBO reqBO) {
        LOGGER.debug("\u5bfc\u51fa\u8d26\u5355\u5217\u8868\u67e5\u8be2\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)reqBO.toString());
        return this.queryExcelZmBillInfoService.queryZmBillInfo(reqBO);
    }

    @PostMapping(value={"/queryZmBillDetail"})
    public Object queryZmBillDetail(@RequestBody QueryBillDetailReqBO reqBO) {
        LOGGER.debug("\u8d26\u5355\u8be6\u60c5\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)reqBO.toString());
        return this.queryBillDetailService.queryZmBillDetail(reqBO);
    }

    @PostMapping(value={"/billConfirmed"})
    public Object billConfirmed(@RequestBody QueryBillDetailReqBO reqBO) {
        LOGGER.debug("\u8d26\u5355\u786e\u8ba4\u5165\u53c2\uff1a{}", (Object)reqBO.toString());
        return this.billConfirmedService.billConfirmed(reqBO);
    }

    @PostMapping(value={"/selectPurcharIdByBillDay"})
    public PfscExtRspBaseBO selectPurcharIdByBillDay() {
        return this.selectPurcharIdByBillDayService.selectPurcharIdByBillDay();
    }
}

