/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.atom.impl;

import com.tydic.pfscext.dao.po.FinanceConfig;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.external.api.FscUserInfoFromUmcService;
import com.tydic.pfscext.external.api.bo.ProjectInfoBO;
import com.tydic.pfscext.external.api.bo.UserDetailInfoBO;
import com.tydic.pfscext.service.atom.UserInfoService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UserInfoServiceImpl
implements UserInfoService {
    private static final Logger logger = LoggerFactory.getLogger(UserInfoServiceImpl.class);
    private FscUserInfoFromUmcService fscUserInfoFromUmcService;

    @Autowired
    public UserInfoServiceImpl(FscUserInfoFromUmcService fscUserInfoFromUmcService) {
        this.fscUserInfoFromUmcService = fscUserInfoFromUmcService;
    }

    @Override
    public String queryUserNameByUserId(Long userId) {
        String name = "";
        UserDetailInfoBO userDetailInfoBO = this.fscUserInfoFromUmcService.queryUserInfoByUserId(userId);
        if (null != userDetailInfoBO) {
            name = userDetailInfoBO.getMemName2();
        } else {
            logger.debug("\u8de8\u5e94\u7528\u67e5\u8be2\u7528\u6237\u540d\u79f0\u5931\u8d25,userId=" + userId);
        }
        return name;
    }

    @Override
    public String queryFinanceUserCodeByUserId(String source, FinanceConfig financeConfig, Long userId) {
        String financeUserCode = "";
        if (OrderSource.CONSULT_PRICE.getCode().equals(source)) {
            UserDetailInfoBO userDetailInfoBO;
            if (null != userId && null == (userDetailInfoBO = this.fscUserInfoFromUmcService.queryUserInfoByUserId(userId))) {
                logger.debug("\u8de8\u5e94\u7528\u67e5\u8be2\u8d22\u52a1\u7528\u6237\u4ee3\u7801\u5931\u8d25,\u8fd4\u56deresp\u4e3anull,userId=" + userId);
            }
            if (!StringUtils.hasText((String)financeUserCode)) {
                financeUserCode = financeConfig.getYhdm();
            }
        } else {
            financeUserCode = financeConfig.getYhdm();
        }
        return financeUserCode;
    }

    @Override
    public List<Long> queryUserIdListByUserNameLike(String userName) {
        return this.fscUserInfoFromUmcService.queryUserIdListByUserNameLike(userName);
    }

    @Override
    public UserDetailInfoBO queryUserInfoByUserId(Long userId) {
        return this.fscUserInfoFromUmcService.queryUserInfoByUserId(userId);
    }

    @Override
    public List<ProjectInfoBO> queryProjectInfoByUserId(Long userId) {
        return this.fscUserInfoFromUmcService.queryProjectInfoByUserId(userId);
    }
}

