/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.pfscext.api.busi.BusiNotificationService;
import com.tydic.pfscext.api.busi.NotificationSendRequestService;
import com.tydic.pfscext.api.busi.bo.BusiNotificationReqBO;
import com.tydic.pfscext.api.busi.bo.BusiNotificationRspBO;
import com.tydic.pfscext.api.busi.bo.NotificationSendRequestReqBO;
import com.tydic.pfscext.api.busi.vo.OrderInfoVO;
import com.tydic.pfscext.api.busi.vo.OrderItemVO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfoExt;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.vo.PayItemInfoVO;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.dao.vo.QueryReconcilitionOrderVO;
import com.tydic.pfscext.enums.BillType;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.ReconciliationStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.BillSNService;
import com.tydic.pfscext.service.atom.BusiNotificationSplitService;
import com.tydic.umcext.ability.org.UmcZhEnterpriseOrgQueryAbilityService;
import com.tydic.umcext.ability.org.bo.UmcZhEnterpriseOrgDetailAbilityRspBO;
import com.tydic.umcext.ability.org.bo.UmcZhEnterpriseOrgQueryAbilityReqBO;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiNotificationService.class)
public class BusiNotificationServiceImpl
implements BusiNotificationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusiNotificationServiceImpl.class);
    private static final String SELECT_ALL_YES = "Y";
    private static final String SELECT_ALL_NO = "N";
    private static final String GROUPWAY_NOSPLIT = "noSplitGroup";
    private static final String GROUPWAY_PURUNIT = "purchaseUnitGroup";
    private static final String GROUPWAY_ORDER = "orderGroup";
    private static final String MAX_ORDER_AMT = "500";
    private static final Integer MAX_ORDER_NUM = 300;
    private PayItemInfoMapper payItemInfoMapper;
    private BillNotificationInfoMapper billNotificationInfoMapper;
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    private BillSNService billSNService;
    private BusiNotificationSplitService busiNotificationSplitService;
    private NotificationSendRequestService notificationSendRequestService;
    @Resource(name="billNotificationBatchNoSeq")
    private OrderSequence billNotificationBatchNoSeq;
    @Autowired
    private UmcZhEnterpriseOrgQueryAbilityService umcZhEnterpriseOrgQueryAbilityService;

    @Autowired
    public BusiNotificationServiceImpl(PayItemInfoMapper payItemInfoMapper, BillNotificationInfoMapper billNotificationInfoMapper, PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper, BillSNService billSNService, BusiNotificationSplitService busiNotificationSplitService, NotificationSendRequestService notificationSendRequestService) {
        this.payItemInfoMapper = payItemInfoMapper;
        this.billNotificationInfoMapper = billNotificationInfoMapper;
        this.payPurchaseOrderInfoMapper = payPurchaseOrderInfoMapper;
        this.billSNService = billSNService;
        this.busiNotificationSplitService = busiNotificationSplitService;
        this.notificationSendRequestService = notificationSendRequestService;
    }

    public BusiNotificationRspBO makeNotify(BusiNotificationReqBO reqBO) {
        String groupWay;
        List<PayPurchaseOrderInfo> payPurchaseOrderInfoPOs;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (null == reqBO.getMaxOrderNumber() || reqBO.getMaxOrderNumber() <= 0) {
            throw new PfscExtBusinessException("0001", "\u5355\u5f20\u901a\u77e5\u6700\u5927\u8ba2\u5355\u6570[maxOrderNumber]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getMaxOrderAmt())) {
            throw new PfscExtBusinessException("0001", "\u5355\u5f20\u901a\u77e5\u6700\u5927\u91d1\u989d[maxOrderAmt]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getGroupWay()) {
            throw new PfscExtBusinessException("0001", "\u5206\u7ec4\u65b9\u5f0f[groupWay]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceInfo() || !StringUtils.hasText((String)reqBO.getInvoiceInfo().getInvoiceTitle())) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        if (null == reqBO.getMailAddrInfo() || !StringUtils.hasText((String)reqBO.getMailAddrInfo().getName())) {
            throw new PfscExtBusinessException("0001", "\u90ae\u5bc4\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        List<Object> orderInfos = new LinkedList();
        if (null != reqBO.getPayModel() && "purchaser".equals(reqBO.getPayModel())) {
            reqBO.setPurchaserId(reqBO.getUserId());
        }
        Long purchaserId = null;
        if (!"0".equals(reqBO.getIsProfessionalOrgExt())) {
            UmcZhEnterpriseOrgQueryAbilityReqBO umcZhEnterpriseOrgQueryAbilityReqBO = new UmcZhEnterpriseOrgQueryAbilityReqBO();
            umcZhEnterpriseOrgQueryAbilityReqBO.setOrgIdWeb(reqBO.getCompanyId());
            UmcZhEnterpriseOrgDetailAbilityRspBO umcZhEnterpriseOrgDetailAbilityRspBO = this.umcZhEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(umcZhEnterpriseOrgQueryAbilityReqBO);
            LOGGER.info("\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u7ed3\u679c\u51fa\u53c21:" + umcZhEnterpriseOrgDetailAbilityRspBO.toString());
            if ("0000".equals(umcZhEnterpriseOrgDetailAbilityRspBO.getRespCode()) && null != umcZhEnterpriseOrgDetailAbilityRspBO && null != umcZhEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO()) {
                JSONObject json;
                String settleModel;
                LOGGER.info("\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u7ed3\u679c\u51fa\u53c22:" + umcZhEnterpriseOrgDetailAbilityRspBO.getRespCode());
                LOGGER.info("\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u7ed3\u679c\u51fa\u53c23:" + umcZhEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO().toString());
                String extJson = umcZhEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO().getExtJson();
                if (null != extJson && !"".equals(extJson) && "purchaser".equals(settleModel = (json = JSON.parseObject((String)extJson)).getString("settleModel"))) {
                    LOGGER.info("\u4e0b\u5355\u4ebaID\u8d4b\u503c:" + purchaserId + "\u6a21\u5f0f\uff1a" + settleModel);
                    purchaserId = reqBO.getUserId();
                }
            }
        }
        if (null != reqBO.getVersionNo()) {
            QueryReconcilitionOrderVO queryReconcilitionOrderVO = new QueryReconcilitionOrderVO();
            queryReconcilitionOrderVO.setVersionNo(reqBO.getVersionNo());
            queryReconcilitionOrderVO.setOrderStatus(OrderStatus.NO_APPLY.getCode());
            queryReconcilitionOrderVO.setReconcilitionStatus(ReconciliationStatus.AGREEMENT.getCode());
            queryReconcilitionOrderVO.setOrderBy("orderAmt asc");
            queryReconcilitionOrderVO.setPurchaserId(reqBO.getPurchaserId());
            payPurchaseOrderInfoPOs = this.payPurchaseOrderInfoMapper.getListByReconcilition(queryReconcilitionOrderVO);
            if (payPurchaseOrderInfoPOs.isEmpty()) {
                throw new PfscExtBusinessException("18000", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u5165\u53c2\u5bf9\u5e94\u5f85\u5f00\u7968\u7ed3\u679c\u67e5\u8be2\u4e3a\u7a7a");
            }
            orderInfos = this.moveOrderInfosToVO(payPurchaseOrderInfoPOs);
            groupWay = reqBO.getGroupWay();
        } else {
            if (null == reqBO.getSupplierNo()) {
                throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u4f9b\u5e94\u5546\u7f16\u53f7[supplierNo]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == reqBO.getSelectAllFlag()) {
                throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u662f\u5426\u5168\u9009\u6807\u8bc6[selectAllFlag]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            groupWay = reqBO.getGroupWay();
            if (!(GROUPWAY_NOSPLIT.equals(groupWay) || GROUPWAY_PURUNIT.equals(groupWay) || GROUPWAY_ORDER.equals(groupWay))) {
                throw new PfscExtBusinessException("0001", "\u5206\u7ec4\u65b9\u5f0f\u4e0d\u6b63\u786e");
            }
            if (!SELECT_ALL_YES.equalsIgnoreCase(reqBO.getSelectAllFlag()) && !SELECT_ALL_NO.equalsIgnoreCase(reqBO.getSelectAllFlag())) {
                throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u5168\u9009\u6807\u8bc6[selectAllFlag]\u53ea\u80fd\u8f93\u5165Y\u6216N");
            }
            if (SELECT_ALL_YES.equalsIgnoreCase(reqBO.getSelectAllFlag())) {
                PayPurchaseOrderInfoVO payPurchaseOrderInfoVO = new PayPurchaseOrderInfoVO();
                payPurchaseOrderInfoVO.setSource(reqBO.getSource());
                payPurchaseOrderInfoVO.setPurchaseOrderCode(reqBO.getPurchaseOrderCode());
                payPurchaseOrderInfoVO.setExtOrderId(reqBO.getExtOrderId());
                payPurchaseOrderInfoVO.setSupplierNo(reqBO.getSupplierNo());
                payPurchaseOrderInfoVO.setOrderDateStart(reqBO.getOrderDateStart());
                payPurchaseOrderInfoVO.setOrderDateEnd(reqBO.getOrderDateEnd());
                payPurchaseOrderInfoVO.setRecvDateStart(reqBO.getRecvDateStart());
                payPurchaseOrderInfoVO.setOrderCodes(reqBO.getOrderCodes());
                payPurchaseOrderInfoVO.setRecvDateEnd(reqBO.getRecvDateEnd());
                if (OrderSource.ELECTRIC_MARKET.getCode().equals(reqBO.getSource())) {
                    payPurchaseOrderInfoVO.setReconcilitionStatus(reqBO.getReconcilitionStatus());
                }
                payPurchaseOrderInfoVO.setOrderBy("orderAmt asc");
                payPurchaseOrderInfoVO.setPurchaserId(reqBO.getPurchaserId());
                if (OrderSource.ELECTRIC_MARKET.getCode().equals(reqBO.getSource())) {
                    payPurchaseOrderInfoVO.setPurchaseSaleType(reqBO.getPurchaseSaleType());
                }
                if ("0".equals(reqBO.getIsProfessionalOrgExt())) {
                    payPurchaseOrderInfoVO.setOperUnitNo(reqBO.getCompanyId());
                    payPurchaseOrderInfoVO.setPurchaseNo(reqBO.getPurchaseNo());
                    if (reqBO.getIsByApply() != null && 1 != reqBO.getIsByApply()) {
                        payPurchaseOrderInfoVO.setBusiModel(BusiModel.TRADE_MODEL.getCode());
                    }
                } else {
                    payPurchaseOrderInfoVO.setPurchaseNo(reqBO.getCompanyId());
                    if (reqBO.getIsByApply() != null && reqBO.getIsByApply() != 1) {
                        payPurchaseOrderInfoVO.setBusiModel(BusiModel.MATCH_UP_MODEL.getCode());
                    }
                }
                if (null != purchaserId) {
                    payPurchaseOrderInfoVO.setPurchaserId(purchaserId);
                }
                if ((payPurchaseOrderInfoPOs = this.payPurchaseOrderInfoMapper.getListExt(payPurchaseOrderInfoVO)).isEmpty()) {
                    throw new PfscExtBusinessException("18000", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u5165\u53c2\u5bf9\u5e94\u5f85\u5f00\u7968\u7ed3\u679c\u67e5\u8be2\u4e3a\u7a7a");
                }
                orderInfos = this.moveOrderInfosToVO(payPurchaseOrderInfoPOs);
            } else if (SELECT_ALL_NO.equalsIgnoreCase(reqBO.getSelectAllFlag())) {
                if (null == reqBO.getOrderInfos()) {
                    throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u975e\u5168\u9009\u65f6\uff0c\u8ba2\u5355\u5217\u8868\u4e0d\u5f97\u4e3a\u7a7a");
                }
                orderInfos = reqBO.getOrderInfos();
            }
        }
        if (CollectionUtils.isEmpty(orderInfos)) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u8ba2\u5355");
        }
        String purchaseSaleType = ((OrderInfoVO)orderInfos.get(0)).getPurchaseSaleType();
        Integer maxOrderNumber = reqBO.getMaxOrderNumber();
        if (maxOrderNumber > MAX_ORDER_NUM) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u4e00\u5f20\u5f00\u7968\u901a\u77e5\u5355\u6700\u5927\u5141\u8bb8\u8ba2\u5355\u6570\u91cf\u4e3a300\u6761");
        }
        BigDecimal maxOrderAmt = new BigDecimal(reqBO.getMaxOrderAmt());
        if (maxOrderAmt.compareTo(new BigDecimal(MAX_ORDER_AMT)) > 0) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u4e00\u5f20\u5f00\u7968\u901a\u77e5\u5355\u6700\u5927\u5141\u8bb8\u5f00\u7968\u91d1\u989d\u4e3a500\u4e07\u5143");
        }
        List<List<OrderInfoVO>> invoices = this.busiNotificationSplitService.getSplitResult(orderInfos, maxOrderNumber, groupWay, maxOrderAmt);
        LinkedList<BillNotificationInfoExt> notifications = new LinkedList<BillNotificationInfoExt>();
        String batchNo = this.generateSeqNoFormated(new SimpleDateFormat("yyyyMMdd").format(new Date()));
        for (List<OrderInfoVO> singleInvoice : invoices) {
            BigDecimal sumAmt = BigDecimal.ZERO;
            for (OrderInfoVO orderInfoVO : singleInvoice) {
                sumAmt = sumAmt.add(orderInfoVO.getOrderAmt());
            }
            Date now = new Date();
            String notifyNo = this.billSNService.getSnAsString(BillType.INVOICE_NOTIFYCATION);
            BillNotificationInfoExt notifyInfo = new BillNotificationInfoExt();
            notifyInfo.setNotificationNo(notifyNo);
            notifyInfo.setAmt(sumAmt);
            notifyInfo.setApplyDate(now);
            notifyInfo.setOperNo(reqBO.getCompanyId());
            notifyInfo.setSource(String.valueOf(reqBO.getSource()));
            notifyInfo.setSupplierNo(reqBO.getSupplierNo());
            notifyInfo.setUserId(reqBO.getUserId());
            notifyInfo.setDrawerName(reqBO.getUsername());
            notifyInfo.setAddr(reqBO.getInvoiceInfo().getAddress());
            notifyInfo.setBankAccNo(reqBO.getInvoiceInfo().getAccount());
            notifyInfo.setBankName(reqBO.getInvoiceInfo().getBank());
            notifyInfo.setInvoceName(reqBO.getInvoiceInfo().getInvoiceTitle());
            notifyInfo.setInvoceType(reqBO.getInvoiceInfo().getInvoiceType());
            if (OrderSource.ELECTRIC_MARKET.getCode().equals(reqBO.getSource())) {
                notifyInfo.setInvoiceStatus(NotificationInvoiceStatus.NO_SUBMITED.getCode());
            } else {
                notifyInfo.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
            }
            notifyInfo.setPhone(reqBO.getInvoiceInfo().getPhone());
            notifyInfo.setTaxNo(reqBO.getInvoiceInfo().getTaxpayerId());
            notifyInfo.setAddrDesc(reqBO.getMailAddrInfo().getAddrDesc());
            notifyInfo.setProvince(reqBO.getMailAddrInfo().getProvince());
            notifyInfo.setCity(reqBO.getMailAddrInfo().getCity());
            notifyInfo.setCounty(reqBO.getMailAddrInfo().getCounty());
            notifyInfo.setTown(reqBO.getMailAddrInfo().getTown());
            notifyInfo.setProvId(reqBO.getMailAddrInfo().getProvId());
            notifyInfo.setCityId(reqBO.getMailAddrInfo().getCityId());
            notifyInfo.setCountyId(reqBO.getMailAddrInfo().getCountyId());
            notifyInfo.setTownId(reqBO.getMailAddrInfo().getTownId());
            notifyInfo.setCompany(reqBO.getMailAddrInfo().getCompany());
            notifyInfo.setMobile(reqBO.getMailAddrInfo().getTel());
            notifyInfo.setTel(reqBO.getMailAddrInfo().getSpecialPlane());
            notifyInfo.setName(reqBO.getMailAddrInfo().getName());
            notifyInfo.setPostCode(reqBO.getMailAddrInfo().getPostCode());
            notifyInfo.setBatchNo(batchNo);
            notifyInfo.setPurchaseSaleType(purchaseSaleType);
            notifyInfo.setStartOrgId(String.valueOf(reqBO.getOrgId()));
            notifyInfo.setIsPay(1);
            notifyInfo.setDrawerId(reqBO.getUserId());
            notifyInfo.setDrawerName(reqBO.getUsername());
            int insert = this.billNotificationInfoMapper.insert(notifyInfo);
            if (insert < 1) {
                throw new PfscExtBusinessException("18000", "\u751f\u6210\u5f00\u7968\u901a\u77e5\u4fe1\u606f\u5f02\u5e38");
            }
            LinkedList<String> orderIdCombStr = new LinkedList<String>();
            for (OrderInfoVO singleOrder : singleInvoice) {
                PayPurchaseOrderInfo payOrderInfo = new PayPurchaseOrderInfo();
                payOrderInfo.setOrderId(Long.valueOf(singleOrder.getOrderId()));
                payOrderInfo.setInspectionId(Long.valueOf(singleOrder.getInspectionId()));
                payOrderInfo.setNotificationNo(notifyNo);
                payOrderInfo.setOrderStatus(OrderStatus.APPLIED.getCode());
                payOrderInfo.setPayModel(reqBO.getPayModel());
                int update = this.payPurchaseOrderInfoMapper.updateByPKUnsent(payOrderInfo);
                if (update < 1) {
                    throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38");
                }
                orderIdCombStr.add(singleOrder.getExtOrderId());
                PayItemInfo item = new PayItemInfo();
                item.setOrderId(Long.valueOf(singleOrder.getOrderId()));
                item.setInspectionId(Long.valueOf(singleOrder.getInspectionId()));
                item.setNotificationNo(notifyNo);
                item.setItemStatus(OrderStatus.APPLIED.getCode());
                int update1 = this.payItemInfoMapper.updateByPKUnsent(item);
                if (update1 >= 1) continue;
                throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u91c7\u8d2d\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u5f02\u5e38");
            }
            notifyInfo.setOrderIds(orderIdCombStr);
            notifications.add(notifyInfo);
        }
        BusiNotificationRspBO rspBO = new BusiNotificationRspBO();
        rspBO.setBatchNo(batchNo);
        if (OrderSource.ELECTRIC_MARKET.getCode().equals(reqBO.getSource())) {
            NotificationSendRequestReqBO notificationSendRequestReqBO = new NotificationSendRequestReqBO();
            notificationSendRequestReqBO.setBatchNo(batchNo);
            notificationSendRequestReqBO.setCompanyId(reqBO.getCompanyId());
            this.notificationSendRequestService.processPushInfo(notificationSendRequestReqBO);
        }
        return rspBO;
    }

    private List<OrderInfoVO> moveOrderInfosToVO(List<PayPurchaseOrderInfo> orderInfos) {
        LinkedList<OrderInfoVO> infos = new LinkedList<OrderInfoVO>();
        for (PayPurchaseOrderInfo singleInfo : orderInfos) {
            OrderInfoVO singleVO = new OrderInfoVO();
            singleVO.setConfirmDate(singleInfo.getRecvDate());
            singleVO.setInspectionId(String.valueOf(singleInfo.getInspectionId()));
            singleVO.setLastConfirmDate(singleInfo.getRecvDate());
            singleVO.setOrderAmt(singleInfo.getOrderAmt());
            singleVO.setOrderCreateDate(singleInfo.getOrderDate());
            singleVO.setOrderCreator(singleInfo.getPurchaserName());
            singleVO.setOrderId(String.valueOf(singleInfo.getOrderId()));
            singleVO.setExtOrderId(singleInfo.getExtOrderId());
            singleVO.setOrderStatus(singleInfo.getOrderStatus());
            singleVO.setOrderType(singleInfo.getOrderType());
            singleVO.setPurchaseNo(singleInfo.getPurchaseNo());
            singleVO.setPurchaseProjectId(singleInfo.getPurchaseProjectId());
            singleVO.setPurchaseOrderCode(singleInfo.getPurchaseOrderCode());
            singleVO.setSupplierNo(singleInfo.getSupplierNo());
            singleVO.setPurchaseSaleType(singleInfo.getPurchaseSaleType());
            singleVO.setSource(singleInfo.getSource());
            PayItemInfoVO payItemInfoVO = new PayItemInfoVO();
            payItemInfoVO.setItemStatus(OrderStatus.NO_APPLY.getCode());
            payItemInfoVO.setInspectionId(singleInfo.getInspectionId());
            List<PayItemInfo> itemInfos = this.payItemInfoMapper.selectBy(payItemInfoVO);
            if (itemInfos.isEmpty()) {
                throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u7f16\u53f7\uff1a" + singleInfo.getPurchaseOrderCode() + "\u6ca1\u6709\u5546\u54c1\u660e\u7ec6");
            }
            LinkedList<OrderItemVO> itemVOs = new LinkedList<OrderItemVO>();
            for (PayItemInfo itemInfo : itemInfos) {
                OrderItemVO vo = new OrderItemVO();
                vo.setItemName(itemInfo.getItemName());
                vo.setSpec(itemInfo.getSpec());
                vo.setModel(itemInfo.getModel());
                vo.setUnit(itemInfo.getUnitName());
                vo.setUnitId(itemInfo.getUnitId());
                vo.setQuantity(itemInfo.getQuantity());
                vo.setSalePrice(itemInfo.getPurchaseUnitPrice());
                vo.setSumTaxPrice(itemInfo.getUntaxAmt().add(itemInfo.getTaxAmt()));
                itemVOs.add(vo);
            }
            singleVO.setItemList(itemVOs);
            infos.add(singleVO);
        }
        return infos;
    }

    private String generateSeqNoFormated(String prefix) {
        String withoutPrefix;
        prefix = StringUtils.hasText((String)prefix) ? prefix : "";
        int lengthWithoutPrefix = 12 - prefix.length();
        try {
            withoutPrefix = String.format("%0" + lengthWithoutPrefix + "d", this.billNotificationBatchNoSeq.nextId());
        }
        catch (SQLException e) {
            LOGGER.debug("\u751f\u6210\u5e8f\u5217\u53f7\u5f02\u5e38" + e);
            throw new PfscExtBusinessException("18000", "\u751f\u6210\u6279\u6b21\u53f7\u5f02\u5e38");
        }
        return prefix + withoutPrefix;
    }
}

