/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.BusiQryOutstockInfoDetailService;
import com.tydic.pfscext.api.busi.bo.BusiQryOutstockInfoDetailReqBO;
import com.tydic.pfscext.api.busi.bo.BusiQryOutstockInfoDetailRspBO;
import com.tydic.pfscext.api.busi.bo.OutstockDetailBO;
import com.tydic.pfscext.dao.OutstockDetailMapper;
import com.tydic.pfscext.dao.po.OutstockDetail;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiQryOutstockInfoDetailService.class)
public class BusiQryOutstockInfoDetailServiceImpl
implements BusiQryOutstockInfoDetailService {
    private static final Logger log = LoggerFactory.getLogger(BusiQryOutstockInfoDetailServiceImpl.class);
    @Autowired
    private OutstockDetailMapper outstockDetailMapper;

    public BusiQryOutstockInfoDetailRspBO qryOutstockInfoDetail(BusiQryOutstockInfoDetailReqBO reqBO) {
        if (reqBO.getSkuId() == null) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u51fa\u5e93\u5355\u67e5\u770b\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getSaleUnitPrice() == null) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u51fa\u5e93\u5355\u67e5\u770b\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList<OutstockDetailBO> outstockDetailBOList = new ArrayList<OutstockDetailBO>();
        BusiQryOutstockInfoDetailRspBO rspBO = new BusiQryOutstockInfoDetailRspBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        OutstockDetail outstockDetail = new OutstockDetail();
        try {
            boolean flag = true;
            outstockDetail.setSkuId(reqBO.getSkuId());
            outstockDetail.setSaleUnitPrice(reqBO.getSaleUnitPrice());
            List<OutstockDetail> outstockDetails = this.outstockDetailMapper.getListByCon(outstockDetail, (Page<Map<String, Object>>)page, "t.OUTSTOCK_DATE");
            for (OutstockDetail bo : outstockDetails) {
                flag = true;
                for (OutstockDetailBO detailBO : outstockDetailBOList) {
                    if (detailBO.getSkuId().longValue() != bo.getSkuId().longValue() || detailBO.getSaleUnitPrice().compareTo(bo.getSaleUnitPrice()) != 0 || !bo.getOutstockNo().equals(detailBO.getOutstockNo())) continue;
                    detailBO.getQuantity().add(bo.getQuantity());
                    flag = false;
                    break;
                }
                if (!flag) continue;
                OutstockDetailBO entryInfoDetailBO = new OutstockDetailBO();
                BeanUtils.copyProperties((Object)bo, (Object)entryInfoDetailBO);
                outstockDetailBOList.add(entryInfoDetailBO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PfscExtBusinessException("\u5931\u8d25", "\u51fa\u5e93\u5355\u67e5\u770b" + e.getMessage());
        }
        rspBO.setRows(outstockDetailBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }
}

