/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.BusiQueryEntryInvoiceService;
import com.tydic.pfscext.api.busi.bo.EntryInvoiceInfoRepBO;
import com.tydic.pfscext.api.busi.bo.EntryInvoiceInfoRspBO;
import com.tydic.pfscext.base.PfscExtRspPageBaseBO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayInvoiceInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.EntryInvoicePO;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.service.busi.impl.QueryEntryInfoServiceImpl;
import com.tydic.pfscext.utils.AntiSqlInjectionManage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiQueryEntryInvoiceService.class)
public class BusiQueryEntryInvoiceServiceImpl
implements BusiQueryEntryInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(QueryEntryInfoServiceImpl.class);
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;

    public List<EntryInvoiceInfoRspBO> queryEntryInvoice(String applyNo) {
        ArrayList<EntryInvoiceInfoRspBO> entryInvoiceInfoRspBO = new ArrayList<EntryInvoiceInfoRspBO>();
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5165\u5e93\u5355\u53d1\u7968\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a" + applyNo);
        }
        if (applyNo == null) {
            throw new PfscExtBusinessException("18000", "\u6c47\u603b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<EntryInvoicePO> entryInvoicePO = this.payInvoiceInfoMapper.selectByApplyNo(applyNo);
        if (null == entryInvoicePO || entryInvoicePO.isEmpty()) {
            return entryInvoiceInfoRspBO;
        }
        for (EntryInvoicePO entryInvoicePOs : entryInvoicePO) {
            EntryInvoiceInfoRspBO entryInvoiceInfoRspBOs = new EntryInvoiceInfoRspBO();
            entryInvoicePOs.setPurchaseName(this.organizationInfoService.querySupplierName(entryInvoicePOs.getPurchaseId()));
            entryInvoicePOs.setInvoiceTypeName(this.enumsService.getDescr(InvoiceType.getInstance(entryInvoicePOs.getInvoiceType())));
            if (!StringUtils.hasText((String)entryInvoicePOs.getName())) {
                BillNotificationInfo notification = this.billNotificationInfoMapper.selectByPrimaryKey(entryInvoicePOs.getNotificationNo());
                entryInvoicePOs.setName(notification.getInvoceName());
            }
            BeanUtils.copyProperties((Object)entryInvoicePOs, (Object)entryInvoiceInfoRspBOs);
            if (entryInvoiceInfoRspBOs.getTaxRate() != null && !entryInvoiceInfoRspBOs.getTaxRate().equals("")) {
                entryInvoiceInfoRspBOs.setTaxRate(entryInvoiceInfoRspBOs.getTaxRate() + '%');
            }
            entryInvoiceInfoRspBO.add(entryInvoiceInfoRspBOs);
        }
        logger.info("\u6210\u529f\u67e5\u8be2\u51fa\u6c47\u603b\u5355\u53f7\u5bf9\u5e94\u7684\u53d1\u7968");
        return entryInvoiceInfoRspBO;
    }

    public PfscExtRspPageBaseBO<EntryInvoiceInfoRspBO> queryPageEntryInvoice(EntryInvoiceInfoRepBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5165\u5e93\u5355\u53d1\u7968\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a" + reqBO.getApplyNo() + reqBO.getNotificationNo());
        }
        if (reqBO.getApplyNo() == null || !StringUtils.hasText((String)reqBO.getApplyNo())) {
            throw new PfscExtBusinessException("18000", "\u6c47\u603b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String orderBy = null;
        if (!StringUtils.isEmpty((Object)reqBO.getSortName()) && !StringUtils.isEmpty((Object)reqBO.getSortOrder())) {
            if (AntiSqlInjectionManage.sqlValidate(reqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(reqBO.getSortOrder())) {
                logger.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                throw new PfscExtBusinessException("18000", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            }
            orderBy = reqBO.getSortName() + " " + reqBO.getSortOrder();
        }
        if (!StringUtils.hasText(orderBy)) {
            orderBy = " t1.ENTRY_NO asc,t2.INVOICE_NO asc";
        }
        ArrayList<EntryInvoiceInfoRspBO> entryInvoiceInfoRspBO = new ArrayList<EntryInvoiceInfoRspBO>();
        PfscExtRspPageBaseBO rspPageBO = new PfscExtRspPageBaseBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<EntryInvoicePO> entryInvoicePO = null;
        if (!StringUtils.hasText((String)reqBO.getNotificationNo())) {
            try {
                entryInvoicePO = this.payInvoiceInfoMapper.selectListByApplyNo(reqBO.getApplyNo(), (Page<Map<String, Object>>)page, orderBy);
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u5165\u5e93\u5355\u53d1\u7968\u5931\u8d25\uff0c\u6c47\u603b\u7f16\u53f7\u4e3a\uff1a" + reqBO.getApplyNo(), (Throwable)e);
                throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u5165\u5e93\u5355\u53d1\u7968\u5931\u8d25");
            }
            if (null == entryInvoicePO || entryInvoicePO.isEmpty()) {
                logger.error("\u627e\u4e0d\u5230\u6c47\u603b\u5355\u53f7\u5bf9\u5e94\u7684\u53d1\u7968\u8bb0\u5f55\uff0c\u6c47\u603b\u5355\u53f7\u4e3a\uff1a" + reqBO.getApplyNo());
                return rspPageBO;
            }
            for (EntryInvoicePO entryInvoicePOs : entryInvoicePO) {
                EntryInvoiceInfoRspBO entryInvoiceInfoRspBOs = new EntryInvoiceInfoRspBO();
                entryInvoicePOs.setPurchaseName(this.organizationInfoService.querySupplierName(entryInvoicePOs.getPurchaseId()));
                entryInvoicePOs.setInvoiceTypeName(this.enumsService.getDescr(InvoiceType.getInstance(entryInvoicePOs.getInvoiceType())));
                if (!StringUtils.hasText((String)entryInvoicePOs.getName())) {
                    BillNotificationInfo notification = this.billNotificationInfoMapper.selectByPrimaryKey(entryInvoicePOs.getNotificationNo());
                    entryInvoicePOs.setName(notification.getInvoceName());
                }
                BeanUtils.copyProperties((Object)entryInvoicePOs, (Object)entryInvoiceInfoRspBOs);
                entryInvoiceInfoRspBO.add(entryInvoiceInfoRspBOs);
            }
            rspPageBO.setRows(entryInvoiceInfoRspBO);
            rspPageBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspPageBO.setTotal(Integer.valueOf(page.getTotalPages()));
            rspPageBO.setPageNo(Integer.valueOf(page.getPageNo()));
            return rspPageBO;
        }
        try {
            entryInvoicePO = this.payInvoiceInfoMapper.getListByNotificationNo(reqBO.getNotificationNo(), (Page<Map<String, Object>>)page, orderBy);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5165\u5e93\u5355\u53d1\u7968\u5931\u8d25\uff0c\u53d1\u7968\u901a\u77e5\u5355\u7f16\u53f7\u4e3a\uff1a" + reqBO.getNotificationNo(), (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u5165\u5e93\u5355\u53d1\u7968\u5931\u8d25");
        }
        if (null == entryInvoicePO || entryInvoicePO.isEmpty()) {
            logger.error("\u627e\u4e0d\u5230\u53d1\u7968\u901a\u77e5\u5355\u5bf9\u5e94\u7684\u53d1\u7968\u8bb0\u5f55\uff0c\u53d1\u7968\u901a\u77e5\u5355\u4e3a\uff1a" + reqBO.getNotificationNo());
            return rspPageBO;
        }
        for (EntryInvoicePO entryInvoicePOs : entryInvoicePO) {
            EntryInvoiceInfoRspBO entryInvoiceInfoRspBOs = new EntryInvoiceInfoRspBO();
            entryInvoicePOs.setPurchaseName(this.organizationInfoService.querySupplierName(entryInvoicePOs.getPurchaseId()));
            entryInvoicePOs.setInvoiceTypeName(this.enumsService.getDescr(InvoiceType.getInstance(entryInvoicePOs.getInvoiceType())));
            if (!StringUtils.hasText((String)entryInvoicePOs.getName())) {
                BillNotificationInfo notification = this.billNotificationInfoMapper.selectByPrimaryKey(entryInvoicePOs.getNotificationNo());
                entryInvoicePOs.setName(notification.getInvoceName());
            }
            BeanUtils.copyProperties((Object)entryInvoicePOs, (Object)entryInvoiceInfoRspBOs);
            entryInvoiceInfoRspBO.add(entryInvoiceInfoRspBOs);
        }
        rspPageBO.setRows(entryInvoiceInfoRspBO);
        rspPageBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspPageBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPageBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspPageBO;
    }
}

