/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiUpdateTaxCatCodeService;
import com.tydic.pfscext.api.busi.bo.BusiUpdateTaxCatCodeReqBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiUpdateTaxCatCodeServiceImpl
implements BusiUpdateTaxCatCodeService {
    private static final Logger logger = LoggerFactory.getLogger(BusiUpdateTaxCatCodeServiceImpl.class);
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;

    public PfscExtRspBaseBO updateTaxCatCode(BusiUpdateTaxCatCodeReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u66f4\u65b0\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO != null && StringUtils.hasText((String)reqBO.getTaxCatCode())) {
            Long taxCatCode;
            try {
                taxCatCode = Long.parseLong(reqBO.getTaxCatCode());
            }
            catch (Exception e) {
                logger.error("\u683c\u5f0f\u5316\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\uff1a" + reqBO.getTaxCatCode() + "\u5931\u8d25", (Throwable)e);
                throw new PfscExtBusinessException("18000", "\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u5fc5\u987b\u662f\u6570\u5b57\u4e14\u4e0d\u80fd\u8fc7\u957f");
            }
            SaleItemInfo saleItemInfo = new SaleItemInfo();
            saleItemInfo.setSeq(reqBO.getSeq());
            saleItemInfo.setTaxCatCode(taxCatCode);
            this.saleItemInfoMapper.updateByPrimaryKeyInNewTransaction(saleItemInfo);
        }
        return new PfscExtRspBaseBO();
    }
}

