/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.BusiBillingModifyConfirmService;
import com.tydic.pfscext.api.busi.bo.BusiBillingModifyConfirmReqBO;
import com.tydic.pfscext.api.busi.bo.BusiBillingModifyConfirmRspBO;
import com.tydic.pfscext.api.busi.bo.InvoiceInfoReqBO;
import com.tydic.pfscext.dao.BillDetailInfoMapper;
import com.tydic.pfscext.dao.BillMergeInfoMapper;
import com.tydic.pfscext.dao.BillSummaryInfoMapper;
import com.tydic.pfscext.dao.InvoiceInfoTempMapper;
import com.tydic.pfscext.dao.OriginalDocumentsInfoMapper;
import com.tydic.pfscext.dao.PriceSettlementSummaryInfoMapper;
import com.tydic.pfscext.dao.po.BillMergeInfo;
import com.tydic.pfscext.dao.po.InvoiceInfoTemp;
import com.tydic.pfscext.dao.vo.GetOriginalDocumentsInfoVO;
import com.tydic.pfscext.enums.FscBillStatus;
import com.tydic.pfscext.enums.NInvoiceType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiBillingModifyConfirmService.class)
public class BusiBillingModifyConfirmServiceImpl
implements BusiBillingModifyConfirmService {
    private static final Logger log = LoggerFactory.getLogger(BusiBillingModifyConfirmServiceImpl.class);
    private static final String BILLING = "1";
    private static final String MODIFY = "2";
    private static final String CONFIRM = "3";
    public static final String PREFIX = "HBDH";
    @Autowired
    private InvoiceInfoTempMapper invoiceInfoTempMapper;
    @Autowired
    private BillMergeInfoMapper billMergeInfoMapper;
    @Autowired
    private OriginalDocumentsInfoMapper originalDocumentsInfoMapper;
    @Autowired
    private PriceSettlementSummaryInfoMapper priceSettlementSummaryInfoMapper;
    @Autowired
    private BillSummaryInfoMapper billSummaryInfoMapper;
    @Autowired
    private BillDetailInfoMapper billDetailInfoMapper;

    public BusiBillingModifyConfirmRspBO billingModifyConfirm(BusiBillingModifyConfirmReqBO reqBO) {
        log.info("\u91c7\u8d2d\u5165\u5e93\u5f00\u7968\uff0c\u4fee\u6539\uff0c\u786e\u8ba4\u5165\u53c2\uff1a{}", (Object)reqBO);
        this.billingVerification(reqBO);
        if (BILLING.equals(reqBO.getOperationType()) || CONFIRM.equals(reqBO.getOperationType())) {
            this.billingOrConfirm(reqBO);
        } else if (MODIFY.equals(reqBO.getOperationType())) {
            this.modify(reqBO);
        }
        BusiBillingModifyConfirmRspBO rspBO = new BusiBillingModifyConfirmRspBO();
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void billingOrConfirm(BusiBillingModifyConfirmReqBO reqBO) {
        String mergeNO = BILLING.equals(reqBO.getOperationType()) ? this.getMergeNO() : reqBO.getMergeDocumentNo();
        List documentNos = reqBO.getDocumentNos();
        List<GetOriginalDocumentsInfoVO> getOriginalDocumentsInfoVOS = this.originalDocumentsInfoMapper.selectUnionListByDocumentNos(documentNos);
        List filterByBusiSetMethod = getOriginalDocumentsInfoVOS.stream().filter(info -> info.getBusiSettMethod().equals(((GetOriginalDocumentsInfoVO)getOriginalDocumentsInfoVOS.get(0)).getBusiSettMethod())).collect(Collectors.toList());
        if (getOriginalDocumentsInfoVOS.size() != filterByBusiSetMethod.size()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u91c7\u8d2d\u65b9\u5f00\u7968\u65f6\uff0c\u7ed3\u7b97\u5355\u4f4d\u5fc5\u987b\u4e00\u81f4");
        }
        List<String> documentNoList = getOriginalDocumentsInfoVOS.stream().map(GetOriginalDocumentsInfoVO::getDocumentNo).collect(Collectors.toList());
        InvoiceInfoReqBO invoiceInfoReqBO = reqBO.getInvoiceInfoReqBO();
        BillMergeInfo billMergeInfo = new BillMergeInfo();
        List amtList = getOriginalDocumentsInfoVOS.stream().map(GetOriginalDocumentsInfoVO::getSetAmt).collect(Collectors.toList());
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (String amt : amtList) {
            if (!StringUtils.hasText((String)amt)) continue;
            BigDecimal bigDecimal = new BigDecimal(amt);
            totalAmt = totalAmt.add(bigDecimal);
        }
        billMergeInfo.setTotalAmt(String.valueOf(totalAmt));
        billMergeInfo.setMergeSetNo(mergeNO);
        billMergeInfo.setSetUnitCode(getOriginalDocumentsInfoVOS.get(0).getBusiSettMethod());
        billMergeInfo.setTotalIncoicedNum(invoiceInfoReqBO.getActualInvoicedQuantity());
        billMergeInfo.setInvoiceType(invoiceInfoReqBO.getInvoceType());
        if (null != invoiceInfoReqBO.getCreditDate()) {
            billMergeInfo.setCreditDate(invoiceInfoReqBO.getCreditDate());
        }
        if (null != invoiceInfoReqBO.getDArriveDate()) {
            billMergeInfo.setDArriveDate(invoiceInfoReqBO.getDArriveDate());
        }
        if (null != invoiceInfoReqBO.getInvoiceIssuanceDate()) {
            billMergeInfo.setInvoiceIssuanceDate(invoiceInfoReqBO.getInvoiceIssuanceDate());
        }
        if (BILLING.equals(reqBO.getIsProfessionalOrgExt())) {
            billMergeInfo.setInvoiceStatus(FscBillStatus.INVOICED.getCode());
        } else {
            billMergeInfo.setInvoiceStatus(FscBillStatus.ENTERED.getCode());
        }
        billMergeInfo.setBillType(NInvoiceType.getInstance(reqBO.getType()).getCode());
        billMergeInfo.setEffectiveState(BILLING);
        InvoiceInfoTemp invoiceInfoTemp = new InvoiceInfoTemp();
        BeanUtils.copyProperties((Object)invoiceInfoReqBO, (Object)invoiceInfoTemp);
        invoiceInfoTemp.setInoviceInfoId(mergeNO);
        invoiceInfoTemp.setEffectiveState(BILLING);
        invoiceInfoTemp.setBillType(reqBO.getType());
        if (BILLING.equals(reqBO.getIsProfessionalOrgExt())) {
            this.originalDocumentsInfoMapper.updateByDocumentNos(documentNoList, mergeNO, FscBillStatus.INVOICED.getCode());
            this.priceSettlementSummaryInfoMapper.updateByDocumentNos(documentNoList, mergeNO, FscBillStatus.INVOICED.getCode());
            this.billSummaryInfoMapper.updateByDocumentNos(documentNoList, FscBillStatus.INVOICED.getCode());
            this.billDetailInfoMapper.updateByDocumentNos(documentNoList, FscBillStatus.INVOICED.getCode());
        } else {
            this.originalDocumentsInfoMapper.updateByDocumentNos(documentNoList, mergeNO, FscBillStatus.ENTERED.getCode());
            this.priceSettlementSummaryInfoMapper.updateByDocumentNos(documentNoList, mergeNO, FscBillStatus.ENTERED.getCode());
            this.billSummaryInfoMapper.updateByDocumentNos(documentNoList, FscBillStatus.ENTERED.getCode());
            this.billDetailInfoMapper.updateByDocumentNos(documentNoList, FscBillStatus.ENTERED.getCode());
        }
        if (BILLING.equals(reqBO.getOperationType())) {
            int insert = this.billMergeInfoMapper.insert(billMergeInfo);
            if (insert < 1) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u4fdd\u5b58\u5f00\u7968\u4fe1\u606f\u5931\u8d25");
            }
            int insert1 = this.invoiceInfoTempMapper.insert(invoiceInfoTemp);
            if (insert1 < 1) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u4fdd\u5b58\u53d1\u7968\u4e34\u65f6\u4fe1\u606f\u5931\u8d25");
            }
        } else {
            int i = this.billMergeInfoMapper.updateByMergrNo(billMergeInfo);
            if (i < 1) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u5f00\u7968\u4fe1\u606f\u5931\u8d25");
            }
            int i1 = this.invoiceInfoTempMapper.updateByMergrNo(invoiceInfoTemp);
            if (i1 < 1) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u53d1\u7968\u4e34\u65f6\u4fe1\u606f\u5931\u8d25");
            }
        }
    }

    private void modify(BusiBillingModifyConfirmReqBO reqBO) {
        String mergeNO = reqBO.getMergeDocumentNo();
        InvoiceInfoTemp invoiceInfoTemp = new InvoiceInfoTemp();
        InvoiceInfoReqBO invoiceInfoReqBO = reqBO.getInvoiceInfoReqBO();
        BeanUtils.copyProperties((Object)invoiceInfoReqBO, (Object)invoiceInfoTemp);
        invoiceInfoTemp.setInoviceInfoId(mergeNO);
        invoiceInfoTemp.setEffectiveState(BILLING);
        invoiceInfoTemp.setBillType(reqBO.getType());
        this.invoiceInfoTempMapper.updateByMergrNo(invoiceInfoTemp);
    }

    private String getMergeNO() {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            String dateL = Long.valueOf(df.format(new Date())).toString();
            String maxNum = this.billMergeInfoMapper.selectMaxPayAbleNoNum(PREFIX + dateL);
            String num = "0001";
            if (maxNum != null && !"".equals(maxNum)) {
                num = String.format("%04d", Integer.parseInt(maxNum) + 1);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(PREFIX).append(dateL).append(num);
            return sb.toString();
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("0001", "\u5408\u5e76\u5355\u53f7\u751f\u6210\u5931\u8d25");
        }
    }

    private void billingVerification(BusiBillingModifyConfirmReqBO reqBO) {
        InvoiceInfoReqBO invoiceInfoReqBO;
        if (null == reqBO.getType()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u91c7\u8d2d\u8ba2\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperationType()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getDocumentNos().size() == 0) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u91c7\u8d2d\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!BILLING.equals(reqBO.getOperationType()) && null == reqBO.getMergeDocumentNo()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u3010\u4fee\u6539\u3011\u6216\u3010\u786e\u8ba4\u3011\u65f6\u5408\u5e76\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceInfoReqBO()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u53d1\u7968\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (BILLING.equals(reqBO.getIsProfessionalOrgExt())) {
            if (MODIFY.equals(reqBO.getOperationType())) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u91c7\u8d2d\u5546\u53ea\u80fd\u3010\u5f00\u7968\u3011\u548c\u3010\u786e\u8ba4\u3011");
            }
        } else if (CONFIRM.equals(reqBO.getOperationType())) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u4f9b\u5e94\u5546\u53ea\u80fd\u3010\u5f00\u7968\u3011\u548c \u3010\u4fee\u6539\u3011");
        }
        if (null == (invoiceInfoReqBO = reqBO.getInvoiceInfoReqBO()).getName()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getTaxpayerId()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getAddress()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getMobile()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getBankName()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u5f00\u6237\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getBankAccNo()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u94f6\u884c\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getActualInvoicedQuantity()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u5b9e\u9645\u5f00\u7968\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getTotalAmtTax()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u6c47\u603b\u91d1\u989d\uff08\u542b\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getTotalAmt()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u6c47\u603b\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getTaxRate()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getInvoceType()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfoReqBO.getInvoceCode()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u53d1\u7968\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (BILLING.equals(reqBO.getIsProfessionalOrgExt())) {
            if (null == invoiceInfoReqBO.getCreditDate()) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u5165\u8d26\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getDArriveDate()) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u7968\u5230\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getInvoiceIssuanceDate()) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u53d1\u7968\u5f00\u5177\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getInvoceNum()) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u53d1\u7968\u8f93\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getReasonLossNum()) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u5408\u7406\u635f\u8017\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getInputTaxType()) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u8fdb\u9879\u7a0e\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getSettlementType()) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getPayType()) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getAnnexNum()) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u9644\u4ef6\u5f20\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getPurchaseName()) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u91c7\u8d2d\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == invoiceInfoReqBO.getSourceContractNum()) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u6765\u6e90\u5408\u540c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

