/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.BusiGetBillingRecordService;
import com.tydic.pfscext.api.busi.bo.BillingRecordRspBO;
import com.tydic.pfscext.api.busi.bo.BusiGetBillingRecordReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetBillingRecordRspBO;
import com.tydic.pfscext.api.busi.vo.BillMergeInfoVO;
import com.tydic.pfscext.dao.BillMergeInfoMapper;
import com.tydic.pfscext.dao.OriginalDocumentsInfoMapper;
import com.tydic.pfscext.dao.po.BillMergeInfo;
import com.tydic.pfscext.dao.vo.GetOriginalDocumentsInfoVO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiGetBillingRecordService.class)
public class BusiGetBillingRecordServiceImpl
implements BusiGetBillingRecordService {
    private static final Logger log = LoggerFactory.getLogger(BusiGetBillingRecordServiceImpl.class);
    @Autowired
    private BillMergeInfoMapper billMergeInfoMapper;
    @Autowired
    private OriginalDocumentsInfoMapper originalDocumentsInfoMapper;

    public BusiGetBillingRecordRspBO getBillingRecord(BusiGetBillingRecordReqBO reqBO) {
        log.info("\u67e5\u8be2\u5f00\u7968\u8bb0\u5f55\u5165\u53c2\uff1a{}", (Object)reqBO);
        if ("".equals(reqBO.getType()) || null == reqBO.getType()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u91c7\u8d2d\u5165\u5e93\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("1".equals(reqBO.getIsProfessionalOrgExt()) && null == reqBO.getPurDeptId()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u91c7\u8d2d\u90e8\u95e8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!"1".equals(reqBO.getIsProfessionalOrgExt()) && null == reqBO.getSupplierId()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u4f9b\u5e94\u5546\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!"".equals(reqBO.getDocumentNo()) && null != reqBO.getDocumentNo()) {
            String documentNo = reqBO.getDocumentNo();
            return this.getPageByDocumentNo(documentNo, reqBO.getType());
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<BillMergeInfo> billMergeInfos = this.billMergeInfoMapper.selectPage(reqBO, (Page<Map<String, Object>>)page, reqBO.getType());
        List billingRecordRspBOS = JSON.parseArray((String)JSON.toJSONString(billMergeInfos), BillingRecordRspBO.class);
        List<String> mergeNoList = billMergeInfos.stream().map(BillMergeInfo::getMergeSetNo).collect(Collectors.toList());
        List<GetOriginalDocumentsInfoVO> documentsInfoVOS = this.originalDocumentsInfoMapper.selectUnionListByMergeNos(mergeNoList);
        for (BillingRecordRspBO billMergeInfo : billingRecordRspBOS) {
            List filterByMergerNo = documentsInfoVOS.stream().filter(documentsInfoVO -> billMergeInfo.getMergeSetNo().equals(documentsInfoVO.getBillingRecordNo())).collect(Collectors.toList());
            String jsonString = JSON.toJSONString(filterByMergerNo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            List billMergeInfoVOS = JSON.parseArray((String)jsonString, BillMergeInfoVO.class);
            billMergeInfo.setMergeInfoList(billMergeInfoVOS);
        }
        BusiGetBillingRecordRspBO rspBO = new BusiGetBillingRecordRspBO();
        rspBO.setRows(billingRecordRspBOS);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private BusiGetBillingRecordRspBO getPageByDocumentNo(String documentNo, String billType) {
        String mergeNo = this.originalDocumentsInfoMapper.selectMergeNOByDocumentNo(documentNo, billType);
        if (mergeNo == null) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u4e0d\u5b58\u5728\u7ed3\u7b97\u5355:[" + documentNo + "]");
        }
        BillMergeInfo billMergeInfo = this.billMergeInfoMapper.selectByMergeNO(mergeNo);
        log.info("\u5f00\u7968\u4fe1\u606f\u6c47\u603b\u8868\u8be6\u60c5\uff1a{}", (Object)billMergeInfo);
        List<GetOriginalDocumentsInfoVO> documentsInfoVOS = this.originalDocumentsInfoMapper.selectUnionListByMergeNo(mergeNo);
        log.info("\u91c7\u8d2d\u5165\u5e93\u4fe1\u606f\uff1a{}", documentsInfoVOS);
        BillingRecordRspBO billingRecordRspBO = new BillingRecordRspBO();
        BeanUtils.copyProperties((Object)billMergeInfo, (Object)billingRecordRspBO);
        List billMergeInfoVOS = JSONObject.parseArray((String)JSON.toJSONString(documentsInfoVOS), BillMergeInfoVO.class);
        billingRecordRspBO.setMergeInfoList(billMergeInfoVOS);
        ArrayList<BillingRecordRspBO> billingRecordRspBOS = new ArrayList<BillingRecordRspBO>();
        billingRecordRspBOS.add(billingRecordRspBO);
        BusiGetBillingRecordRspBO rspBO = new BusiGetBillingRecordRspBO();
        rspBO.setRows(billingRecordRspBOS);
        rspBO.setTotal(Integer.valueOf(1));
        rspBO.setRecordsTotal(Integer.valueOf(1));
        rspBO.setPageNo(Integer.valueOf(1));
        return rspBO;
    }
}

