/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.deal.PayOrderStatusService;
import com.tydic.pfscext.api.deal.bo.PayOrderInfoReqBO;
import com.tydic.pfscext.api.deal.bo.PayOrderInfoRspBO;
import com.tydic.pfscext.dao.PayOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayOrderInfoPO;
import com.tydic.pfscext.enums.PayOrderStatus;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=PayOrderStatusService.class)
public class PayOrderStatusServiceImpl
implements PayOrderStatusService {
    private static final Logger logger = LoggerFactory.getLogger(PayOrderStatusServiceImpl.class);
    @Autowired
    private PayOrderInfoMapper payOrderInfoMapper;

    public PayOrderInfoRspBO offPay(PayOrderInfoReqBO reqBO) {
        PayOrderInfoRspBO rspBO = new PayOrderInfoRspBO();
        try {
            logger.info("\u6210\u4ea4\u670d\u52a1\u8d39-\u786e\u8ba4\u7f34\u8d39\u5165\u53c2\uff1a" + reqBO.toString());
            if (null == reqBO) {
                rspBO.setRespCode("0001");
                rspBO.setRespDesc("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (null == reqBO.getPayOrderIds() || reqBO.getPayOrderIds().size() < 1) {
                rspBO.setRespCode("0001");
                rspBO.setRespDesc("\u7f34\u8d39\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            reqBO.setPayChannel("1");
            if (null == reqBO.getPayChannel() || "".equals(reqBO.getPayChannel())) {
                rspBO.setRespCode("0001");
                rspBO.setRespDesc("\u7f34\u8d39\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            PayOrderInfoPO po = new PayOrderInfoPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)po);
            po.setPayOrderId((Long)reqBO.getPayOrderIds().get(0));
            if ("1".equals(reqBO.getPayChannel())) {
                if (null == reqBO.getPayVoucher() || "".equals(reqBO.getPayVoucher())) {
                    rspBO.setRespCode("0001");
                    rspBO.setRespDesc("\u8bf7\u4e0a\u4f20\u7f34\u8d39\u51ed\u8bc1\u540e\u518d\u8bd5");
                    return rspBO;
                }
                po.setPayVoucherName(reqBO.getName());
                po.setPayOrderStatus(PayOrderStatus.PAY_TO_CONFIRM.getCode());
                po.setPayRegisterTime(new Date());
                po.setPayRegisterUserId(reqBO.getUserId());
                po.setPayRegisterUserName(reqBO.getUsername());
            }
            logger.error("PayOrderInfoServiceImpl\u5165\u53c2\uff1a" + po.toString());
            this.payOrderInfoMapper.updateByPrimaryKeySelective(po);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u5931\u8d25");
        }
        return rspBO;
    }

    public PayOrderInfoRspBO payConfirm(PayOrderInfoReqBO reqBO) {
        PayOrderInfoRspBO rspBO = new PayOrderInfoRspBO();
        try {
            logger.info("\u6210\u4ea4\u670d\u52a1\u8d39-\u786e\u8ba4\u7f34\u8d39\u72b6\u6001\u5165\u53c2\uff1a" + reqBO.toString());
            if (null == reqBO) {
                rspBO.setRespCode("0001");
                rspBO.setRespDesc("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (null == reqBO.getPayOrderIds() || reqBO.getPayOrderIds().size() < 1) {
                rspBO.setRespCode("0001");
                rspBO.setRespDesc("\u7f34\u8d39\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            for (Long payOrderId : reqBO.getPayOrderIds()) {
                PayOrderInfoPO po = new PayOrderInfoPO();
                BeanUtils.copyProperties((Object)reqBO, (Object)po);
                po.setPayOrderId(payOrderId);
                po.setPayOrderStatus(PayOrderStatus.CONFIRMED.getCode());
                po.setPayStatusConfirmTime(new Date());
                po.setPayStatusConfirmUserId(reqBO.getUserId());
                po.setPayStatusConfirmUserName(reqBO.getUsername());
                this.payOrderInfoMapper.updateByPrimaryKeySelective(po);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u5931\u8d25");
        }
        return rspBO;
    }
}

