/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.aisino.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.aisino.BusiInvoiceIssueService;
import com.tydic.pfscext.api.aisino.bo.BusiInvoiceIssueReqBO;
import com.tydic.pfscext.api.aisino.bo.BusiInvoiceIssueRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQueryDetailBillApplyInfoApplyRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQueryDetailBillApplyInfoItemRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQueryDetailBillApplyInfoOrderRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQueryDetailBillApplyInfoReqBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.PayInvoiceDetailMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.PayInvoiceDetail;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.ApplyType;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.aisino.api.InvoiceIssueExternalService;
import com.tydic.pfscext.external.aisino.api.bo.BillItemBO;
import com.tydic.pfscext.external.aisino.api.bo.GlobalInfoBO;
import com.tydic.pfscext.external.aisino.api.bo.InvoiceIssueBO;
import com.tydic.pfscext.external.aisino.api.bo.InvoiceIssueExtReqBO;
import com.tydic.pfscext.external.aisino.api.bo.InvoiceIssueExtRspBO;
import com.tydic.pfscext.external.aisino.api.bo.OrderInfoBO;
import com.tydic.pfscext.service.atom.EnumsService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiInvoiceIssueService.class)
public class BusiInvoiceIssueServiceImpl
implements BusiInvoiceIssueService {
    private static final Logger log = LoggerFactory.getLogger(BusiInvoiceIssueServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private InvoiceIssueExternalService invoiceIssueExternalService;
    @Value(value="${authorizationCode:NH873FG4KW}")
    private String authorizationCode;
    @Value(value="${taxCode:913101010000000090}")
    private String taxCode;
    @Autowired
    private PayInvoiceDetailMapper payInvoiceDetailMapper;

    public BusiInvoiceIssueRspBO invoiceIssue(BusiInvoiceIssueReqBO busiInvoiceIssueReqBO) {
        BusiInvoiceIssueRspBO rspBO = new BusiInvoiceIssueRspBO();
        try {
            int count = this.saleOrderInfoMapper.checkOrderStatus(busiInvoiceIssueReqBO.getApplyNoList());
            if (count > 0) {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u4e0a\u6e38\u5b58\u5728\u672a\u83b7\u53d6\u53d1\u7968\u7684\u8ba2\u5355");
                return rspBO;
            }
            for (String applyNo : busiInvoiceIssueReqBO.getApplyNoList()) {
                BusiQueryDetailBillApplyInfoReqBO reqBO = new BusiQueryDetailBillApplyInfoReqBO();
                reqBO.setApplyNo(applyNo);
                BusiQueryDetailBillApplyInfoApplyRspBO applyRspBO = this.queryApply(reqBO);
                InvoiceIssueExtReqBO invoiceIssueExtReqBO = new InvoiceIssueExtReqBO();
                InvoiceIssueBO fpkjxxFptxx = new InvoiceIssueBO();
                fpkjxxFptxx.setFPQQLSH(applyRspBO.getApplyNo());
                fpkjxxFptxx.setNSRSBH(this.taxCode);
                fpkjxxFptxx.setNSRMC(applyRspBO.getOperUnitName());
                fpkjxxFptxx.setDKBZ("0");
                fpkjxxFptxx.setKPXM("\u529e\u516c\u7528\u54c1");
                fpkjxxFptxx.setBMB_BBH("26");
                fpkjxxFptxx.setFJH("");
                fpkjxxFptxx.setNSRDZDAH("");
                fpkjxxFptxx.setDSPTBM("");
                fpkjxxFptxx.setGHF_YHZH(applyRspBO.getBankAcctNo());
                fpkjxxFptxx.setSWJG_DM("");
                fpkjxxFptxx.setSGBZ("");
                fpkjxxFptxx.setPYDM("");
                fpkjxxFptxx.setXHF_DH("");
                fpkjxxFptxx.setGHF_NSRSBH("");
                fpkjxxFptxx.setGHF_DZ("");
                fpkjxxFptxx.setGHF_SF("");
                fpkjxxFptxx.setGHF_SJ(applyRspBO.getPhone());
                fpkjxxFptxx.setGHF_EMAIL("");
                fpkjxxFptxx.setXHF_YHZH(applyRspBO.getBankAcctNo());
                fpkjxxFptxx.setHY_DM("");
                fpkjxxFptxx.setHY_MC("");
                fpkjxxFptxx.setSKY("");
                fpkjxxFptxx.setFHR("");
                fpkjxxFptxx.setKPRQ(applyRspBO.getApplyDate());
                fpkjxxFptxx.setXHF_NSRSBH(this.taxCode);
                fpkjxxFptxx.setYFP_DM("");
                fpkjxxFptxx.setYFP_HM("");
                fpkjxxFptxx.setTSCHBZ("");
                fpkjxxFptxx.setQDXMMC("");
                fpkjxxFptxx.setCHYY("");
                fpkjxxFptxx.setBZ("");
                fpkjxxFptxx.setBYZD1("");
                fpkjxxFptxx.setBYZD2("");
                fpkjxxFptxx.setBYZD3("");
                fpkjxxFptxx.setBYZD4("");
                fpkjxxFptxx.setBYZD5("");
                fpkjxxFptxx.setXHFMC(applyRspBO.getOperUnitName());
                fpkjxxFptxx.setXHF_DZ(applyRspBO.getAddr());
                fpkjxxFptxx.setGHFMC(applyRspBO.getInvoceName());
                fpkjxxFptxx.setGHF_GDDH("");
                fpkjxxFptxx.setGHF_NSRSBH(applyRspBO.getTaxNo());
                fpkjxxFptxx.setGHF_YHZH(applyRspBO.getBankName());
                fpkjxxFptxx.setGHFQYLX("01");
                fpkjxxFptxx.setKPY(busiInvoiceIssueReqBO.getUsername());
                fpkjxxFptxx.setKPLX("1");
                fpkjxxFptxx.setCZDM("10");
                fpkjxxFptxx.setQD_BZ("0");
                fpkjxxFptxx.setKPHJJE(Double.valueOf(applyRspBO.getAmt().doubleValue()));
                BigDecimal taxAmt = applyRspBO.getAmt().divide(BigDecimal.ONE.add(new BigDecimal("0.06")), 5, 4).multiply(new BigDecimal("0.06")).setScale(2, 4);
                fpkjxxFptxx.setHJSE(Double.valueOf(taxAmt.doubleValue()));
                fpkjxxFptxx.setHJBHSJE(Double.valueOf(applyRspBO.getAmt().subtract(taxAmt).doubleValue()));
                GlobalInfoBO globalInfo = new GlobalInfoBO();
                globalInfo.setTerminalCode("0");
                if (applyRspBO != null && "2".equals(applyRspBO.getInvoiceType())) {
                    globalInfo.setAppId("ZZS_PT_DZFP");
                } else {
                    globalInfo.setAppId("DZFP");
                }
                globalInfo.setTaxpayerId(this.taxCode);
                globalInfo.setAuthorizationCode(this.authorizationCode);
                ArrayList<BillItemBO> fpkjxxXmxxs = new ArrayList<BillItemBO>();
                if (applyRspBO.getRows() != null && applyRspBO.getRows().size() > 0) {
                    for (BusiQueryDetailBillApplyInfoOrderRspBO infoOrderRspBO : applyRspBO.getRows()) {
                        if (infoOrderRspBO.getItemList() == null || infoOrderRspBO.getItemList().size() <= 0) continue;
                        fpkjxxFptxx.setKPXM(((BusiQueryDetailBillApplyInfoItemRspBO)infoOrderRspBO.getItemList().get(0)).getSkuName());
                        for (BusiQueryDetailBillApplyInfoItemRspBO infoItemRspBO : infoOrderRspBO.getItemList()) {
                            BillItemBO billItemBO = new BillItemBO();
                            billItemBO.setXMMC("\u5546\u54c1\u540d\u79f0");
                            billItemBO.setHSBZ("0");
                            billItemBO.setXMDW("");
                            billItemBO.setGGXH("");
                            billItemBO.setXMSL("");
                            billItemBO.setKCE(Double.valueOf(0.0));
                            billItemBO.setSE(Double.valueOf(0.0));
                            billItemBO.setZXBM(infoItemRspBO.getSeq().toString());
                            billItemBO.setLSLBS("");
                            billItemBO.setZZSTSGL("");
                            billItemBO.setFPHXZ("0");
                            billItemBO.setXMDJ(Double.valueOf(infoItemRspBO.getSaleUnitPrice().doubleValue()));
                            if (infoItemRspBO.getTaxCatCode() != null) {
                                billItemBO.setSWBM(infoItemRspBO.getTaxCatCode().toString());
                                billItemBO.setSPBM(infoItemRspBO.getTaxCatCode().toString());
                            } else {
                                billItemBO.setSWBM("1010101030000000000");
                                billItemBO.setSPBM("1010101030000000000");
                            }
                            billItemBO.setYHZCBS("0");
                            billItemBO.setBYZD1("");
                            billItemBO.setBYZD2("");
                            billItemBO.setBYZD3("");
                            billItemBO.setBYZD4("");
                            billItemBO.setBYZD5("");
                            billItemBO.setXMJE(Double.valueOf(infoItemRspBO.getUntaxAmt().doubleValue()));
                            billItemBO.setSL(infoItemRspBO.getTaxRate().toString());
                            fpkjxxXmxxs.add(billItemBO);
                        }
                    }
                }
                OrderInfoBO fpkjxxDdxx = new OrderInfoBO();
                fpkjxxDdxx.setDDH(applyNo);
                fpkjxxDdxx.setTHDH("");
                SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String date = sd.format(new Date());
                log.error("date\u5165\u53c2\uff1a" + date);
                fpkjxxDdxx.setDDDATE(date);
                invoiceIssueExtReqBO.setFpkjxxDdxx(fpkjxxDdxx);
                invoiceIssueExtReqBO.setFpkjxxFptxx(fpkjxxFptxx);
                invoiceIssueExtReqBO.setGlobalInfo(globalInfo);
                invoiceIssueExtReqBO.setFpkjxxXmxxs(fpkjxxXmxxs);
                InvoiceIssueExtRspBO invoiceIssueExtRspBO = this.invoiceIssueExternalService.invoiceIssue(invoiceIssueExtReqBO);
                if (invoiceIssueExtRspBO != null && "0000".equals(invoiceIssueExtRspBO.getRespCode())) {
                    BillApplyInfo billApply = new BillApplyInfo();
                    billApply.setApplyNo(applyNo);
                    billApply.setBillStatus("02");
                    this.billApplyInfoMapper.updateByPrimaryKeySelective(billApply);
                    this.saleOrderInfoMapper.updateStatusByApplyNo(applyNo, "01");
                    rspBO.setRespCode(invoiceIssueExtRspBO.getRespCode());
                    rspBO.setRespDesc(invoiceIssueExtRspBO.getRespDesc());
                    continue;
                }
                rspBO.setRespCode(invoiceIssueExtRspBO.getRespCode());
                rspBO.setRespDesc(invoiceIssueExtRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u670d\u52a1\u62a5\u9519\uff1a", (Throwable)e);
        }
        return rspBO;
    }

    public BusiQueryDetailBillApplyInfoApplyRspBO queryApply(BusiQueryDetailBillApplyInfoReqBO reqBO) {
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String applyNo = reqBO.getApplyNo();
        if (!StringUtils.hasText((String)applyNo)) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u3010applyNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        if (billApplyInfo == null) {
            throw new PfscExtBusinessException("18000", "\u627e\u4e0d\u5230\u5f00\u7968\u7533\u8bf7\u5355\u3010\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "\u3011");
        }
        SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
        saleOrderInfoVO.setApplyNo(applyNo);
        saleOrderInfoVO.setSource(billApplyInfo.getSource());
        saleOrderInfoVO.setOrderBy(" tt.inspectionId DESC");
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getListPageByApplyNo(saleOrderInfoVO, (Page<Map<String, Object>>)page);
        ArrayList<BusiQueryDetailBillApplyInfoOrderRspBO> orderList = new ArrayList<BusiQueryDetailBillApplyInfoOrderRspBO>();
        if (saleOrderInfoList != null) {
            for (SaleOrderInfo saleOrderInfo : saleOrderInfoList) {
                SaleItemInfoVO condition = new SaleItemInfoVO();
                condition.setInspectionId(saleOrderInfo.getInspectionId());
                condition.setApplyNo(billApplyInfo.getApplyNo());
                List<SaleItemInfo> saleItemInfoList = this.saleItemInfoMapper.getListContainsItemApplyInfo(condition);
                ArrayList<Long> skuIds = new ArrayList<Long>();
                for (SaleItemInfo saleItemInfo : saleItemInfoList) {
                    skuIds.add(saleItemInfo.getSkuId());
                }
                HashMap<Long, String> skuIdNameMap = new HashMap<Long, String>();
                List<PayInvoiceDetail> payInvoiceDetails = this.payInvoiceDetailMapper.getItemNameBySkuId(skuIds);
                for (PayInvoiceDetail payInvoiceDetail : payInvoiceDetails) {
                    skuIdNameMap.put(payInvoiceDetail.getSkuId(), payInvoiceDetail.getItemName());
                }
                ArrayList<BusiQueryDetailBillApplyInfoItemRspBO> itemList = new ArrayList<BusiQueryDetailBillApplyInfoItemRspBO>();
                for (SaleItemInfo saleItemInfo : saleItemInfoList) {
                    BusiQueryDetailBillApplyInfoItemRspBO item = new BusiQueryDetailBillApplyInfoItemRspBO();
                    BeanUtils.copyProperties((Object)saleItemInfo, (Object)item);
                    item.setSkuName((String)skuIdNameMap.get(saleItemInfo.getSkuId()));
                    if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(billApplyInfo.getApplyType())) {
                        item.setAmountApply(saleItemInfo.getAmountApplied());
                        item.setQuantityApply(saleItemInfo.getQuantityApplied());
                    } else {
                        item.setAmountApply(saleItemInfo.getAmount());
                        item.setQuantityApply(saleItemInfo.getQuantity());
                    }
                    itemList.add(item);
                }
                BusiQueryDetailBillApplyInfoOrderRspBO busiQueryDetailBillApplyInfoOrderRspBO = new BusiQueryDetailBillApplyInfoOrderRspBO();
                BeanUtils.copyProperties((Object)saleOrderInfo, (Object)busiQueryDetailBillApplyInfoOrderRspBO);
                busiQueryDetailBillApplyInfoOrderRspBO.setOrderId(String.valueOf(saleOrderInfo.getOrderId()));
                busiQueryDetailBillApplyInfoOrderRspBO.setOrderStatusDescr(this.enumsService.getDescr(OrderStatus.getInstance(saleOrderInfo.getOrderStatus())));
                busiQueryDetailBillApplyInfoOrderRspBO.setItemList(itemList);
                orderList.add(busiQueryDetailBillApplyInfoOrderRspBO);
            }
        }
        BusiQueryDetailBillApplyInfoApplyRspBO rspBO = new BusiQueryDetailBillApplyInfoApplyRspBO();
        BeanUtils.copyProperties((Object)billApplyInfo, (Object)rspBO);
        rspBO.setOrderCount(Integer.valueOf(page.getTotalCount()));
        rspBO.setRows(orderList);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }
}

