/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.atom;

import com.tydic.pfscext.enums.BaseEnums;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.service.atom.DictionaryAtomService;
import com.tydic.pfscext.service.atom.bo.CacheInfo;
import com.tydic.pfscext.service.atom.bo.DictionaryAtomReqBo;
import com.tydic.pfscext.service.atom.bo.DictionaryAtomRspBo;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="enumsService")
public class EnumsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnumsService.class);
    private final DictionaryAtomService dictionaryAtomService;
    private Map<String, CacheInfo> descrCaches = new HashMap<String, CacheInfo>();

    public EnumsService(DictionaryAtomService dictionaryAtomService) {
        this.dictionaryAtomService = dictionaryAtomService;
    }

    public int queryTaxOrgQueryPageSize() {
        int taxOrgQueryPageSize = 50;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            try {
                taxOrgQueryPageSize = Integer.valueOf(payCenterSystemConfig.get("TAX_ORG_QUERY_PAGE_SIZE"));
            }
            catch (Exception e) {
                LOGGER.error("\u8bfb\u53d6\u5b57\u5178\u503c\u51fa\u9519", (Throwable)e);
            }
        }
        return taxOrgQueryPageSize;
    }

    public String querySupplierPaySaleContactNo() {
        String supplierPaySaleContactNo = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            supplierPaySaleContactNo = payCenterSystemConfig.get("SUPPLIER_PAY_SALE_CONTACT_NO");
        }
        if (!StringUtils.hasText(supplierPaySaleContactNo)) {
            supplierPaySaleContactNo = "xbjfwf";
        }
        return supplierPaySaleContactNo;
    }

    public String querySaleContactNo4ConsultPrice() {
        String saleContactNo = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            saleContactNo = payCenterSystemConfig.get("SALE_CONTACT_NO_4_CONSULT_PRICE");
        }
        if (!StringUtils.hasText(saleContactNo)) {
            saleContactNo = "xbjht-pszy";
        }
        return saleContactNo;
    }

    public Long querySupplierPayIncomeCalcUserId(Long operUnitNo) {
        Long userId = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            String code = "INCOME_CALC_USERID_";
            if (null != operUnitNo && operUnitNo > 0L) {
                code = code + operUnitNo;
            }
            try {
                userId = Long.valueOf(payCenterSystemConfig.get(code));
            }
            catch (Exception e) {
                LOGGER.error("\u8bfb\u53d6\u5b57\u5178\u503c\u51fa\u9519", (Throwable)e);
            }
        }
        if (null == userId) {
            userId = 1L;
        }
        return userId;
    }

    public String queryObtainCheckingFileSwitch() {
        String obtainCheckingFileSwitch = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            obtainCheckingFileSwitch = payCenterSystemConfig.get("OBTAIN_CHECKING_FILE_SWITCH");
        }
        if (!StringUtils.hasText(obtainCheckingFileSwitch)) {
            obtainCheckingFileSwitch = "1";
        }
        return obtainCheckingFileSwitch;
    }

    public String queryObtainCheckingFileSavePath() {
        String path = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            path = payCenterSystemConfig.get("OBTAIN_CHECKING_FILE_SAVE_PATH");
        }
        if (!StringUtils.hasText(path)) {
            path = "/opt/tecent";
        }
        return path;
    }

    public Integer queryObtainCheckingFileSaveDays() {
        Integer days = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            try {
                days = Integer.valueOf(payCenterSystemConfig.get("OBTAIN_CHECKING_FILE_SAVE_DAYS"));
            }
            catch (Exception e) {
                LOGGER.error("\u8bfb\u53d6\u5b57\u5178\u503c\u51fa\u9519", (Throwable)e);
            }
        }
        if (null == days || days < 0) {
            days = 30;
        }
        return days;
    }

    private Map<String, String> queryPayCenterSystemConfig() {
        DictionaryAtomReqBo dictionaryAtomReqBo = new DictionaryAtomReqBo();
        dictionaryAtomReqBo.setpCode("PAY_CENTER_SYSTEM_CONFIG");
        DictionaryAtomRspBo dictionaryAtomRspBo = this.dictionaryAtomService.qryDic(dictionaryAtomReqBo);
        return dictionaryAtomRspBo.getData();
    }

    public String getDescr(BaseEnums dictEnums) {
        String descr = "";
        if (null == dictEnums) {
            return descr;
        }
        if (null == this.dictionaryAtomService) {
            LOGGER.info("dictionaryAtomService \u672a\u6ce8\u5165\u6210\u529f,\u5ffd\u7565\u8c03\u7528");
            return descr;
        }
        String grp = dictEnums.getGroupName();
        CacheInfo inf = this.getMapInCache(grp);
        if (null == inf && StringUtils.hasText((String)grp)) {
            HashMap<String, String> resultRsp = new HashMap(1);
            DictionaryAtomReqBo dictionaryAtomReqBo = new DictionaryAtomReqBo();
            dictionaryAtomReqBo.setpCode(grp);
            DictionaryAtomRspBo dictionaryAtomRspBo = this.dictionaryAtomService.qryDic(dictionaryAtomReqBo);
            if (null != dictionaryAtomRspBo) {
                resultRsp = dictionaryAtomRspBo.getData();
            }
            inf = this.putMapToCache(grp, resultRsp);
        }
        if (null != inf) {
            String eCode = dictEnums.getCodeAsString();
            if (StringUtils.hasText((String)eCode)) {
                Map descrMap = (Map)inf.getOb();
                if (null != descrMap) {
                    descr = (String)descrMap.get(eCode);
                    if (null == descr) {
                        descr = dictEnums.getDescr();
                    }
                } else {
                    descr = dictEnums.getDescr();
                }
            }
        } else {
            descr = dictEnums.getDescr();
        }
        return descr;
    }

    private CacheInfo getMapInCache(String grpName) {
        CacheInfo inf = this.descrCaches.get(grpName);
        if (null != inf && inf.isExpired()) {
            inf = null;
        }
        return inf;
    }

    private CacheInfo putMapToCache(String grpName, Map<String, String> descrMap) {
        if (null == grpName) {
            return null;
        }
        CacheInfo inf = new CacheInfo(descrMap, 120);
        this.descrCaches.put(grpName, inf);
        return inf;
    }

    public String queryLikeSupplierPayTransferAcctName() {
        String transferAcctName = "";
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            transferAcctName = payCenterSystemConfig.get("SUPPLIER_PAY_TRANSFER_ACCT_NAME");
        }
        return transferAcctName;
    }

    public Boolean splitBySupplierInvoiceLimit() {
        boolean isSplit = false;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            String result = payCenterSystemConfig.get("SPLIT_BY_SUPPLIER_INVOICE_LIMIT");
            isSplit = "1".equals(result);
        }
        return isSplit;
    }

    public BigDecimal queryDefaultTaxRate() {
        BigDecimal taxRate = new BigDecimal("0.16");
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            try {
                taxRate = new BigDecimal(payCenterSystemConfig.get("DEFAULT_TAX_RATE"));
            }
            catch (Exception e) {
                LOGGER.error("\u8bfb\u53d6\u5b57\u5178\u503c\u51fa\u9519", (Throwable)e);
            }
        }
        return taxRate;
    }

    public BigDecimal queryDefaultServiceFeeTaxRate() {
        BigDecimal taxRate = new BigDecimal("0.06");
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            try {
                taxRate = new BigDecimal(payCenterSystemConfig.get("DEFAULT_SERVICE_FEE_TAX_RATE"));
            }
            catch (Exception e) {
                LOGGER.error("\u8bfb\u53d6\u5b57\u5178\u503c\u51fa\u9519", (Throwable)e);
            }
        }
        return taxRate;
    }

    public int queryOstGroupByOsdLimit() {
        int limit = 400;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            String result = payCenterSystemConfig.get("OST_GROUP_BY_OSD_LIMIT");
            try {
                if (null != result) {
                    limit = Integer.valueOf(result);
                }
            }
            catch (Exception e) {
                LOGGER.error("\u8bfb\u53d6\u5b57\u5178\u503c\u51fa\u9519", (Throwable)e);
            }
        }
        return limit;
    }

    public String queryEmApplyIsolateOrderSwitch() {
        String emApplyIsolateOrderSwitch = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            emApplyIsolateOrderSwitch = payCenterSystemConfig.get("EM_APPLY_ISOLATE_ORDER_SWITCH");
        }
        if (!StringUtils.hasText(emApplyIsolateOrderSwitch)) {
            emApplyIsolateOrderSwitch = "1";
        }
        return emApplyIsolateOrderSwitch;
    }

    public String queryPlatUseFeeMaterialName() {
        String materialName = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            materialName = payCenterSystemConfig.get("PLAT_USE_FEE_MATERIAL_NAME");
        }
        if (!StringUtils.hasText(materialName)) {
            materialName = "\u5e73\u53f0\u4f7f\u7528\u670d\u52a1\u8d39";
        }
        return materialName;
    }

    public String queryPlatUseFeeTaxClassCode() {
        String taxClassCode = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            taxClassCode = payCenterSystemConfig.get("PLAT_USE_FEE_TAX_CLASS_CODE");
        }
        if (!StringUtils.hasText(taxClassCode)) {
            taxClassCode = "3040205";
        }
        return taxClassCode;
    }

    public String queryTradeServiceFeeMaterialName() {
        String materialName = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            materialName = payCenterSystemConfig.get("TRADE_SERVICE_FEE_MATERIAL_NAME");
        }
        if (!StringUtils.hasText(materialName)) {
            materialName = "\u670d\u52a1\u8d39";
        }
        return materialName;
    }

    public String queryTradeServiceFeeTaxClassCode() {
        String taxClassCode = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            taxClassCode = payCenterSystemConfig.get("TRADE_SERVICE_FEE_TAX_CLASS_CODE");
        }
        if (!StringUtils.hasText(taxClassCode)) {
            taxClassCode = "30499";
        }
        return taxClassCode;
    }

    public String queryAddAdvanceReceiveSwitch() {
        String addAdvanceReceiveSwitch = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            addAdvanceReceiveSwitch = payCenterSystemConfig.get("ADD_ADVANCE_RECEIVE_SWITCH");
        }
        if (!StringUtils.hasText(addAdvanceReceiveSwitch)) {
            addAdvanceReceiveSwitch = "0";
        }
        return addAdvanceReceiveSwitch;
    }

    public String queryReceiptMustSwitch() {
        String receiptMustSwitch = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            receiptMustSwitch = payCenterSystemConfig.get("RECEIPT_MUST_SWITCH");
        }
        if (!StringUtils.hasText(receiptMustSwitch)) {
            receiptMustSwitch = "1";
        }
        return receiptMustSwitch;
    }

    public String queryShowOrderCodeSwitch() {
        String showOrderCodeSwitch = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            showOrderCodeSwitch = payCenterSystemConfig.get("SHOW_ORDER_CODE_SWITCH");
        }
        if (!StringUtils.hasText(showOrderCodeSwitch)) {
            showOrderCodeSwitch = "1";
        }
        return showOrderCodeSwitch;
    }

    public String queryElectronicInvoiceKpr() {
        String kpr = "";
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            kpr = payCenterSystemConfig.get("ELECTRONIC_INVOICE_KPR");
        }
        return kpr;
    }

    public String queryElectronicInvoiceSkr() {
        String skr = "";
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            skr = payCenterSystemConfig.get("ELECTRONIC_INVOICE_SKR");
        }
        return skr;
    }

    public String queryElectronicInvoiceFhr() {
        String fhr = "";
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            fhr = payCenterSystemConfig.get("ELECTRONIC_INVOICE_FHR");
        }
        return fhr;
    }

    public String queryReceiveInvoiceEmail() {
        String receiveInvoiceEmail = "";
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            receiveInvoiceEmail = payCenterSystemConfig.get("RECEIVE_INVOICE_EMAIL");
        }
        return receiveInvoiceEmail;
    }

    public String queryOpenSwitch(Long supplierId) {
        String openSwitch = "1";
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            openSwitch = payCenterSystemConfig.get("OPEN_SWITCH_" + supplierId);
        }
        return openSwitch;
    }

    public String queryReceiveInvoicePhone() {
        String receiveInvoicePhone = "";
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            receiveInvoicePhone = payCenterSystemConfig.get("RECEIVE_INVOICE_PHONE");
        }
        return receiveInvoicePhone;
    }

    public String queryElectronicInvoiceTestSwitch() {
        String electronicInvoiceTestSwitch = "";
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            electronicInvoiceTestSwitch = payCenterSystemConfig.get("ELECTRONIC_INVOICE_TEST_SWITCH");
        }
        return electronicInvoiceTestSwitch;
    }

    public String queryInvoiceReturnTemplate1() {
        String filename = "";
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            filename = payCenterSystemConfig.get("INVOICE_RETURN_TEMPLATE1");
        }
        return filename;
    }

    public String queryInvoiceReturnTemplate2() {
        String filename = "";
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            filename = payCenterSystemConfig.get("INVOICE_RETURN_TEMPLATE2");
        }
        return filename;
    }

    public int queryMaxSleepTime() {
        int maxSleepTime = 60;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            try {
                maxSleepTime = Integer.valueOf(payCenterSystemConfig.get("MAX_SLEEP_TIME"));
            }
            catch (Exception e) {
                LOGGER.error("\u8bfb\u53d6\u5b57\u5178\u503c\u51fa\u9519", (Throwable)e);
            }
        }
        return maxSleepTime;
    }

    public int queryMaxThreadSize() {
        int maxThreadSize = 20;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            try {
                maxThreadSize = Integer.valueOf(payCenterSystemConfig.get("MAX_THREAD_SIZE"));
            }
            catch (Exception e) {
                LOGGER.error("\u8bfb\u53d6\u5b57\u5178\u503c\u51fa\u9519", (Throwable)e);
            }
        }
        return maxThreadSize;
    }

    public int queryIsSendSms() {
        int isSendSms = 1;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            try {
                isSendSms = Integer.valueOf(payCenterSystemConfig.get("IS_SEND_SMS"));
            }
            catch (Exception e) {
                LOGGER.error("\u8bfb\u53d6\u5b57\u5178\u503c\u51fa\u9519", (Throwable)e);
            }
        }
        return isSendSms;
    }

    public String queryDzcsInvoiceReturnNoticeItem() {
        String noticeItem = "";
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            noticeItem = payCenterSystemConfig.get("DZCS_INVOICE_RETURN_NOTICE_ITEM");
        }
        return noticeItem;
    }

    public Map<String, String> queryYuanGuangBillTypeConfig() {
        DictionaryAtomReqBo dictionaryAtomReqBo = new DictionaryAtomReqBo();
        dictionaryAtomReqBo.setpCode("YUAN_GUANG_BILL_TYPE");
        DictionaryAtomRspBo dictionaryAtomRspBo = this.dictionaryAtomService.qryDic(dictionaryAtomReqBo);
        return dictionaryAtomRspBo.getData();
    }

    public String querFileTransmitYuanGuangSwitch(String source) {
        String fileSwitch = "1";
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            fileSwitch = OrderSource.ELECTRIC_MARKET.getCode().equals(source) ? payCenterSystemConfig.get("FILE_TRANSMIT_YUANGUANG_SWITCH_2") : payCenterSystemConfig.get("FILE_TRANSMIT_YUANGUANG_SWITCH_1");
        }
        return fileSwitch;
    }

    public double querAttachmentTransmitYuanGuangMaxSize() {
        double maxSize = 5.0;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            String maxSizeStr = payCenterSystemConfig.get("FILE_TRANSMIT_YUANGUANG_MAX_SIZE");
            try {
                maxSize = Double.parseDouble(maxSizeStr);
                LOGGER.debug("\u6587\u4ef6\u4f20\u8f93\u8fdc\u5149\u8d22\u52a1\u7cfb\u7edf\u9650\u5b9a\u603b\u5927\u5c0f\u4e3a" + maxSizeStr + "MB");
            }
            catch (Exception e) {
                LOGGER.error("\u67e5\u8be2\u6587\u4ef6\u9650\u5b9a\u5927\u5c0f\u5931\u8d25:" + e.getMessage());
            }
        }
        return maxSize;
    }

    public Map<String, Object> querHolytaxConfigInfo() {
        int tryCount = 30;
        int waitSecond = 2;
        double fileSizeCompareVal = 1000.0;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        HashMap<String, Object> configInfoMap = new HashMap<String, Object>(4);
        if (null != payCenterSystemConfig) {
            String tryCountStr = payCenterSystemConfig.get("HOLY_TAX_TRY_COUNT");
            String waitSecondStr = payCenterSystemConfig.get("HOLY_TAX_WAIT_SECOND");
            String compareValStr = payCenterSystemConfig.get("HOLY_TAX_FILE_SIZE_COMPARE_VAL");
            try {
                tryCount = Integer.parseInt(tryCountStr);
                waitSecond = Integer.parseInt(waitSecondStr);
                fileSizeCompareVal = Double.parseDouble(compareValStr);
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u53d6\u5408\u529b\u4e2d\u7a0e\u914d\u7f6e\u4fe1\u606f\u5931\u8d25:" + e.getMessage());
            }
        }
        configInfoMap.put("tryCount", tryCount);
        configInfoMap.put("waitSecond", waitSecond);
        configInfoMap.put("fileSizeCompareVal", fileSizeCompareVal);
        return configInfoMap;
    }

    public BigDecimal queryUnionPayAmountLimit() {
        BigDecimal limit = new BigDecimal("300000");
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (null != payCenterSystemConfig) {
            try {
                limit = new BigDecimal(payCenterSystemConfig.get("UNION_PAY_AMOUNT_LIMIT"));
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u53d6\u5b57\u5178\u5931\u8d25", (Throwable)e);
            }
        }
        return limit;
    }
}

