/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.BusiAdvanceRecQueryService;
import com.tydic.pfscext.api.busi.bo.BusiAdvanceRecQueryReqBO;
import com.tydic.pfscext.api.busi.bo.BusiAdvanceRecQueryRspBO;
import com.tydic.pfscext.api.busi.bo.BusiAdvanceRecQuerySubRspBO;
import com.tydic.pfscext.api.busi.bo.SubAcctInfoExt;
import com.tydic.pfscext.dao.AdvanceReceiveMapper;
import com.tydic.pfscext.dao.SubAcctInfoMapper;
import com.tydic.pfscext.dao.po.AdvanceReceive;
import com.tydic.pfscext.dao.po.SubAcctInfo;
import com.tydic.pfscext.dao.vo.AdvanceRecQueryVO;
import com.tydic.pfscext.dao.vo.AdvanceReceiveVO;
import com.tydic.pfscext.enums.AdvanceReceiveStatus;
import com.tydic.pfscext.enums.BaseEnums;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.ReceiveType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.bo.ProjectInfoBO;
import com.tydic.pfscext.external.api.bo.UserDetailInfoBO;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.service.atom.SubAccountService;
import com.tydic.pfscext.service.atom.UserInfoService;
import com.tydic.pfscext.utils.FileUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiAdvanceRecQueryService.class)
public class BusiAdvanceRecQueryServiceImpl
implements BusiAdvanceRecQueryService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAdvanceRecQueryServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private OrganizationInfoService organizationInfoService;
    private UserInfoService userInfoService;
    private SubAccountService subAccountService;
    private EnumsService enumsService;
    private AdvanceReceiveMapper advanceReceiveMapper;
    private SubAcctInfoMapper subAcctInfoMapper;

    @Autowired
    public BusiAdvanceRecQueryServiceImpl(OrganizationInfoService organizationInfoService, UserInfoService userInfoService, SubAccountService subAccountService, EnumsService enumsService, AdvanceReceiveMapper advanceReceiveMapper, SubAcctInfoMapper subAcctInfoMapper) {
        this.organizationInfoService = organizationInfoService;
        this.userInfoService = userInfoService;
        this.subAccountService = subAccountService;
        this.enumsService = enumsService;
        this.advanceReceiveMapper = advanceReceiveMapper;
        this.subAcctInfoMapper = subAcctInfoMapper;
    }

    public BusiAdvanceRecQueryRspBO queryBusiAdvanceRec(BusiAdvanceRecQueryReqBO reqBO) {
        UserDetailInfoBO userDetailInfoBO;
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u6536\u6b3e\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (null != (userDetailInfoBO = this.userInfoService.queryUserInfoByUserId(reqBO.getUserId()))) {
            reqBO.setOrgId(userDetailInfoBO.getOrgId());
            reqBO.setCompanyId(userDetailInfoBO.getCompanyId());
        }
        if (reqBO.getCompanyId() == null || reqBO.getCompanyId() <= 0L) {
            throw new PfscExtBusinessException("0001", "\u516c\u53f8ID[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSource())) {
            throw new PfscExtBusinessException("0001", "\u67e5\u8be2\u6536\u6b3e\u4fe1\u606f\u670d\u52a1-\u6765\u6e90[source]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AdvanceRecQueryVO vo = new AdvanceRecQueryVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)vo);
        vo.setOrgId(reqBO.getCompanyId());
        vo.setJiaoylsh(reqBO.getSsn());
        vo.setAccountId(reqBO.getAccountId());
        vo.setOrderBy("POST_DATE desc");
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<AdvanceReceiveVO> rows = this.advanceReceiveMapper.selectByConditions(vo, (Page<Map<String, Object>>)page);
        BusiAdvanceRecQueryRspBO rspBO = new BusiAdvanceRecQueryRspBO();
        BeanUtils.copyProperties((Object)vo, (Object)rspBO);
        ArrayList<BusiAdvanceRecQuerySubRspBO> detailRows = new ArrayList<BusiAdvanceRecQuerySubRspBO>();
        for (AdvanceReceiveVO rowVo : rows) {
            AdvanceReceiveStatus receiveStatus;
            BusiAdvanceRecQuerySubRspBO detail = new BusiAdvanceRecQuerySubRspBO();
            BeanUtils.copyProperties((Object)rowVo, (Object)detail);
            AdvanceReceive row = new AdvanceReceive();
            BeanUtils.copyProperties((Object)rowVo, (Object)row);
            String payOrgName = this.organizationInfoService.obtainOrgNameByAdvanceReceive(row);
            detail.setPayOrgName(payOrgName);
            String recOrgName = this.organizationInfoService.queryOrgName(rowVo.getRecOrgId());
            detail.setRecOrgName(recOrgName);
            if (payOrgName != null) {
                if (payOrgName.equals(detail.getTransferAcctName())) {
                    detail.setAgreement("\u4e00\u81f4");
                } else {
                    detail.setAgreement("\u4e0d\u4e00\u81f4");
                }
            }
            detail.setRecTypeName(this.enumsService.getDescr(ReceiveType.getInstance(rowVo.getRecType())));
            SubAcctInfoExt subAcctInfoExt = this.subAccountService.getWithMainAccount(rowVo.getRecSubAcct());
            if (subAcctInfoExt != null) {
                detail.setSourceName(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)subAcctInfoExt.getSource())));
            }
            detail.setStatusDescr(null == (receiveStatus = AdvanceReceiveStatus.getInstance(rowVo.getStatus())) ? "" : receiveStatus.getCodeDescr());
            try {
                String subAcctNo = row.getRecSubAcct();
                SubAcctInfo subAcctInfo = this.subAcctInfoMapper.selectByPrimaryKey(subAcctNo);
                logger.info("\u67e5\u8be2\u5230\u7684accountId\u662f:" + subAcctInfo.getProjectId());
                Long account = subAcctInfo.getProjectId();
                ProjectInfoBO projectInfoBO = this.organizationInfoService.queryProjectName(account);
                detail.setIsVirtual(Integer.toString(projectInfoBO.getIsShadowAccount()));
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u670d\u52a1\u53d1\u751f\u9519\u8bef" + e);
            }
            detail.setToReceiveAmt(detail.getTranAmt().subtract(detail.getWriteoffAmt()));
            detail.setReceiptUrl(FileUtils.obtainOSSUrl(detail.getReceipt()));
            detailRows.add(detail);
        }
        rspBO.setRows(detailRows);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }
}

