/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.pfscext.api.busi.BusiCheckDetailAndSummeryService;
import com.tydic.pfscext.api.busi.bo.BillDetailInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BillSummaryInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BusiCheckDetailAndSummeryReqBO;
import com.tydic.pfscext.api.busi.bo.BusiCheckDetailAndSummeryRspBO;
import com.tydic.pfscext.api.busi.bo.OriginalDocumentsInfoRspBO;
import com.tydic.pfscext.dao.BillDetailInfoMapper;
import com.tydic.pfscext.dao.BillSummaryInfoMapper;
import com.tydic.pfscext.dao.OriginalDocumentsInfoMapper;
import com.tydic.pfscext.dao.po.BillDetailInfo;
import com.tydic.pfscext.dao.po.BillSummaryInfo;
import com.tydic.pfscext.dao.vo.GetOriginalDocumentsInfoVO;
import com.tydic.pfscext.enums.FscBillStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiCheckDetailAndSummeryService.class)
public class BusiCheckDetailAndSummeryServiceImpl
implements BusiCheckDetailAndSummeryService {
    private static final Logger log = LoggerFactory.getLogger(BusiCheckDetailAndSummeryServiceImpl.class);
    @Autowired
    private OriginalDocumentsInfoMapper originalDocumentsInfoMapper;
    @Autowired
    private BillDetailInfoMapper billDetailInfoMapper;
    @Autowired
    private BillSummaryInfoMapper billSummaryInfoMapper;

    public BusiCheckDetailAndSummeryRspBO checkDetailAndSummery(BusiCheckDetailAndSummeryReqBO reqBO) {
        log.info("\u67e5\u770b\u6c47\u603b\u548c\u660e\u7ec6\u8be6\u60c5\u5165\u53c2\uff1a{}", (Object)reqBO);
        List documentNos = reqBO.getDocumentNo();
        if (null == reqBO.getType()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u91c7\u8d2d\u5165\u5e93\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (documentNos.size() == 0) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("".equals(reqBO.getInvoiceStatus()) || null == reqBO.getInvoiceStatus()) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u5f00\u7968\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<BillSummaryInfo> summaryInfos = new ArrayList<BillSummaryInfo>();
        ArrayList<BillDetailInfo> detailInfos = new ArrayList<BillDetailInfo>();
        if (FscBillStatus.NOT_INVOICED.getCode().equals(reqBO.getInvoiceStatus())) {
            List<BillDetailInfo> billDetailInfos = this.billDetailInfoMapper.selectListByDocumentNos(documentNos);
            List<BillSummaryInfo> billSummaryInfos = this.billSummaryInfoMapper.selectListByDocumentNos(documentNos);
            if (billDetailInfos.size() != 0) {
                detailInfos.addAll(billDetailInfos);
            }
            if (billSummaryInfos.size() != 0) {
                summaryInfos.addAll(billSummaryInfos);
            }
        } else {
            if ("".equals(reqBO.getMergeNo()) || null == reqBO.getMergeNo()) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u5f00\u7968\u8bb0\u5f55\u9875\u67e5\u770b\u65f6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List<BillSummaryInfo> billSummaryInfos = this.billSummaryInfoMapper.selectByMergeNo(reqBO.getMergeNo());
            if (billSummaryInfos.size() != 0) {
                summaryInfos.addAll(billSummaryInfos);
            }
        }
        List<GetOriginalDocumentsInfoVO> documents = this.originalDocumentsInfoMapper.selectUnionListByDocumentNos(documentNos);
        if (documents.size() == 0) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u672a\u67e5\u8be2\u5230\u91c7\u8d2d\u5165\u5e93\u8be6\u60c5\u6570\u636e");
        }
        List originalDocumentsInfoRspBOS = JSON.parseArray((String)JSON.toJSONString(documents), OriginalDocumentsInfoRspBO.class);
        List billDetailInfoRspBOS = JSON.parseArray((String)JSON.toJSONString(detailInfos), BillDetailInfoRspBO.class);
        List billSummaryInfoRspBOS = JSON.parseArray((String)JSON.toJSONString(summaryInfos), BillSummaryInfoRspBO.class);
        BusiCheckDetailAndSummeryRspBO rspBO = new BusiCheckDetailAndSummeryRspBO();
        if (billDetailInfoRspBOS.size() != 0) {
            rspBO.setDetails(billDetailInfoRspBOS);
        }
        if (billSummaryInfoRspBOS.size() != 0) {
            rspBO.setSummaries(billSummaryInfoRspBOS);
        }
        if (originalDocumentsInfoRspBOS.size() != 0) {
            rspBO.setDocuments(originalDocumentsInfoRspBOS);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

