/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiExportReceiptInfoService;
import com.tydic.pfscext.api.busi.bo.BusiExportHeadReceiptInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BusiExportReceiptInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiExportReceiptInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BusiExportRowReceiptInfoRspBO;
import com.tydic.pfscext.dao.ExportEntryInfoMapper;
import com.tydic.pfscext.dao.SupplierInfoMapper;
import com.tydic.pfscext.dao.po.EntryInfoPO;
import com.tydic.pfscext.dao.po.ReceiptInfoPO;
import com.tydic.pfscext.dao.po.SupplierInfo;
import com.tydic.pfscext.dao.vo.EntryInfoVO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.service.atom.UserInfoService;
import com.tydic.pfscext.utils.AmountUtils;
import com.tydic.pfscext.utils.BeanUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiExportReceiptInfoServiceImpl
implements BusiExportReceiptInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiExportReceiptInfoServiceImpl.class);
    @Autowired
    private OrganizationInfoService orgService;
    @Autowired
    private ExportEntryInfoMapper exportEntryInfoMapper;
    @Autowired
    private SupplierInfoMapper supplierInfoMapper;
    @Autowired
    private UserInfoService userInfoService;

    public BusiExportReceiptInfoRspBO exportReceiptInfo(BusiExportReceiptInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5bfc\u51fa\u5165\u5e93\u5355\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        BusiExportReceiptInfoRspBO rspBO = new BusiExportReceiptInfoRspBO();
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getEntryNo() == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u5e93\u5355\u53f7[entryNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getCompanyId() == null) {
            throw new PfscExtBusinessException("0001", "\u4e13\u4e1a\u516c\u53f8\u7f16\u53f7[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        BusiExportHeadReceiptInfoRspBO head = new BusiExportHeadReceiptInfoRspBO();
        EntryInfoVO entryInfoVO = new EntryInfoVO();
        entryInfoVO.setEntryNo(reqBO.getEntryNo());
        entryInfoVO.setOprCompanyId(reqBO.getCompanyId());
        EntryInfoPO entryInfoPO = this.exportEntryInfoMapper.selectSelective(entryInfoVO);
        head.setCompanyName(this.orgService.queryOrgName(entryInfoPO.getOprCompanyId()));
        head.setEntryDate(sdf.format(entryInfoPO.getEntryDate()));
        head.setEntryNo(entryInfoPO.getEntryNo());
        head.setPurchaseName(this.orgService.querySupplierName(entryInfoPO.getPurchaseId()));
        head.setCreateUserName(this.userInfoService.queryUserNameByUserId(entryInfoPO.getCreateUser()));
        head.setSource(entryInfoPO.getSource());
        head.setApplyNo(entryInfoPO.getApplyNo());
        SupplierInfo supplierInfo = this.supplierInfoMapper.selectByPrimaryKey(entryInfoPO.getPurchaseId());
        if (supplierInfo != null && supplierInfo.getEffectContactNo() != null) {
            head.setNotificationNo(supplierInfo.getEffectContactNo());
        } else {
            head.setNotificationNo("");
        }
        head.setSumNotTaxAmt(AmountUtils.format(entryInfoPO.getNotTaxAmt()));
        head.setSumTaxAmt(AmountUtils.format(entryInfoPO.getTax()));
        head.setSum(AmountUtils.format(entryInfoPO.getAmt()));
        BeanUtils.null2DefaultValue(head);
        rspBO.setHead(head);
        LinkedList<BusiExportRowReceiptInfoRspBO> rows = new LinkedList<BusiExportRowReceiptInfoRspBO>();
        List<ReceiptInfoPO> list = this.exportEntryInfoMapper.selectByConditions(reqBO.getEntryNo());
        for (ReceiptInfoPO poList : list) {
            if (poList.getQuantity().compareTo(BigDecimal.ZERO) == 0) continue;
            BusiExportRowReceiptInfoRspBO row = new BusiExportRowReceiptInfoRspBO();
            org.springframework.beans.BeanUtils.copyProperties((Object)poList, (Object)row);
            row.setPurchaseUnitPrice(AmountUtils.format(poList.getNotTaxAmt().divide(poList.getQuantity(), 2, 4)));
            row.setNotTaxAmt(AmountUtils.format(poList.getNotTaxAmt()));
            row.setTaxAmt(AmountUtils.format(poList.getTaxAmt()));
            BeanUtils.null2DefaultValue(row);
            rows.add(row);
        }
        rspBO.setRows(rows);
        return rspBO;
    }
}

