/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.BusiProSubAccountAddService;
import com.tydic.pfscext.api.busi.bo.BusiSubAccountInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiSubAccountInfoRspBO;
import com.tydic.pfscext.api.busi.bo.SubAcctInfoExt;
import com.tydic.pfscext.dao.MainAcctInfoMapper;
import com.tydic.pfscext.dao.PurchaseUnitInfoMapper;
import com.tydic.pfscext.dao.po.MainAcctInfo;
import com.tydic.pfscext.dao.po.SubAcctInfo;
import com.tydic.pfscext.enums.CompanyType;
import com.tydic.pfscext.enums.SubAccountServiceType;
import com.tydic.pfscext.enums.SubAccountStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.bo.ProjectInfoBO;
import com.tydic.pfscext.external.api.bo.UserDetailInfoBO;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.service.atom.SubAccountRespInitService;
import com.tydic.pfscext.service.atom.SubAccountService;
import com.tydic.pfscext.service.atom.UserInfoService;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiProSubAccountAddService.class)
public class BusiProSubAccountAddServiceImpl
implements BusiProSubAccountAddService {
    private static final Logger logger = LoggerFactory.getLogger(BusiProSubAccountAddServiceImpl.class);
    private SubAccountService subAcctService;
    private SubAccountRespInitService initSerivce;
    private MainAcctInfoMapper mainAcctInfoMapper;
    private OrganizationInfoService organizationInfoService;
    private PurchaseUnitInfoMapper purchaseUnitInfoMapper;
    private EnumsService enumsService;
    private UserInfoService userInfoService;

    @Autowired
    public BusiProSubAccountAddServiceImpl(SubAccountService subAcctService, SubAccountRespInitService initSerivce, MainAcctInfoMapper mainAcctInfoMapper, OrganizationInfoService organizationInfoService, PurchaseUnitInfoMapper purchaseUnitInfoMapper, EnumsService enumsService, UserInfoService userInfoService) {
        this.subAcctService = subAcctService;
        this.initSerivce = initSerivce;
        this.mainAcctInfoMapper = mainAcctInfoMapper;
        this.organizationInfoService = organizationInfoService;
        this.purchaseUnitInfoMapper = purchaseUnitInfoMapper;
        this.enumsService = enumsService;
        this.userInfoService = userInfoService;
    }

    public BusiSubAccountInfoRspBO addSubAccount(BusiSubAccountInfoReqBO reqBO) {
        UserDetailInfoBO userDetailInfoBO;
        if (logger.isDebugEnabled()) {
            logger.debug("\u65b0\u589e\u5b50\u8d26\u53f7BO:" + reqBO.toString());
        }
        if (null != (userDetailInfoBO = this.userInfoService.queryUserInfoByUserId(reqBO.getUserId()))) {
            reqBO.setOrgId(userDetailInfoBO.getOrgId());
            reqBO.setCompanyId(userDetailInfoBO.getCompanyId());
        }
        Long oprOrgId = reqBO.getOrgId();
        Long superiorOrgId = reqBO.getSuperiorOrgId();
        Long companyId = reqBO.getCompanyId();
        if (oprOrgId == null) {
            throw new PfscExtBusinessException("0001", "\u65b0\u589e\u5b50\u8d26\u53f7\u5931\u8d25,\u5f53\u524d\u64cd\u4f5c\u5458\u673a\u6784\u53f7\u4e3a\u7a7a");
        }
        Integer channelType = reqBO.getChannelType();
        if (channelType == null) {
            throw new PfscExtBusinessException("0001", "\u65b0\u589e\u5b50\u8d26\u53f7\u5931\u8d25,\u6e20\u9053\u7c7b\u578bchannelType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer srvType = reqBO.getServiceType();
        String mainAcctNo = reqBO.getMainAcctNo();
        String source = reqBO.getSource();
        Long acctOrgId = reqBO.getAcctOrgId();
        Long projectId = reqBO.getProjectId();
        String subAcctName = reqBO.getSubAcctName();
        Integer companyType = reqBO.getAcctCompanyType();
        BigDecimal overDraft = reqBO.getOverdraft();
        SubAcctInfo subAcct = new SubAcctInfo();
        if (overDraft == null) {
            overDraft = BigDecimal.ZERO;
        }
        if (!StringUtils.hasText((String)subAcctName)) {
            throw new PfscExtBusinessException("0001", "\u5b50\u8d26\u53f7\u540d\u79f0\u5fc5\u987b\u8f93\u5165");
        }
        BusiSubAccountInfoRspBO respBo = new BusiSubAccountInfoRspBO();
        if (channelType > 10 && channelType < 20) {
            if (companyId == null) {
                throw new PfscExtBusinessException("0001", "\u8bf7\u6c42\u4e2d\u65e0\u6cd5\u627e\u5230\u516c\u53f8\u673a\u6784(companyId)");
            }
            superiorOrgId = companyId;
            if (channelType == 11) {
                if (srvType == null) {
                    throw new PfscExtBusinessException("0001", "\u5b50\u8d26\u53f7\u670d\u52a1\u7c7b\u578b\u5fc5\u987b\u8f93\u5165");
                }
                if (SubAccountServiceType.DEFAULT.getCode().equals(srvType)) {
                    throw new PfscExtBusinessException("0001", "\u4e0d\u5141\u8bb8\u5efa\u7acb\u6b64\u79cd\u670d\u52a1\u7c7b\u578b\u7684\u5b50\u8d26\u53f7");
                }
                projectId = reqBO.getPurchaserAccountUser();
                if (projectId == null && (projectId = this.queryAccountId(reqBO.getUserId())) == null) {
                    logger.error("\u4e13\u4e1a\u516c\u53f8\u5efa\u7acb\u8d44\u91d1\u8d26\u53f7\u5931\u8d25,\u65e0\u6548\u7684\u8d26\u5957ID=" + projectId);
                    throw new PfscExtBusinessException("0001", "\u8bf7\u6c42\u4e2d\u672a\u53d1\u73b0\u6709\u6548\u7684\u8d26\u5957ID");
                }
                acctOrgId = superiorOrgId;
                companyType = CompanyType.OTHER.getCode();
                if (!StringUtils.hasText((String)mainAcctNo)) {
                    mainAcctNo = this.getMainAcct(source, superiorOrgId);
                }
                overDraft = new BigDecimal("9999999999999");
            } else if (channelType == 12) {
                if (acctOrgId == null) {
                    ProjectInfoBO projectInfoBO = this.organizationInfoService.queryProjectName(projectId);
                    if (null == projectInfoBO || null == projectInfoBO.getOrgId()) {
                        respBo.setRespCode("18001");
                        respBo.setRespDesc("\u6839\u636e\u8d26\u5957ID\u4ece\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u4e0d\u5230\u5b50\u8d26\u53f7\u6240\u5c5e\u7684\u673a\u6784\u53f7");
                        return respBo;
                    }
                    acctOrgId = projectInfoBO.getOrgId();
                }
                if (CompanyType.convert(companyType) == null) {
                    throw new PfscExtBusinessException("0001", "\u5b50\u8d26\u53f7\u5fc5\u987b\u6307\u5b9a\u662f\u7528\u4e8e\u91c7\u8d2d\u5355\u4f4d\u6216\u4f9b\u5e94\u5546");
                }
                if (projectId == null && (projectId = this.queryAccountId(reqBO.getUserId())) == null) {
                    throw new PfscExtBusinessException("0001", "\u8d26\u5957ID\u5fc5\u987b\u8f93\u5165");
                }
                srvType = SubAccountServiceType.DEFAULT.getCode();
                if (!StringUtils.hasText((String)mainAcctNo)) {
                    mainAcctNo = this.getMainAcct(source, superiorOrgId);
                }
            }
        } else if (channelType > 20 && channelType < 30) {
            if (acctOrgId == null) {
                throw new PfscExtBusinessException("0001", "\u5b50\u8d26\u53f7\u6240\u5c5e\u7684\u673a\u6784ID\u5fc5\u987b\u8f93\u5165");
            }
            if (projectId == null && (projectId = this.queryAccountId(reqBO.getUserId())) == null) {
                throw new PfscExtBusinessException("0001", "\u8d26\u5957ID\u5fc5\u987b\u8f93\u5165");
            }
            companyType = CompanyType.PURCHASER.getCode();
            srvType = SubAccountServiceType.DEFAULT.getCode();
            if (!StringUtils.hasText((String)mainAcctNo)) {
                mainAcctNo = this.getMainAcct(source, superiorOrgId);
            }
        } else {
            throw new PfscExtBusinessException("0001", "\u672a\u77e5\u7684\u64cd\u4f5c\u6e20\u9053\u7c7b\u578bchannelType");
        }
        subAcct.setLoginId(reqBO.getUserId());
        subAcct.setCreateOrgId(oprOrgId);
        subAcct.setMainAcctNo(mainAcctNo);
        subAcct.setOrgId(acctOrgId);
        subAcct.setSubAcctName(reqBO.getSubAcctName());
        subAcct.setServiceType(srvType);
        subAcct.setProjectId(projectId);
        subAcct.setCompanyType(companyType);
        subAcct.setOverdraft(overDraft);
        subAcct.setStatus(SubAccountStatus.ACTIVED.getCode());
        subAcct = this.subAcctService.addSubAccount(subAcct);
        SubAcctInfoExt extInfo = this.subAcctService.getWithMainAccount(subAcct.getSubAcctNo());
        this.initSerivce.initRespBo(extInfo, respBo);
        SubAccountStatus sta = SubAccountStatus.getCode(respBo.getStatus());
        if (sta != null) {
            String name = this.enumsService.getDescr(sta);
            respBo.setStatusDescr(name);
        }
        if (!"0000".equals(subAcct.getRespCode())) {
            respBo.setRespCode("18000");
            respBo.setRespDesc(subAcct.getRespDesc());
            return respBo;
        }
        if (subAcct.getStatus().equals(SubAccountStatus.CLOSED.getCode())) {
            respBo.setRespDesc("\u8d26\u6237\u65b0\u589e\u6210\u529f\uff0c\u72b6\u6001\u4e3a\u505c\u7528\uff0c\u8bf7\u7ef4\u62a4\u5408\u540c\u4fe1\u606f");
        } else {
            respBo.setRespDesc("\u65b0\u589e\u6210\u529f");
        }
        respBo.setRespCode("0000");
        return respBo;
    }

    private String getMainAcct(String source, Long mainOrg) {
        logger.info("\u5efa\u5b50\u8d26\u53f7\u67e5\u8be2\u4e3b\u8d26\u53f7,\u6765\u6e90=" + source + ",\u4e3b\u8d26\u53f7\u673a\u6784=" + mainOrg);
        if (!StringUtils.hasText((String)source)) {
            throw new PfscExtBusinessException("0001", "\u6765\u6e90\u5fc5\u987b\u8f93\u5165");
        }
        if (mainOrg == null) {
            throw new PfscExtBusinessException("0001", "\u4e3b\u8d26\u53f7\u7684\u673a\u6784\u53f7\u65e0\u6548");
        }
        MainAcctInfo mainInfo = this.mainAcctInfoMapper.selectByPrimaryKey(mainOrg, source);
        if (mainInfo == null) {
            throw new PfscExtBusinessException("18001", "\u6b64\u673a\u6784\u5bf9\u5e94\u7684\u4e13\u4e1a\u516c\u53f8\u672a\u5f00\u901a\u6b64\u6765\u6e90\u7684\u4e3b\u8d26\u53f7");
        }
        return mainInfo.getMainAcctNo();
    }

    private Long queryAccountId(Long userId) {
        Long accountId = null;
        List<ProjectInfoBO> projectInfoBOList = this.userInfoService.queryProjectInfoByUserId(userId);
        if (!CollectionUtils.isEmpty(projectInfoBOList)) {
            accountId = projectInfoBOList.get(0).getAccountId();
        }
        return accountId;
    }
}

