/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.BusiQueryPurchaseOrderDetailInfoService;
import com.tydic.pfscext.api.busi.bo.BusiPurchaseOrderDetailInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiPurchaseOrderDetailInfoRspBO;
import com.tydic.pfscext.api.busi.bo.PayItemInfoRspBO;
import com.tydic.pfscext.api.busi.bo.PayPurchaseOrderInfoRspBO;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.PayItemInfoVO;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.bo.TsupplierInfoRspBO;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiQueryPurchaseOrderDetailInfoService.class)
public class BusiQueryPurchaseOrderDetailInfoServiceImpl
implements BusiQueryPurchaseOrderDetailInfoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusiQueryPurchaseOrderDetailInfoServiceImpl.class);
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    private PayItemInfoMapper payItemInfoMapper;
    private EnumsService enumsService;
    private OrganizationInfoService organizationInfoService;
    private SaleOrderInfoMapper saleOrderInfoMapper;

    @Autowired
    public BusiQueryPurchaseOrderDetailInfoServiceImpl(PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper, PayItemInfoMapper payItemInfoMapper, EnumsService enumsService, OrganizationInfoService organizationInfoService, SaleOrderInfoMapper saleOrderInfoMapper) {
        this.payPurchaseOrderInfoMapper = payPurchaseOrderInfoMapper;
        this.payItemInfoMapper = payItemInfoMapper;
        this.enumsService = enumsService;
        this.organizationInfoService = organizationInfoService;
        this.saleOrderInfoMapper = saleOrderInfoMapper;
    }

    public BusiPurchaseOrderDetailInfoRspBO queryPurchaseOrderDetailInfo(BusiPurchaseOrderDetailInfoReqBO reqBO) {
        TsupplierInfoRspBO supplier;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(" \u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (null == reqBO.getInspectionId()) {
            throw new PfscExtBusinessException("0001", "\u9a8c\u6536\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiPurchaseOrderDetailInfoRspBO rspBO = new BusiPurchaseOrderDetailInfoRspBO();
        PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
        payPurchaseOrderInfo.setInspectionId(reqBO.getInspectionId());
        payPurchaseOrderInfo = this.payPurchaseOrderInfoMapper.getModelBy(payPurchaseOrderInfo);
        if (null == payPurchaseOrderInfo) {
            LOGGER.error("\u6839\u636e\u9a8c\u6536\u5355\u53f7\uff1a" + reqBO.getInspectionId() + "\u627e\u4e0d\u5230\u91c7\u8d2d\u8ba2\u5355\u3002");
            throw new PfscExtBusinessException("18001", "\u6839\u636e\u9a8c\u6536\u5355\u53f7\uff1a" + reqBO.getInspectionId() + "\u627e\u4e0d\u5230\u91c7\u8d2d\u8ba2\u5355");
        }
        PayPurchaseOrderInfoRspBO payPurchaseOrder = new PayPurchaseOrderInfoRspBO();
        BeanUtils.copyProperties((Object)payPurchaseOrderInfo, (Object)payPurchaseOrder);
        OrderStatus orderStatusEnum = OrderStatus.getInstance(payPurchaseOrderInfo.getOrderStatus());
        payPurchaseOrder.setOrderStatusStr(this.enumsService.getDescr(orderStatusEnum));
        SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
        saleOrderInfo.setOrderId(payPurchaseOrderInfo.getOrderId());
        SaleOrderInfo modelBy = this.saleOrderInfoMapper.getModelBy(saleOrderInfo);
        payPurchaseOrder.setPurchaseOrderId(String.valueOf(modelBy.getPurchaseOrderId()));
        payPurchaseOrder.setPurchaseProjectName(this.organizationInfoService.queryProjectName(payPurchaseOrderInfo.getPurchaseProjectId()).getAccountName());
        ArrayList<Long> supIds = new ArrayList<Long>();
        supIds.add(payPurchaseOrderInfo.getSupplierNo());
        Map<Long, TsupplierInfoRspBO> suppliers = this.organizationInfoService.querySupplies(supIds);
        if (null != suppliers && null != (supplier = suppliers.get(payPurchaseOrderInfo.getSupplierNo()))) {
            payPurchaseOrder.setLinkMan(supplier.getLinkMan());
            payPurchaseOrder.setTel(supplier.getTel());
            payPurchaseOrder.setPhoneNumber(supplier.getPhoneNumber());
            payPurchaseOrder.setAddrDesc(supplier.getAddrDesc());
        }
        rspBO.setPayPurchaseOrderInfo(payPurchaseOrder);
        LinkedList<PayItemInfoRspBO> itemList = new LinkedList<PayItemInfoRspBO>();
        PayItemInfoVO payItemInfoVO = new PayItemInfoVO();
        payItemInfoVO.setInspectionId(reqBO.getInspectionId());
        List<PayItemInfo> payItemInfoList = this.payItemInfoMapper.selectBy(payItemInfoVO);
        for (PayItemInfo singleItem : payItemInfoList) {
            PayItemInfoRspBO payItemInfoRspBO = new PayItemInfoRspBO();
            BeanUtils.copyProperties((Object)singleItem, (Object)payItemInfoRspBO);
            itemList.add(payItemInfoRspBO);
        }
        rspBO.setPayItemList(itemList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f\u6210\u529f");
        return rspBO;
    }
}

