/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.atom.bo;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class PingAnResult
implements Serializable {
    private static final Log LOGGER = LogFactory.getLog(PingAnResult.class);
    private static final long serialVersionUID = 1087421547620595702L;
    private String subAcctNo;
    private boolean success;
    private String returnCode;
    private String returnMsg;
    private Date accountDate;
    private Date tranDate;
    private String reqSn;
    private String resSn;
    private static final String SUCCESS_CODE = "000000";
    private static final Integer SUCCESS_CODE_LENGTH = 6;

    public String getSubAcctNo() {
        return this.subAcctNo;
    }

    public void setSubAcctNo(String subAcctNo) {
        this.subAcctNo = subAcctNo;
    }

    public Date getAccountDate() {
        return this.accountDate;
    }

    public void setAccountDate(Date accountDate) {
        this.accountDate = accountDate;
    }

    public String getReqSn() {
        return this.reqSn;
    }

    public void setReqSn(String reqSn) {
        this.reqSn = reqSn;
    }

    public String getResSn() {
        return this.resSn;
    }

    public void setResSn(String resSn) {
        this.resSn = resSn;
    }

    public Date getTranDate() {
        return this.tranDate;
    }

    public void setTranDate(Date tranDate) {
        this.tranDate = tranDate;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(String returnCode) {
        int len;
        this.setSuccess(false);
        if (StringUtils.hasText((String)returnCode) && (len = returnCode.length()) >= SUCCESS_CODE_LENGTH) {
            String rtnCode;
            returnCode = rtnCode = returnCode.substring(len - SUCCESS_CODE_LENGTH, len);
            if (SUCCESS_CODE.equals(rtnCode)) {
                this.setSuccess(true);
            }
        }
        this.returnCode = returnCode;
    }

    public String getReturnMsg() {
        return this.returnMsg;
    }

    public void setReturnMsg(String returnMsg) {
        this.returnMsg = returnMsg;
    }

    public void formatAccountDate(String date) {
        this.accountDate = PingAnResult.formatDate(date, null);
    }

    public void formatTransDate(String date, String time) {
        this.tranDate = PingAnResult.formatDate(date, time);
    }

    private static Date formatDate(String date, String time) {
        String fmt = "yyyyMMdd";
        if (time != null) {
            fmt = fmt + "HHmmss";
            date = date + time;
        }
        Date result = null;
        SimpleDateFormat sdf = new SimpleDateFormat(fmt);
        try {
            result = sdf.parse(date);
        }
        catch (ParseException e) {
            LOGGER.error((Object)("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38" + e.getMessage()), (Throwable)e);
        }
        return result;
    }

    public String toString() {
        return "PingAnResult [subAcctNo=" + this.subAcctNo + ", success=" + this.success + ", returnCode=" + this.returnCode + ", returnMsg=" + this.returnMsg + ", accountDate=" + this.accountDate + ", tranDate=" + this.tranDate + ", reqSn=" + this.reqSn + ", resSn=" + this.resSn + "]";
    }
}

