/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfscext.api.busi.BusiGetOriginalDocumentsFromErpService;
import com.tydic.pfscext.api.busi.bo.BusiGetOriginalDocumentsReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetOriginalDocumentsRspBO;
import com.tydic.pfscext.api.busi.vo.OriginalDocumentDetailInfoVO;
import com.tydic.pfscext.api.busi.vo.OriginalDocumentSummaryInfoVO;
import com.tydic.pfscext.dao.BillDetailInfoMapper;
import com.tydic.pfscext.dao.BillSummaryInfoMapper;
import com.tydic.pfscext.dao.OriginalDocumentsInfoMapper;
import com.tydic.pfscext.dao.OriginalDocumentsItemInfoMapper;
import com.tydic.pfscext.dao.OriginalOrderInfoMapper;
import com.tydic.pfscext.dao.PriceSettlementSummaryInfoMapper;
import com.tydic.pfscext.dao.po.BillDetailInfo;
import com.tydic.pfscext.dao.po.BillSummaryInfo;
import com.tydic.pfscext.dao.po.OriginalDocumentsInfo;
import com.tydic.pfscext.dao.po.OriginalDocumentsItemInfo;
import com.tydic.pfscext.dao.po.OriginalOrderInfo;
import com.tydic.pfscext.dao.po.PriceSettlementSummaryInfo;
import com.tydic.pfscext.enums.FscBillStatus;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiGetOriginalDocumentsFromErpService.class)
public class BusiGetOriginalDocumentsFromErpServiceImpl
implements BusiGetOriginalDocumentsFromErpService {
    private static final Logger log = LoggerFactory.getLogger(BusiGetOriginalDocumentsFromErpServiceImpl.class);
    private static final String NO_PUSH = "2";
    private static final String PUSHED = "1";
    @Value(value="${ESB_GET_ORDER_INFO_SYNC_ERP_URL:}")
    private String ESB_GET_ORDER_INFO_SYNC_ERP_URL;
    @Value(value="${ESB_GET_ORDER_INFO_SYNC_ERP_URL:}")
    private String ESB_GET_ORDER_SUMMERY_SYNC_ERP_URL;
    @Value(value="${ESB_GET_ORDER_INFO_SYNC_ERP_URL:}")
    private String ESB_GET_ORDER_DETAIL_SYNC_ERP_URL;
    @Autowired
    private OriginalOrderInfoMapper originalOrderInfoMapper;
    @Autowired
    private OriginalDocumentsInfoMapper originalDocumentsInfoMapper;
    @Autowired
    private OriginalDocumentsItemInfoMapper originalDocumentsItemInfoMapper;
    @Autowired
    private PriceSettlementSummaryInfoMapper priceSettlementSummaryInfoMapper;
    @Autowired
    private BillSummaryInfoMapper billSummaryInfoMapper;
    @Autowired
    private BillDetailInfoMapper billDetailInfoMapper;

    public void getOriginalDocuments() {
        log.info("\u6839\u636e\u8ba2\u5355\u53f7\u67e5\u8be2erp\u91c7\u8d2d\u5165\u5e93\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb");
        List<OriginalOrderInfo> orders = this.originalOrderInfoMapper.selectByStatus(NO_PUSH);
        if (orders.size() == 0) {
            log.info("\u6ca1\u6709\u9700\u8981\u67e5\u8be2erp\u7684\u8ba2\u5355");
        } else {
            for (OriginalOrderInfo originalOrderInfo : orders) {
                BusiGetOriginalDocumentsReqBO reqBO = new BusiGetOriginalDocumentsReqBO();
                reqBO.setPkOrder(originalOrderInfo.getOrderId());
                try {
                    BusiGetOriginalDocumentsRspBO originalDocumentFromErp = this.getOriginalDocumentFromErp(reqBO);
                    OriginalDocumentSummaryInfoVO originalDocumentSummeryErp = this.getOriginalDocumentSummeryErp(reqBO);
                    OriginalDocumentDetailInfoVO originalDocumentDetailErp = this.getOriginalDocumentDetailErp(reqBO);
                    OriginalDocumentsInfo originalDocumentsInfo = new OriginalDocumentsInfo();
                    BeanUtils.copyProperties((Object)originalDocumentFromErp, (Object)originalDocumentsInfo);
                    originalDocumentsInfo.setInvoiceStatus(FscBillStatus.NOT_INVOICED.getCode());
                    originalDocumentsInfo.setEffectiveState(PUSHED);
                    originalDocumentsInfo.setOrderId(originalOrderInfo.getOrderId());
                    log.info("\u539f\u59cb\u5355\u636e:{}", (Object)originalDocumentsInfo);
                    int insert = this.originalDocumentsInfoMapper.insert(originalDocumentsInfo);
                    List data = originalDocumentFromErp.getData();
                    String dataJsonString = JSON.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                    List originalDocumentsItemInfos = JSON.parseArray((String)dataJsonString, OriginalDocumentsItemInfo.class);
                    for (OriginalDocumentsItemInfo originalDocumentsItemInfo : originalDocumentsItemInfos) {
                        long nextId = Sequence.getInstance().nextId();
                        originalDocumentsItemInfo.setDocumentNo(originalDocumentFromErp.getDocumentNo());
                        originalDocumentsItemInfo.setId(String.valueOf(nextId));
                        originalDocumentsItemInfo.setEffectiveState(PUSHED);
                        originalDocumentsItemInfo.setOrderId(originalOrderInfo.getOrderId());
                        log.info("\u539f\u59cb\u5355\u636e\u8be6\u60c5\uff1a{}", (Object)originalDocumentsItemInfo);
                        int n = this.originalDocumentsItemInfoMapper.insert(originalDocumentsItemInfo);
                    }
                    PriceSettlementSummaryInfo priceSettlementSummaryInfo = new PriceSettlementSummaryInfo();
                    BeanUtils.copyProperties((Object)originalDocumentSummeryErp, (Object)priceSettlementSummaryInfo);
                    priceSettlementSummaryInfo.setEffectiveState(PUSHED);
                    priceSettlementSummaryInfo.setOrderId(originalOrderInfo.getOrderId());
                    priceSettlementSummaryInfo.setInvoiceStatus(FscBillStatus.NOT_INVOICED.getCode());
                    log.info("\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355:{}", (Object)priceSettlementSummaryInfo);
                    int insert1 = this.priceSettlementSummaryInfoMapper.insert(priceSettlementSummaryInfo);
                    List documentSummaries = originalDocumentSummeryErp.getData();
                    String documentSummariesJsonString = JSON.toJSONString((Object)documentSummaries, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                    List billSummaryInfos = JSON.parseArray((String)documentSummariesJsonString, BillSummaryInfo.class);
                    for (BillSummaryInfo billSummaryInfo : billSummaryInfos) {
                        billSummaryInfo.setEffectiveState(PUSHED);
                        long nextId = Sequence.getInstance().nextId();
                        billSummaryInfo.setId(String.valueOf(nextId));
                        billSummaryInfo.setInvoiceStatus(FscBillStatus.NOT_INVOICED.getCode());
                        log.info("\u6c47\u603b\u8be6\u60c5\uff1a{}", (Object)billSummaryInfo);
                        int n = this.billSummaryInfoMapper.insert(billSummaryInfo);
                    }
                    List documentDetails = originalDocumentDetailErp.getData();
                    String documentDetailsJsonString = JSON.toJSONString((Object)documentDetails, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                    List billDetailInfos = JSON.parseArray((String)documentDetailsJsonString, BillDetailInfo.class);
                    for (BillDetailInfo billDetailInfo : billDetailInfos) {
                        long nextId = Sequence.getInstance().nextId();
                        billDetailInfo.setId(String.valueOf(nextId));
                        billDetailInfo.setEffectiveState(PUSHED);
                        billDetailInfo.setInvoiceStatus(FscBillStatus.NOT_INVOICED.getCode());
                        log.info("\u660e\u7ec6\u8be6\u60c5:{}", (Object)billDetailInfo);
                        int n = this.billDetailInfoMapper.insert(billDetailInfo);
                    }
                    int n = this.originalOrderInfoMapper.updateStatusByOrderId(originalOrderInfo.getOrderId(), PUSHED);
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u91c7\u8d2d\u5165\u5e93\u53d1\u7968\u4fe1\u606f\u5f02\u5e38\uff0c\u8ba2\u5355\u53f7\uff1a[{}]\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)originalOrderInfo.getOrderId(), (Object)e);
                    e.printStackTrace();
                }
            }
        }
    }

    private BusiGetOriginalDocumentsRspBO getOriginalDocumentFromErp(BusiGetOriginalDocumentsReqBO reqBO) {
        HttpRetBean httpRetBean;
        try {
            String reqEsbStr = JSON.toJSONString((Object)reqBO);
            log.info("\u8bf7\u6c42\u5730\u5740:{}", (Object)this.ESB_GET_ORDER_INFO_SYNC_ERP_URL);
            log.info("\u8c03\u7528ERP\u83b7\u53d6\u91c7\u8d2d\u5165\u5e93\u4fe1\u606f\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587:{}", (Object)reqEsbStr);
            httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.ESB_GET_ORDER_INFO_SYNC_ERP_URL), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqEsbStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528ERP\u83b7\u53d6\u91c7\u8d2d\u5165\u5e93\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new PfscExternalBusinessException("18002", "\u8c03\u7528ERP\u83b7\u53d6\u91c7\u8d2d\u5165\u5e93\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38");
        }
        if (httpRetBean.getStatus() != 200) {
            log.error("\u8c03\u7528ERP\u83b7\u53d6\u91c7\u8d2d\u5165\u5e93\u4fe1\u606f\u63a5\u53e3\u5931\u8d25[http_status={}], [http_url={}]", (Object)httpRetBean.getStatus(), (Object)this.ESB_GET_ORDER_INFO_SYNC_ERP_URL);
            throw new RuntimeException("\u8c03\u7528ERP\u83b7\u53d6\u91c7\u8d2d\u5165\u5e93\u4fe1\u606f\u63a5\u53e3\u5931\u8d25");
        }
        log.info("\u8c03\u7528ERP\u83b7\u53d6\u91c7\u8d2d\u5165\u5e93\u4fe1\u606f\u63a5\u53e3\u54cd\u5e94\u62a5\u6587:{}", (Object)httpRetBean.getStr());
        String returnString = httpRetBean.getStr();
        if (StringUtils.isEmpty((Object)returnString)) {
            log.info("\u8c03\u7528ERP\u83b7\u53d6\u91c7\u8d2d\u5165\u5e93\u4fe1\u606f\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            throw new RuntimeException("\u8c03\u7528ERP\u83b7\u53d6\u91c7\u8d2d\u5165\u5e93\u4fe1\u606f\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        BusiGetOriginalDocumentsRspBO erpRsp = (BusiGetOriginalDocumentsRspBO)JSON.parseObject((String)returnString, BusiGetOriginalDocumentsRspBO.class);
        log.info("erp\u8fd4\u56de\u8f6c\u6362\u540erspBO:{}", (Object)erpRsp.toString());
        return erpRsp;
    }

    private OriginalDocumentSummaryInfoVO getOriginalDocumentSummeryErp(BusiGetOriginalDocumentsReqBO reqBO) {
        HttpRetBean httpRetBean;
        try {
            String reqEsbStr = JSON.toJSONString((Object)reqBO);
            log.info("\u8bf7\u6c42\u5730\u5740:{}", (Object)this.ESB_GET_ORDER_SUMMERY_SYNC_ERP_URL);
            log.info("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u6c47\u603b\uff09\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587:{}", (Object)reqEsbStr);
            httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.ESB_GET_ORDER_SUMMERY_SYNC_ERP_URL), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqEsbStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u6c47\u603b\uff09\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new PfscExternalBusinessException("18002", "\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u6c47\u603b\uff09\u63a5\u53e3\u5f02\u5e38");
        }
        if (httpRetBean.getStatus() != 200) {
            log.error("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u6c47\u603b\uff09\u63a5\u53e3\u5931\u8d25[http_status={}], [http_url={}]", (Object)httpRetBean.getStatus(), (Object)this.ESB_GET_ORDER_SUMMERY_SYNC_ERP_URL);
            throw new RuntimeException("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u6c47\u603b\uff09\u63a5\u53e3\u5931\u8d25");
        }
        log.info("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u6c47\u603b\uff09\u63a5\u53e3\u54cd\u5e94\u62a5\u6587:{}", (Object)httpRetBean.getStr());
        String returnString = httpRetBean.getStr();
        if (StringUtils.isEmpty((Object)returnString)) {
            log.info("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u6c47\u603b\uff09\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            throw new RuntimeException("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u6c47\u603b\uff09\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        OriginalDocumentSummaryInfoVO erpRsp = (OriginalDocumentSummaryInfoVO)JSON.parseObject((String)returnString, OriginalDocumentSummaryInfoVO.class);
        log.info("erp\u8fd4\u56de\u8f6c\u6362\u540erspBO:{}", (Object)erpRsp.toString());
        return erpRsp;
    }

    private OriginalDocumentDetailInfoVO getOriginalDocumentDetailErp(BusiGetOriginalDocumentsReqBO reqBO) {
        HttpRetBean httpRetBean;
        try {
            String reqEsbStr = JSON.toJSONString((Object)reqBO);
            log.info("\u8bf7\u6c42\u5730\u5740:{}", (Object)this.ESB_GET_ORDER_DETAIL_SYNC_ERP_URL);
            log.info("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u660e\u7ec6\uff09\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587:{}", (Object)reqEsbStr);
            httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.ESB_GET_ORDER_DETAIL_SYNC_ERP_URL), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqEsbStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u660e\u7ec6\uff09\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new PfscExternalBusinessException("18002", "\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u660e\u7ec6\uff09\u63a5\u53e3\u5f02\u5e38");
        }
        if (httpRetBean.getStatus() != 200) {
            log.error("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u660e\u7ec6\uff09\u63a5\u53e3\u5931\u8d25[http_status={}], [http_url={}]", (Object)httpRetBean.getStatus(), (Object)this.ESB_GET_ORDER_DETAIL_SYNC_ERP_URL);
            throw new RuntimeException("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u660e\u7ec6\uff09\u63a5\u53e3\u5931\u8d25");
        }
        log.info("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u660e\u7ec6\uff09\u63a5\u53e3\u54cd\u5e94\u62a5\u6587:{}", (Object)httpRetBean.getStr());
        String returnString = httpRetBean.getStr();
        if (StringUtils.isEmpty((Object)returnString)) {
            log.info("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u660e\u7ec6\uff09\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            throw new RuntimeException("\u8c03\u7528ERP\u83b7\u53d6\u4ef7\u683c\u7ed3\u7b97\u6c47\u603b\u5355\uff08\u6240\u6709\u660e\u7ec6\uff09\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        OriginalDocumentDetailInfoVO erpRsp = (OriginalDocumentDetailInfoVO)JSON.parseObject((String)returnString, OriginalDocumentDetailInfoVO.class);
        log.info("erp\u8fd4\u56de\u8f6c\u6362\u540erspBO:{}", (Object)erpRsp.toString());
        return erpRsp;
    }
}

