/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.BusiInvoiceProofreadService;
import com.tydic.pfscext.api.busi.bo.BusiInvoiceProofreadReqBO;
import com.tydic.pfscext.api.busi.bo.BusiInvoiceProofreadRspBO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiInvoiceProofreadService.class)
public class BusiInvoiceProofreadServiceImpl
implements BusiInvoiceProofreadService {
    private static final Logger log = LoggerFactory.getLogger(BusiInvoiceProofreadServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;

    public BusiInvoiceProofreadRspBO erpInvoiceProofread(BusiInvoiceProofreadReqBO busiInvoiceProofreadReqBO) {
        this.checkParams(busiInvoiceProofreadReqBO);
        BusiInvoiceProofreadRspBO busiInvoiceProofreadRspBO = new BusiInvoiceProofreadRspBO();
        BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(busiInvoiceProofreadReqBO.getExtPurInvoiceNo());
        if (billNotificationInfo != null) {
            String invoiceStatus = billNotificationInfo.getInvoiceStatus();
            boolean anyMatch = Arrays.asList("07", "08").stream().anyMatch(invoiceStatus::equals);
            if (!anyMatch) {
                throw new PfscExtBusinessException("\u5931\u8d25", "\u901a\u77e5\u5355\uff1a" + billNotificationInfo.getNotificationNo() + " \u72b6\u6001\u4e0d\u6b63\u786e,\u53ea\u6709\u3010\u5df2\u7b7e\u6536\u3011\u3001\u3010\u5ba1\u6838\u4e0d\u901a\u8fc7\u3011\u72b6\u6001\u624d\u53ef\u8fdb\u884c\u4fee\u6539\u72b6\u6001\u64cd\u4f5c");
            }
            if ("3".equals(busiInvoiceProofreadReqBO.getStatus())) {
                billNotificationInfo.setInvoiceStatus(NotificationInvoiceStatus.RECEIVED.getCode());
            } else if ("4".equals(busiInvoiceProofreadReqBO.getStatus())) {
                billNotificationInfo.setInvoiceStatus(NotificationInvoiceStatus.AUDIT_REJECTION.getCode());
            } else {
                log.error("status={}\uff0c\u4e0d\u4e3a (3,\u5ba1\u6838\u901a\u8fc7) or (4,\u5ba1\u6838\u4e0d\u901a\u8fc7)\u3002", (Object)busiInvoiceProofreadReqBO.getStatus());
                busiInvoiceProofreadRspBO.setRespCode("18003");
                busiInvoiceProofreadRspBO.setRespDesc("\u8fd4\u56de\u6570\u636e\u51fa\u9519\uff0cstatus=" + busiInvoiceProofreadReqBO.getStatus() + ",\u4e0d\u662f\u671f\u671b\u53c2\u6570");
                busiInvoiceProofreadRspBO.setRemark("\u8fd4\u56de\u6570\u636e\u51fa\u9519\uff0cstatus=" + busiInvoiceProofreadReqBO.getStatus() + ",\u4e0d\u662f\u671f\u671b\u53c2\u6570");
                return busiInvoiceProofreadRspBO;
            }
            this.billNotificationInfoMapper.updateByPrimaryKey(billNotificationInfo);
            log.debug("fsc-\u8c03\u8bd5\uff1a\u66f4\u65b0result={}", (Object)billNotificationInfo);
            busiInvoiceProofreadRspBO.setRespCode("0000");
            busiInvoiceProofreadRspBO.setRespDesc("\u66f4\u65b0\u6210\u529f");
            busiInvoiceProofreadRspBO.setRemark("\u66f4\u65b0\u6210\u529f");
        } else {
            log.error("ExtPurInvoiceNo\u53d1\u7968\u53f7\u672a\u67e5\u8be2\u5230\u6570\u636e");
            busiInvoiceProofreadRspBO.setRespCode("18000");
            busiInvoiceProofreadRspBO.setRespDesc("\u6839\u636evbillcode = " + busiInvoiceProofreadReqBO.getExtPurInvoiceNo() + ",\u672a\u67e5\u8be2\u5230\u6570\u636e");
            busiInvoiceProofreadRspBO.setRemark("\u6839\u636evbillcode = " + busiInvoiceProofreadReqBO.getExtPurInvoiceNo() + ",\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        return busiInvoiceProofreadRspBO;
    }

    private void checkParams(BusiInvoiceProofreadReqBO busiInvoiceProofreadReqBO) {
        if (StringUtils.isEmpty((Object)busiInvoiceProofreadReqBO.getExtPurInvoiceNo())) {
            log.error("\u66f4\u65b0\u5f00\u7968\u72b6\u6001\u51fa\u9519");
            throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u5931\u8d25\uff0c\u53d1\u7968\u53f7\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)busiInvoiceProofreadReqBO.getStatus())) {
            log.error("\u66f4\u65b0\u5f00\u7968\u72b6\u6001\u51fa\u9519");
            throw new PfscExtBusinessException("\u5931\u8d25", "\u66f4\u65b0\u5931\u8d25\uff0c\u72b6\u6001\u7801\u4e3a\u7a7a\uff01");
        }
    }
}

