/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.FscDictionaryBusiService;
import com.tydic.pfscext.api.busi.bo.FscDictionaryBusiReqBo;
import com.tydic.pfscext.api.busi.bo.FscDictionaryBusiRspBo;
import com.tydic.pfscext.api.busi.bo.FscDictionaryBusiRspDataBo;
import com.tydic.pfscext.api.busi.bo.FscDictionaryCreateBusiReqBO;
import com.tydic.pfscext.api.busi.bo.FscDictionaryCreateBusiRspBO;
import com.tydic.pfscext.api.busi.bo.FscDictionaryDeleteBusiReqBO;
import com.tydic.pfscext.api.busi.bo.FscDictionaryDeleteBusiRspBO;
import com.tydic.pfscext.api.busi.bo.FscDictionaryUpdateBusiReqBO;
import com.tydic.pfscext.api.busi.bo.FscDictionaryUpdateBusiRspBO;
import com.tydic.pfscext.dao.DicDictionaryMapper;
import com.tydic.pfscext.dao.bo.DicDictionaryPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscDictionaryBusiService.class)
public class FscDictionaryBusiServiceImpl
implements FscDictionaryBusiService {
    private final DicDictionaryMapper dicDictionaryMapper;
    private static final Integer EFFECTIVE = 0;
    private static final String SYS_CODE = "FSC";

    @Autowired
    public FscDictionaryBusiServiceImpl(DicDictionaryMapper dicDictionaryMapper) {
        this.dicDictionaryMapper = dicDictionaryMapper;
    }

    public FscDictionaryBusiRspBo qryDic(FscDictionaryBusiReqBo reqBo) {
        FscDictionaryBusiRspBo retBo = new FscDictionaryBusiRspBo();
        String validateArgStr = this.validateQryArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("18054");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        ArrayList<FscDictionaryBusiRspDataBo> datas = new ArrayList<FscDictionaryBusiRspDataBo>();
        DicDictionaryPO qryPo = new DicDictionaryPO();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryPo);
        qryPo.setDelFlag(EFFECTIVE);
        qryPo.setOrderBy(" ORDER_ID ASC");
        List<DicDictionaryPO> listByCondition = this.dicDictionaryMapper.getListByCondition(qryPo);
        for (DicDictionaryPO po : listByCondition) {
            if (po == null) continue;
            FscDictionaryBusiRspDataBo dictionaryBusiRspDataBo = new FscDictionaryBusiRspDataBo();
            BeanUtils.copyProperties((Object)po, (Object)dictionaryBusiRspDataBo);
            datas.add(dictionaryBusiRspDataBo);
        }
        retBo.setRows(datas);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateQryArg(FscDictionaryBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getpCode())) {
            return "pCode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    public FscDictionaryCreateBusiRspBO createDic(FscDictionaryCreateBusiReqBO reqBO) {
        int insert;
        FscDictionaryCreateBusiRspBO rspBO = new FscDictionaryCreateBusiRspBO();
        String validateArgStr = this.validateCreateArg(reqBO);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBO.setRespCode("18055");
            rspBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBO;
        }
        boolean exist = this.checkExist(reqBO);
        if (exist) {
            rspBO.setRespCode("18055");
            rspBO.setRespDesc("\u8be5\u5b57\u5178\u7f16\u7801\u5df2\u5b58\u5728\uff01");
            return rspBO;
        }
        DicDictionaryPO dicDictionaryPO = new DicDictionaryPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)dicDictionaryPO);
        dicDictionaryPO.setDelFlag(EFFECTIVE);
        dicDictionaryPO.setCreateUid(reqBO.getUserId());
        dicDictionaryPO.setCreateTm(new Date());
        dicDictionaryPO.setSysCode(SYS_CODE);
        if (null == dicDictionaryPO.getOrderId()) {
            DicDictionaryPO dictionaryPO = new DicDictionaryPO();
            dictionaryPO.setPCode(reqBO.getpCode());
            dictionaryPO.setCode(reqBO.getCode());
            Integer max = this.dicDictionaryMapper.getMaxOrderId(dictionaryPO);
            dicDictionaryPO.setOrderId(null == max ? 0 : max + 1);
        }
        if ((insert = this.dicDictionaryMapper.insert(dicDictionaryPO)) < 1) {
            rspBO.setRespCode("18055");
            rspBO.setRespDesc("\u65b0\u589e\u5b57\u5178\u503c\u5931\u8d25");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private boolean checkExist(FscDictionaryCreateBusiReqBO reqBO) {
        boolean existFlag = false;
        DicDictionaryPO dicDictionaryPO = new DicDictionaryPO();
        dicDictionaryPO.setPCode(reqBO.getpCode());
        dicDictionaryPO.setCode(reqBO.getCode());
        DicDictionaryPO model = this.dicDictionaryMapper.getModelByCondition(dicDictionaryPO);
        if (null != model) {
            existFlag = true;
        }
        return existFlag;
    }

    private String validateCreateArg(FscDictionaryCreateBusiReqBO reqBO) {
        if (reqBO == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBO.getpCode())) {
            return "pCode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBO.getCode())) {
            return "code\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBO.getTitle())) {
            return "title\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    public FscDictionaryUpdateBusiRspBO updateDic(FscDictionaryUpdateBusiReqBO reqBO) {
        FscDictionaryUpdateBusiRspBO rspBO = new FscDictionaryUpdateBusiRspBO();
        String validateArgStr = this.validateUpdateArg(reqBO);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBO.setRespCode("18056");
            rspBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBO;
        }
        DicDictionaryPO dicDictionaryPO = new DicDictionaryPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)dicDictionaryPO);
        dicDictionaryPO.setUpdateTm(new Date());
        dicDictionaryPO.setUpdateUid(reqBO.getUserId());
        int update = this.dicDictionaryMapper.updateByCondition(dicDictionaryPO);
        if (update < 1) {
            rspBO.setRespCode("18056");
            rspBO.setRespDesc("\u4fee\u6539\u5b57\u5178\u503c\u5931\u8d25");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String validateUpdateArg(FscDictionaryUpdateBusiReqBO reqBO) {
        if (reqBO == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBO.getpCode())) {
            return "pCode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBO.getCode())) {
            return "code\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBO.getDescrip()) && !StringUtils.hasText((String)reqBO.getTitle()) && null == reqBO.getOrderId()) {
            return "descrip\u3001title\u3001orderId\u4e0d\u80fd\u90fd\u4e3a\u7a7a";
        }
        return null;
    }

    public FscDictionaryDeleteBusiRspBO deleteDic(FscDictionaryDeleteBusiReqBO reqBO) {
        FscDictionaryDeleteBusiRspBO rspBO = new FscDictionaryDeleteBusiRspBO();
        String validateArgStr = this.validateDeleteArg(reqBO);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBO.setRespCode("18057");
            rspBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBO;
        }
        DicDictionaryPO dicDictionaryPO = new DicDictionaryPO();
        dicDictionaryPO.setCode(reqBO.getCode());
        dicDictionaryPO.setPCode(reqBO.getpCode());
        int update = this.dicDictionaryMapper.deleteByCondition(dicDictionaryPO);
        if (update < 1) {
            rspBO.setRespCode("18057");
            rspBO.setRespDesc("\u5220\u9664\u5b57\u5178\u503c\u5931\u8d25");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String validateDeleteArg(FscDictionaryDeleteBusiReqBO reqBO) {
        if (reqBO == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBO.getpCode())) {
            return "pCode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBO.getCode())) {
            return "code\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

