/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.atom;

import com.ohaotian.plugin.file.FileProcessing;
import com.tydic.pfscext.dao.AcctCheckingResultMapper;
import com.tydic.pfscext.dao.AcctPinganDataArchiveMapper;
import com.tydic.pfscext.dao.AcctPinganDataMapper;
import com.tydic.pfscext.dao.AdvanceReceiveMapper;
import com.tydic.pfscext.dao.bo.TranDetailExt;
import com.tydic.pfscext.dao.po.AcctCheckingResult;
import com.tydic.pfscext.dao.po.AcctPinganData;
import com.tydic.pfscext.dao.vo.AdvanceReceiveVO;
import com.tydic.pfscext.enums.BusinessType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.PingAnCustIDService;
import com.tydic.pfscext.utils.PingAnBankAcCheckingFile;
import com.tydic.pfscext.utils.Rnd;
import com.tydic.pfscext.utils.SftpClient;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="pingAnAcTranDataService")
public class PingAnAcTranDataService {
    private static final Logger logger = LoggerFactory.getLogger(PingAnAcTranDataService.class);
    private static final Integer CHECK_DELAY_DETAIL = 4;
    private static final Integer CHECK_TIME_DETAIL = 3;
    private static final Integer CHECK_ERR_DETAIL = 2;
    private static final Integer CHECK_INDEX = 1;
    private static final String SFTP_PARAM = "${";
    private static final String ACTTYPE_0 = "0";
    private static final String ACTTYPE_1 = "1";
    private static final String ACTTYPE_2 = "2";
    private static final String ACTTYPE_3 = "3";
    private static final String FILE_NAME_CONTAIN = "zhuanru";
    @Autowired
    private AcctPinganDataMapper acctPinganDataMapper;
    @Autowired
    private AcctPinganDataArchiveMapper acctPinganDataArchiveMapper;
    @Autowired
    private AcctCheckingResultMapper resultMapper;
    @Autowired
    private AdvanceReceiveMapper advanceReceiveMapper;
    @Autowired(required=false)
    private PingAnCustIDService pingAnCustIDService;
    @Value(value="${sftp.accounting.host}")
    private String host = "";
    @Value(value="${sftp.accounting.host2}")
    private String host2 = "";
    @Value(value="${sftp.accounting.port}")
    private String hostPort = "22";
    @Value(value="${sftp.accounting.user}")
    private String userName = "tomcat";
    @Value(value="${sftp.accounting.password}")
    private String password;
    @Value(value="${sftp.accounting.dir}")
    private String filePath;
    @Value(value="${sftp.accounting.fileFilter}")
    private String filesFilter = "pab_%s_%s_*.txt";
    @Value(value="${sftp.accounting.directLinkHost}")
    private String directLinkHost;
    @Value(value="${sftp.accounting.directLinkPort}")
    private String directLinkPort;
    @Value(value="${sftp.accounting.directLinkUser}")
    private String directLinkUser;
    @Value(value="${sftp.accounting.directLinkPassword}")
    private String directLinkPassword;
    @Value(value="${sftp.accounting.directLinkDir}")
    private String directLinkDir;
    @Value(value="${sftp.accounting.directLinkFileFilter}")
    private String directLinkFileFilter;
    private List<AcctCheckingResult> timeDelayRecords;

    public void process(Date postDate, String actType) {
        if (postDate == null) {
            postDate = this.getYestoday(null);
        }
        String dt = this.dateToStr(postDate, "yyyyMMdd");
        this.process(dt, "", actType);
    }

    public void process(String yyyyMMddDate, String actType) {
        this.process(yyyyMMddDate, "", actType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String yyyyMMddDate, String custId, String actType) {
        if (!StringUtils.hasText((String)custId)) {
            custId = this.pingAnCustIDService.getCustID();
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
        Date postDate = null;
        try {
            postDate = fmt.parse(yyyyMMddDate);
        }
        catch (ParseException e) {
            logger.error("\u5bf9\u8d26\u5904\u7406\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\uff1a{}", (Object)e.toString());
        }
        logger.debug("<<<< =========\u5e73\u5b89\u94f6\u884c\u6570\u636e\u5bf9\u8d26\u5904\u7406===== >>>> CUSTID=" + custId + " \u5bf9\u8d26\u65e5\u671f=" + yyyyMMddDate + " actType=" + actType);
        if (this.hostPort == null || this.hostPort.contains(SFTP_PARAM)) {
            logger.error("-----env.property\u4e2d\u672a\u5b9a\u4e49SFTP\u76f8\u5173\u7684\u53c2\u6570 sftp.accounting.port");
            return;
        }
        if (actType != null && actType.contains(ACTTYPE_0)) {
            this.clearAccountingResult(postDate);
        }
        AcctCheckingResult result = new AcctCheckingResult();
        result.setCheckDate(postDate);
        int hisCnt = this.resultMapper.countResult(result);
        if (hisCnt > 0) {
            logger.debug("\u653e\u5f03\u5bf9\u8d26\u5904\u7406,\u5df2\u7ecf\u5b58\u5728" + yyyyMMddDate + "\u7684\u5bf9\u8d26\u7ed3\u679c\u6570\u636e" + hisCnt + "\u7b14.");
            return;
        }
        long[] flagIds = this.launchAllowCheck(result);
        if (flagIds == null) {
            return;
        }
        if (actType == null || actType.contains(ACTTYPE_1)) {
            logger.debug("\u5bf9\u8d26\u5904\u7406,\u51c6\u5907\u6e05\u7a7a\u5e73\u5b89\u5bf9\u8d26\u6570\u636e\u8868");
            long tick = System.currentTimeMillis();
            try {
                this.acctPinganDataArchiveMapper.archive();
            }
            catch (Exception e) {
                logger.error("\u5f52\u6863\u5931\u8d25", (Throwable)e);
                throw new PfscExtBusinessException("18000", "\u63d2\u5165\u8868\uff1ad_acct_pingan_data_archive\u5f02\u5e38", e);
            }
            int clearCnt = this.acctPinganDataMapper.clearAll();
            logger.debug("** \u5e73\u5b89\u5bf9\u8d26\u65e7\u6570\u636e\u6e05\u7a7a\u5b8c\u6210,\u8bb0\u5f55\u6570=" + clearCnt + ",\u8017\u65f6" + (System.currentTimeMillis() - tick) + "ms");
        }
        try {
            if (actType == null || actType.contains(ACTTYPE_2)) {
                this.loadTimeDelayRecords(postDate);
                int fileCount = this.doanloadAndImportFiles(postDate, yyyyMMddDate, custId);
                if (fileCount == 0) {
                    logger.debug("\u5bf9\u8d26\u5904\u7406\uff0c\u672a\u53d1\u73b0\u6709\u6548\u7684\u6570\u636e\u6587\u4ef6,\u9000\u51fa\u5904\u7406!!!!!!,\u5bf9\u8d26\u65e5\u671f=" + yyyyMMddDate);
                    return;
                }
                this.updateTimeDelayRecords();
            }
            if (actType == null || actType.contains(ACTTYPE_3)) {
                int err = 0;
                err += this.checkBankData(postDate);
                result = new AcctCheckingResult();
                result.setResultType(CHECK_INDEX);
                result.setCreatedDate(new Date());
                result.setCheckDate(postDate);
                result.setDataCount(Long.valueOf(err += this.checkTranDate(postDate)));
                if (err == 0) {
                    result.setRemark("\u5bf9\u8d26\u6210\u529f\u65e0\u9519\u8d26");
                } else {
                    result.setRemark("\u5bf9\u8d26\u53d1\u73b0" + err + "\u7b14\u9519\u8d26");
                }
                logger.debug("\u51c6\u5907\u5efa\u7acb\u5bf9\u8d26\u7ed3\u679c\u6c47\u603b\u8bb0\u5f55,\u9519\u8d26\u6570=" + err);
                this.resultMapper.insert(result);
            }
        }
        finally {
            this.clearExecutePermisionFlags(postDate, flagIds);
        }
        logger.debug("<<<< \u5bf9\u8d26\u5904\u7406\u5168\u90e8\u5b8c\u6210 >>>>");
    }

    private void loadTimeDelayRecords(Date postDate) {
        AcctCheckingResult record = new AcctCheckingResult();
        postDate = this.getYestoday(postDate);
        record.setCheckDate(postDate);
        record.setResultType(CHECK_TIME_DETAIL);
        this.timeDelayRecords = this.resultMapper.selectSelective(record);
        logger.debug("\u5bf9\u8d26,\u8f7d\u5165\u65f6\u5dee\u7ed3\u679c\u6570\u636e,\u8bb0\u5f55\u6570=" + this.timeDelayRecords.size() + ",\u65f6\u5dee\u65e5\u671f=" + postDate);
    }

    private void clearExecutePermisionFlags(Date postDate, long[] flagIds) {
        if (flagIds == null) {
            return;
        }
        logger.debug("\u51c6\u5907\u6e05\u9664\u5360\u6743\u6807\u5fd7\u8bb0\u5f55,ids=" + Arrays.toString(flagIds));
        if (flagIds.length == 0) {
            return;
        }
        AcctCheckingResult result = new AcctCheckingResult();
        result.setResultType(9);
        result.setCheckDate(postDate);
        for (long flagId : flagIds) {
            result.setId(flagId);
            this.resultMapper.clearDayResult(result);
        }
        logger.debug("-------\u6e05\u9664\u5360\u6743\u6807\u5fd7\u8bb0\u5f55\u5b8c\u6bd5");
    }

    private void clearAccountingResult(Date postDate) {
        logger.debug("\u5bf9\u8d26\u5904\u7406,\u6e05\u9664\u5bf9\u8d26\u7ed3\u679c\u6570\u636e,\u5bf9\u8d26\u65e5\u671f=" + postDate);
        AcctCheckingResult result = new AcctCheckingResult();
        result.setCheckDate(postDate);
        int cnt = this.resultMapper.clearDayResult(result);
        logger.debug("------\u6e05\u9664\u5bf9\u8d26\u7ed3\u679c\u6570\u636e\u5b8c\u6bd5,\u8bb0\u5f55\u6570=" + cnt);
    }

    private void checkTimeDelayRecords(String ssn) {
        for (AcctCheckingResult rec : this.timeDelayRecords) {
            if (!rec.getBankSsn().equals(ssn)) continue;
            rec.setResultType(CHECK_DELAY_DETAIL);
        }
    }

    private void updateTimeDelayRecords() {
        int err = 0;
        int size = this.timeDelayRecords.size();
        if (size == 0) {
            return;
        }
        for (AcctCheckingResult rec : this.timeDelayRecords) {
            if (rec.getResultType().equals(CHECK_DELAY_DETAIL)) {
                rec.setResultType(CHECK_ERR_DETAIL);
                ++err;
            }
            AcctCheckingResult param = new AcctCheckingResult();
            param.setId(rec.getId());
            param.setResultType(rec.getResultType());
            this.resultMapper.updateByPrimaryKeySelective(param);
        }
        logger.debug("\u5bf9\u8d26,\u66f4\u65b0\u65f6\u5dee\u7ed3\u679c,\u88ab\u8f6c\u6210\u9519\u8d26\u7684\u8bb0\u5f55 " + err + "/" + size);
        this.timeDelayRecords.clear();
    }

    private int doanloadAndImportFiles(Date postDate, String yyyyMMddDate, String custId) {
        String filter = String.format(this.filesFilter, custId, yyyyMMddDate);
        logger.debug("** \u5f00\u59cb\u5904\u7406\u5bf9\u8d26\u6570\u636e\u6587\u4ef6,\u5bf9\u8d26\u65e5\u671f=" + yyyyMMddDate + ",\u5ba2\u6237\u7801=" + custId);
        SftpClient ftp = new SftpClient();
        int port = Integer.valueOf(this.hostPort);
        ftp.connect(this.host, port, this.userName, this.password, this.filePath);
        List<String> files = ftp.list("", filter);
        int allTot = 0;
        int fileCount = files.size();
        logger.debug("\u67e5\u627e\u7b26\u5408\u6761\u4ef6\u7684\u5bf9\u8d26\u6570\u636e\u6587\u4ef6,\u6587\u4ef6\u6570\u91cf=" + fileCount);
        long tick = System.currentTimeMillis();
        for (int i = 0; i < fileCount; ++i) {
            String fn = files.get(i);
            logger.debug(i + 1 + ") \u51c6\u5907\u4e0b\u8f7d\u5bf9\u8d26\u6570\u636e\u6587\u4ef6 " + fn);
            byte[] buf = ftp.download(fn);
            PingAnBankAcCheckingFile f = new PingAnBankAcCheckingFile();
            f.setFilename(fn);
            if (f.open(buf, true)) {
                logger.debug("----\u4e0b\u8f7d\u5b8c\u6210,\u5f00\u59cb\u5bfc\u5165\u6570\u636e\u6587\u4ef6,\u6587\u4ef6=" + fn);
                allTot += this.importData(f, postDate, i + 1);
            } else {
                logger.error("----\u6253\u5f00\u5bf9\u8d26\u6587\u4ef6\u5931\u8d25,\u6587\u4ef6=" + fn);
            }
            f.close();
        }
        files.clear();
        if (StringUtils.hasText((String)this.host2) && !this.host2.startsWith(SFTP_PARAM)) {
            ftp = new SftpClient();
            ftp.connect(this.host2, port, this.userName, this.password, this.filePath);
            files = ftp.list("", filter);
            int fileCount2 = files.size();
            logger.debug("\u67e5\u627e\u7b26\u5408\u6761\u4ef6\u7684\u5bf9\u8d26\u6570\u636e\u6587\u4ef6,\u6587\u4ef6\u6570\u91cf=" + fileCount2);
            for (int i = 0; i < fileCount2; ++i) {
                String fn = files.get(i);
                logger.debug(i + 1 + ") \u51c6\u5907\u4e0b\u8f7d\u5bf9\u8d26\u6570\u636e\u6587\u4ef6 " + fn);
                byte[] buf = ftp.download(fn);
                PingAnBankAcCheckingFile f = new PingAnBankAcCheckingFile();
                f.setFilename(fn);
                if (f.open(buf, true)) {
                    logger.debug("----\u4e0b\u8f7d\u5b8c\u6210,\u5f00\u59cb\u5bfc\u5165\u6570\u636e\u6587\u4ef6,\u6587\u4ef6=" + fn);
                    allTot += this.importData(f, postDate, fileCount + i + 1);
                } else {
                    logger.error("----\u6253\u5f00\u5bf9\u8d26\u6587\u4ef6\u5931\u8d25,\u6587\u4ef6=" + fn);
                }
                f.close();
            }
            fileCount += fileCount2;
        }
        logger.info("** \u6240\u6709\u5bf9\u8d26\u6570\u636e\u6587\u4ef6\u5bfc\u5165\u5904\u7406\u5b8c\u6bd5,\u603b\u8bb0\u5f55\u6570=" + allTot + ",\u603b\u8017\u65f6=" + (System.currentTimeMillis() - tick));
        return fileCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int downloadAndUploadReceipts(Set<String> hexlshSet) {
        SftpClient ftp = new SftpClient();
        ftp.connect(this.directLinkHost, Integer.valueOf(this.directLinkPort), this.directLinkUser, this.directLinkPassword, this.directLinkDir);
        String filter = this.directLinkFileFilter;
        List<String> fileNames = ftp.list("", filter);
        int fileCount = fileNames.size();
        logger.debug("zip\u6587\u4ef6\u6570\uff1a" + fileCount);
        long tick = System.currentTimeMillis();
        for (String fileName : fileNames) {
            Throwable throwable;
            byte[] buf = ftp.download(fileName);
            File file = new File(fileName);
            try {
                throwable = null;
                try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));){
                    ((OutputStream)outputStream).write(buf);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Exception e) {
                logger.error("\u751f\u6210\u6587\u4ef6\u5931\u8d25\u3002\u6587\u4ef6\u540d\uff1a" + fileName, (Throwable)e);
                continue;
            }
            try {
                ZipFile zipFile = new ZipFile(file, Charset.forName("GBK"));
                throwable = null;
                try {
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        String newReceiptFileName;
                        ZipEntry zipEntry = entries.nextElement();
                        if (zipEntry.isDirectory()) continue;
                        String receiptFileName = zipEntry.getName();
                        logger.debug("\u56de\u5355\u6587\u4ef6\u540d\uff1a" + receiptFileName);
                        boolean matchFlag = false;
                        String hexlsh = null;
                        Iterator<String> iterator = hexlshSet.iterator();
                        while (iterator.hasNext()) {
                            hexlsh = iterator.next();
                            if (!StringUtils.hasText((String)hexlsh) || !receiptFileName.contains(hexlsh)) continue;
                            matchFlag = true;
                            iterator.remove();
                            break;
                        }
                        if (!matchFlag) continue;
                        InputStream inputStream = null;
                        try {
                            inputStream = zipFile.getInputStream(zipEntry);
                            newReceiptFileName = FileProcessing.uploadFileByInputStream((String)receiptFileName, (InputStream)inputStream, (String)"", (String)"PAY", (boolean)false);
                        }
                        catch (Exception e) {
                            logger.error("\u4e0a\u4f20\u6587\u4ef6\u5230OSS\u5931\u8d25\u3002\u56de\u5355\u6587\u4ef6\u540d\uff1a" + receiptFileName, (Throwable)e);
                            continue;
                        }
                        finally {
                            try {
                                zipFile.close();
                            }
                            catch (IOException e) {
                                logger.error("\u5173\u95ed\u8f93\u5165\u6d41zipFile\u51fa\u9519", (Throwable)e);
                            }
                            if (inputStream == null) continue;
                            try {
                                inputStream.close();
                            }
                            catch (IOException e) {
                                logger.error("\u5173\u95ed\u8f93\u5165\u6d41\u51fa\u9519", (Throwable)e);
                            }
                            continue;
                        }
                        if (!StringUtils.hasText((String)newReceiptFileName)) continue;
                        AdvanceReceiveVO vo = new AdvanceReceiveVO();
                        vo.setHexlsh(hexlsh);
                        vo.setReceipt(receiptFileName);
                        int count = this.advanceReceiveMapper.updateByCondition(vo);
                        if (count == 1) continue;
                        logger.error("\u4fdd\u5b58\u56de\u5355\u6587\u4ef6\u540d\u5931\u8d25\u3002\u56de\u5355\u6587\u4ef6\u540d\uff1a" + receiptFileName + "\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a" + count);
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (zipFile == null) continue;
                    if (throwable != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    zipFile.close();
                }
            }
            catch (IOException e) {
                logger.error("\u751f\u6210\u6587\u4ef6\u5931\u8d25\u3002\u6587\u4ef6\u540d\uff1a" + fileName, (Throwable)e);
            }
        }
        logger.debug("\u5904\u7406\u5b8c\u6bd5,\u603b\u8017\u65f6=" + (System.currentTimeMillis() - tick));
        return fileCount;
    }

    private int importData(PingAnBankAcCheckingFile paFile, Date postDate, int fileIndex) {
        List<String[]> datas;
        int size;
        String fileName = paFile.getFilename();
        boolean forAcIn = true;
        int id = 1;
        if (!fileName.contains(FILE_NAME_CONTAIN)) {
            forAcIn = false;
            id = 2;
        }
        id = (id * 100 + fileIndex) * 1000000;
        String mainAcctNo = paFile.getMainAcctNo();
        logger.debug("\u6210\u529f\u6253\u5f00\u6570\u636e\u6587\u4ef6,\u8d77\u59cb\u5e8f\u53f7=" + id + ",\u4e3b\u8d26\u53f7=" + mainAcctNo + ",\u8bb0\u5f55\u6570=" + paFile.getTotalCount() + ",fileName=" + fileName);
        int tot = 0;
        int cnt = 0;
        int batchCnt = 1000;
        long tick = System.currentTimeMillis();
        ArrayList<AcctPinganData> records = new ArrayList<AcctPinganData>();
        while ((size = (datas = paFile.load()).size()) != 0) {
            tot += size;
            for (String[] fields : datas) {
                AcctPinganData rec = new AcctPinganData();
                records.add(rec);
                rec.setId(++id);
                rec.setTxnAmt(paFile.getTxnAmt(fields));
                rec.setTxnDate(postDate);
                rec.setMainAcctNo(mainAcctNo);
                String payAcctNo = paFile.getPayAcctNo(fields);
                String recvAcctNo = paFile.getRecvAcctNo(fields);
                rec.setMasterAcctNo(payAcctNo);
                rec.setRelateAcctNo(recvAcctNo);
                if (forAcIn) {
                    rec.setTranDir(1);
                    rec.setBankSsn(paFile.getBusiSsn(fields));
                } else {
                    rec.setTranDir(2);
                    rec.setBankSsn(paFile.getSsn(fields));
                    this.checkTimeDelayRecords(rec.getBankSsn());
                }
                if (++cnt < batchCnt) continue;
                this.batchSubmitData(records);
                cnt = 0;
            }
        }
        this.batchSubmitData(records);
        logger.debug("\u5e73\u5b89\u94f6\u884c\u6570\u636e\u6587\u4ef6\u5bfc\u5165\u5b8c\u6210,\u5b9e\u9645\u8bb0\u5f55\u6570=" + tot + ",\u8017\u65f6:" + (System.currentTimeMillis() - tick) + "ms,fileName=" + fileName);
        return tot;
    }

    private void batchSubmitData(List<AcctPinganData> datas) {
        int size = datas.size();
        if (size == 0) {
            return;
        }
        long tick = System.currentTimeMillis();
        logger.debug("\u51c6\u5907\u6279\u91cf\u63d2\u5165\u5e73\u5b89\u6570\u636e,size=" + size);
        this.acctPinganDataMapper.insertByBatch(datas);
        logger.debug("-----\u5e73\u5b89\u6570\u636e\u63d2\u5165\u5b8c\u6210,\u8017\u65f6=" + (System.currentTimeMillis() - tick));
        datas.clear();
    }

    private void batchSubmitResult(List<AcctCheckingResult> results, String descr) {
        int size = results.size();
        if (size == 0) {
            return;
        }
        logger.debug("\u6279\u91cf\u63d2\u5165\u5bf9\u8d26\u7ed3\u679c-" + descr + ",\u8bb0\u5f55\u6570=" + size);
        this.resultMapper.insertByBatch(results);
        logger.debug("-----\u63d2\u5165\u5bf9\u8d26\u7ed3\u679c\u6570\u636e\u5b8c\u6210");
        results.clear();
    }

    private int checkBankData(Date postDate) {
        logger.debug("\u5bf9\u8d26,\u51c6\u5907\u67e5\u8be2[\u94f6\u6709\u6211\u65e0]\u7684\u8bb0\u5f55");
        long tick = System.currentTimeMillis();
        List<AcctPinganData> rows = this.acctPinganDataMapper.queryTranAbsence();
        AcctCheckingResult result = null;
        ArrayList<AcctCheckingResult> resultLs = new ArrayList<AcctCheckingResult>();
        int size = rows.size();
        logger.debug("----\u67e5\u8be2[\u94f6\u6709\u6211\u65e0]\u7684\u8bb0\u5f55\u5b8c\u6210,\u8bb0\u5f55\u6570=" + size + ",\u8017\u65f6=" + (System.currentTimeMillis() - tick) + "ms");
        for (AcctPinganData data : rows) {
            result = new AcctCheckingResult();
            resultLs.add(result);
            result.setResultType(CHECK_ERR_DETAIL);
            result.setCreatedDate(new Date());
            result.setCheckDate(postDate);
            result.setDataCount(1L);
            result.setBankSsn(data.getBankSsn());
            result.setAmount(data.getTxnAmt());
            result.setMainAcctNo(data.getMainAcctNo());
            result.setSubAcctNo(data.getMasterAcctNo() + "/" + data.getRelateAcctNo());
            if (data.getTranDir() == 1) {
                result.setDrCr("CR");
                result.setRemark("\u94f6\u884c\u6709,\u6211\u65e0\u5165\u8d26\u8bb0\u5f55");
                continue;
            }
            result.setDrCr("DR");
            result.setRemark("\u94f6\u884c\u6709,\u6211\u65e0\u51fa\u8d26\u8bb0\u5f55");
        }
        this.batchSubmitResult(resultLs, "[\u94f6\u884c\u6709\u6211\u65e0]\u9519\u8d26\u4ea4\u6613\u660e\u7ec6\u6570\u636e");
        logger.debug("\u5bf9\u8d26,[\u94f6\u884c\u6709\u6211\u65e0] \u9519\u8d26\u8bb0\u5f55\u5904\u7406\u5b8c\u6210");
        return size;
    }

    private int checkTranDate(Date postDate) {
        TranDetailExt tranDetail = new TranDetailExt();
        tranDetail.setTranDateStart(postDate);
        Date tranDateEnd = null;
        try {
            tranDateEnd = new SimpleDateFormat("yyyyMMddHHmmss").parse(new SimpleDateFormat("yyyyMMdd").format(postDate) + "235959");
        }
        catch (ParseException e) {
            logger.error("\u65e5\u671f\u8f6c\u6362\u51fa\u9519", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u65e5\u671f\u8f6c\u6362\u51fa\u9519");
        }
        tranDetail.setTranDateEnd(tranDateEnd);
        ArrayList<AcctCheckingResult> resultLs = new ArrayList<AcctCheckingResult>();
        AcctCheckingResult result = null;
        logger.debug("\u5bf9\u8d26,\u51c6\u5907\u67e5\u8be2[\u6211\u6709\u94f6\u884c\u65e0]\u7684\u8bb0\u5f55\u6570");
        long tick = System.currentTimeMillis();
        List<TranDetailExt> ls = this.acctPinganDataMapper.queryBankAbsence(tranDetail);
        int size = ls.size();
        logger.debug("-----\u67e5\u8be2[\u6211\u6709\u94f6\u884c\u65e0]\u7684\u8bb0\u5f55\u5b8c\u6210,\u8bb0\u5f55\u6570=" + size + ",\u8017\u65f6=" + (System.currentTimeMillis() - tick) + "ms");
        for (TranDetailExt data : ls) {
            result = new AcctCheckingResult();
            resultLs.add(result);
            result.setResultType(CHECK_ERR_DETAIL);
            result.setCreatedDate(new Date());
            result.setCheckDate(postDate);
            result.setDataCount(1L);
            result.setAmount(data.getTranAmt());
            result.setMainAcctNo(data.getMainAcctNo());
            result.setSubAcctNo(data.getPayAcctNo() + "/" + data.getRecvAcctNo());
            result.setTxnNo("" + data.getTxnNo());
            String busiDescr = data.getBusinessType();
            BusinessType busiType = BusinessType.getInstance(busiDescr);
            if (busiType != null) {
                busiDescr = busiType.getDescr();
            }
            int tranDir = 0;
            if (data.getRowIndex() != null) {
                tranDir = data.getRowIndex();
            }
            if (tranDir == 1) {
                result.setDrCr("CR");
                result.setBankSsn(data.getBusiSsn());
                result.setRemark(busiDescr + " \u6211\u6709,\u94f6\u884c\u65e0\u5165\u5e10\u8bb0\u5f55");
                continue;
            }
            if (tranDir == 2) {
                result.setResultType(CHECK_TIME_DETAIL);
                result.setDrCr("DR");
                result.setBankSsn(data.getSsn());
                result.setRemark(busiDescr + " \u6211\u6709,\u94f6\u884c\u65e0\u51fa\u5e10\u8bb0\u5f55," + this.dateToStr(data.getTranDate(), "MMdd HH:mm:ss"));
                continue;
            }
            result.setRemark(busiDescr + " \u6211\u6709\u94f6\u884c\u65e0(\u501f\u8d37\u4e0d\u660e)");
        }
        this.batchSubmitResult(resultLs, "[\u6211\u6709\u94f6\u884c\u65e0]\u9519\u8d26\u4ea4\u6613\u660e\u7ec6\u6570\u636e");
        logger.debug("\u5bf9\u8d26,[\u6211\u6709\u94f6\u884c\u65e0] \u9519\u8d26\u8bb0\u5f55\u5904\u7406\u5b8c\u6210");
        return size;
    }

    private long[] launchAllowCheck(AcctCheckingResult result) {
        String txnNo = "" + Rnd.rnd(100000, 900000);
        result.setResultType(9);
        result.setTxnNo(txnNo);
        logger.debug("\u5bf9\u8d26,\u63d0\u4ea4\u7ade\u4e89\u6267\u884c\u6743\u7533\u8bf7,\u7533\u8bf7\u7801=" + txnNo);
        this.resultMapper.insertHolder(result);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        result.setTxnNo(null);
        List<AcctCheckingResult> ls = this.resultMapper.selectSelective(result);
        logger.debug("\u5bf9\u8d26,\u67e5\u8be2\u5e76\u53d1\u7ade\u4e89\u6267\u884c\u6743\u7801\u7684\u8bb0\u5f55,\u6570\u91cf=" + ls.size());
        if (ls.size() > 0) {
            long[] ids = new long[ls.size()];
            String txn = "";
            for (int i = 0; i < ls.size(); ++i) {
                long id;
                AcctCheckingResult rec = ls.get(i);
                ids[i] = id = rec.getId().longValue();
                if (i != 0) continue;
                txn = rec.getTxnNo();
            }
            logger.debug("\u5bf9\u8d26\u5904\u7406,\u53ef\u6267\u884c\u5904\u7406\u5224\u65ad,\u4f18\u5148\u7801(\u53ef\u6267\u884c)=" + txn + ",\u672c\u673a\u7533\u8bf7\u7801=" + txnNo);
            if (txnNo.equals(txn)) {
                logger.debug("-----\u83b7\u5f97\u6279\u91cf\u5bf9\u8d26\u6267\u884c\u6743");
                return ids;
            }
        } else {
            return null;
        }
        logger.debug("\u5bf9\u8d26\u5904\u7406,\u672c\u673a\u672a\u83b7\u5f97\u5904\u7406\u4f18\u5148\u6743,\u9000\u51fa\u5904\u7406");
        return null;
    }

    private Date getYestoday(Date date) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(5, -1);
        return cal.getTime();
    }

    private String dateToStr(Date date, String fmtStr) {
        SimpleDateFormat fmt = new SimpleDateFormat(fmtStr);
        return fmt.format(date);
    }
}

